/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.serverfactory;

import io.grpc.inprocess.InProcessServerBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import net.devh.boot.grpc.server.serverfactory.AbstractGrpcServerFactory;
import net.devh.boot.grpc.server.serverfactory.GrpcServerConfigurer;

public class InProcessGrpcServerFactory
extends AbstractGrpcServerFactory<InProcessServerBuilder> {
    private final String name;

    public InProcessGrpcServerFactory(GrpcServerProperties properties) {
        this(properties.getInProcessName(), properties);
    }

    public InProcessGrpcServerFactory(GrpcServerProperties properties, List<GrpcServerConfigurer> serverConfigurers) {
        this(properties.getInProcessName(), properties, serverConfigurers);
    }

    public InProcessGrpcServerFactory(String name, GrpcServerProperties properties) {
        this(name, properties, Collections.emptyList());
    }

    public InProcessGrpcServerFactory(String name, GrpcServerProperties properties, List<GrpcServerConfigurer> serverConfigurers) {
        super(properties, serverConfigurers);
        this.name = Objects.requireNonNull(name, "name");
    }

    @Override
    protected InProcessServerBuilder newServerBuilder() {
        return InProcessServerBuilder.forName((String)this.name);
    }

    @Override
    protected void configureSecurity(InProcessServerBuilder builder) {
    }

    @Override
    public String getAddress() {
        return "in-process:" + this.name;
    }

    @Override
    public int getPort() {
        return -1;
    }
}

