/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.serverfactory;

import com.google.common.net.InetAddresses;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import net.devh.boot.grpc.common.security.KeyStoreUtils;
import net.devh.boot.grpc.common.util.GrpcUtils;
import net.devh.boot.grpc.server.config.ClientAuth;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import net.devh.boot.grpc.server.serverfactory.AbstractGrpcServerFactory;
import net.devh.boot.grpc.server.serverfactory.GrpcServerConfigurer;
import org.springframework.core.io.Resource;

public class ShadedNettyGrpcServerFactory
extends AbstractGrpcServerFactory<NettyServerBuilder> {
    public ShadedNettyGrpcServerFactory(GrpcServerProperties properties, List<GrpcServerConfigurer> serverConfigurers) {
        super(properties, serverConfigurers);
    }

    @Override
    protected NettyServerBuilder newServerBuilder() {
        String address = this.getAddress();
        int port = this.getPort();
        if (address.startsWith("unix:")) {
            String path = GrpcUtils.extractDomainSocketAddressPath((String)address);
            return NettyServerBuilder.forAddress((SocketAddress)new DomainSocketAddress(path)).channelType(EpollServerDomainSocketChannel.class).bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1)).workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup());
        }
        if ("*".equals(address)) {
            return NettyServerBuilder.forPort((int)port);
        }
        return NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(InetAddresses.forString((String)address), port));
    }

    @Override
    protected void configureConnectionLimits(NettyServerBuilder builder) {
        if (this.properties.getMaxConnectionIdle() != null) {
            builder.maxConnectionIdle(this.properties.getMaxConnectionIdle().toNanos(), TimeUnit.NANOSECONDS);
        }
        if (this.properties.getMaxConnectionAge() != null) {
            builder.maxConnectionAge(this.properties.getMaxConnectionAge().toNanos(), TimeUnit.NANOSECONDS);
        }
        if (this.properties.getMaxConnectionAgeGrace() != null) {
            builder.maxConnectionAgeGrace(this.properties.getMaxConnectionAgeGrace().toNanos(), TimeUnit.NANOSECONDS);
        }
    }

    @Override
    protected void configureKeepAlive(NettyServerBuilder builder) {
        if (this.properties.isEnableKeepAlive()) {
            builder.keepAliveTime(this.properties.getKeepAliveTime().toNanos(), TimeUnit.NANOSECONDS).keepAliveTimeout(this.properties.getKeepAliveTimeout().toNanos(), TimeUnit.NANOSECONDS);
        }
        builder.permitKeepAliveTime(this.properties.getPermitKeepAliveTime().toNanos(), TimeUnit.NANOSECONDS).permitKeepAliveWithoutCalls(this.properties.isPermitKeepAliveWithoutCalls());
    }

    @Override
    protected void configureSecurity(NettyServerBuilder builder) {
        GrpcServerProperties.Security security = this.properties.getSecurity();
        if (security.isEnabled()) {
            SslContextBuilder sslContextBuilder = ShadedNettyGrpcServerFactory.newServerSslContextBuilder(security);
            ShadedNettyGrpcServerFactory.configureAcceptedClientCertificates(security, sslContextBuilder);
            if (security.getCiphers() != null && !security.getCiphers().isEmpty()) {
                sslContextBuilder.ciphers(security.getCiphers());
            }
            if (security.getProtocols() != null && security.getProtocols().length > 0) {
                sslContextBuilder.protocols(security.getProtocols());
            }
            try {
                builder.sslContext(sslContextBuilder.build());
            }
            catch (SSLException e) {
                throw new IllegalStateException("Failed to create ssl context for grpc server", e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected static SslContextBuilder newServerSslContextBuilder(GrpcServerProperties.Security security) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static void configureAcceptedClientCertificates(GrpcServerProperties.Security security, SslContextBuilder sslContextBuilder) {
        block17: {
            if (security.getClientAuth() != ClientAuth.NONE) {
                sslContextBuilder.clientAuth(ShadedNettyGrpcServerFactory.of(security.getClientAuth()));
                try {
                    Resource trustCertCollection = security.getTrustCertCollection();
                    Resource trustStore = security.getTrustStore();
                    if (trustCertCollection != null) {
                        try (InputStream trustCertCollectionStream = trustCertCollection.getInputStream();){
                            sslContextBuilder.trustManager(trustCertCollectionStream);
                            break block17;
                        }
                    }
                    if (trustStore != null) {
                        TrustManagerFactory trustManagerFactory = KeyStoreUtils.loadTrustManagerFactory((String)security.getTrustStoreFormat(), (Resource)trustStore, (String)security.getTrustStorePassword());
                        sslContextBuilder.trustManager(trustManagerFactory);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to create SSLContext (TrustStore)", e);
                }
            }
        }
    }

    protected static io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth of(ClientAuth clientAuth) {
        switch (clientAuth) {
            case NONE: {
                return io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth.NONE;
            }
            case OPTIONAL: {
                return io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth.OPTIONAL;
            }
            case REQUIRE: {
                return io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth.REQUIRE;
            }
        }
        throw new IllegalArgumentException("Unsupported ClientAuth: " + (Object)((Object)clientAuth));
    }
}

