/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.dongliu.apk.parser.AbstractApkParser;
import net.dongliu.apk.parser.bean.ApkSignStatus;
import net.dongliu.apk.parser.utils.Utils;

public class ByteArrayApkParser
extends AbstractApkParser
implements Closeable {
    private byte[] apkData;

    public ByteArrayApkParser(byte[] apkData) {
        this.apkData = apkData;
    }

    @Override
    protected byte[] getCertificateData() throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(this.apkData);
             ZipInputStream zis = new ZipInputStream(in);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().toUpperCase().endsWith(".RSA") && !entry.getName().toUpperCase().endsWith(".DSA")) continue;
                byte[] byArray = Utils.toByteArray(zis);
                return byArray;
            }
        }
        return null;
    }

    @Override
    public byte[] getFileData(String path) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(this.apkData);
             ZipInputStream zis = new ZipInputStream(in);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!path.equals(entry.getName())) continue;
                byte[] byArray = Utils.toByteArray(zis);
                return byArray;
            }
        }
        return null;
    }

    @Override
    public ApkSignStatus verifyApk() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.apkData = null;
    }
}

