/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.dreamlu.mica.core.utils.Exceptions;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;

public class IoUtil
extends StreamUtils {
    public static void closeQuietly(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        if (closeable instanceof Flushable) {
            Flushable flushable = (Flushable)((Object)closeable);
            try {
                flushable.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String readToString(InputStream input) {
        return IoUtil.readToString(input, StandardCharsets.UTF_8);
    }

    public static String readToString(@Nullable InputStream input, Charset charset) {
        try {
            String string = StreamUtils.copyToString((InputStream)input, (Charset)charset);
            return string;
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
        finally {
            IoUtil.closeQuietly(input);
        }
    }

    public static byte[] readToByteArray(@Nullable InputStream input) {
        try {
            byte[] byArray = StreamUtils.copyToByteArray((InputStream)input);
            return byArray;
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
        finally {
            IoUtil.closeQuietly(input);
        }
    }

    public static void write(@Nullable String data, OutputStream output, Charset encoding) throws IOException {
        if (data != null) {
            output.write(data.getBytes(encoding));
        }
    }
}

