/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.io.IOException;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.core.utils.IoUtil;
import net.dreamlu.mica.core.utils.StringUtil;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;

public class ResourceUtil
extends ResourceUtils {
    public static final String FTP_URL_PREFIX = "ftp:";

    public static Resource getResource(String resourceLocation) throws IOException {
        Assert.notNull((Object)resourceLocation, (String)"Resource location must not be null");
        if (resourceLocation.startsWith("classpath:")) {
            String path = resourceLocation.substring("classpath:".length());
            return new ClassPathResource(path);
        }
        if (resourceLocation.startsWith(FTP_URL_PREFIX)) {
            return new UrlResource(resourceLocation);
        }
        if (StringUtil.isHttpUrl(resourceLocation)) {
            return new UrlResource(resourceLocation);
        }
        if (resourceLocation.startsWith("file:")) {
            return new FileUrlResource(resourceLocation);
        }
        return new FileSystemResource(resourceLocation);
    }

    public static String getAsString(String resourceLocation) {
        try {
            Resource resource = ResourceUtil.getResource(resourceLocation);
            return IoUtil.readToString(resource.getInputStream());
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }
}

