/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.logging.config;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.dreamlu.mica.core.utils.ObjectUtil;
import net.dreamlu.mica.logging.appender.Appender;
import net.dreamlu.mica.logging.appender.ILoggingAppender;
import net.dreamlu.mica.logging.appender.LoggingFileAppender;
import net.dreamlu.mica.logging.appender.LoggingJsonFileAppender;
import net.dreamlu.mica.logging.appender.LoggingLogStashAppender;
import net.dreamlu.mica.logging.appender.LoggingLokiAppender;
import net.dreamlu.mica.logging.config.MicaLoggingProperties;
import net.dreamlu.mica.logging.listener.LogbackLoggerContextListener;
import net.dreamlu.mica.logging.listener.LoggingStartedEventListener;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;

@AutoConfiguration
@Order(value=-2147483648)
@EnableConfigurationProperties(value={MicaLoggingProperties.class})
public class MicaLoggingConfiguration {
    @Bean
    public LoggingStartedEventListener loggingStartedEventListener(MicaLoggingProperties loggingProperties) {
        return new LoggingStartedEventListener(loggingProperties);
    }

    @Bean
    public LogbackLoggerContextListener logbackLoggerContextListener(ObjectProvider<ILoggingAppender> loggingAppenderObjectProvider) {
        List<ILoggingAppender> loggingAppenderList = loggingAppenderObjectProvider.orderedStream().collect(Collectors.toList());
        return new LogbackLoggerContextListener(loggingAppenderList);
    }

    @Order(value=-2147483648)
    private static class LoggingCondition
    extends SpringBootCondition {
        private static final String LOG_STASH_CLASS_NAME = "net.logstash.logback.encoder.LoggingEventCompositeJsonEncoder";
        private static final String LOKI_CLASS_NAME = "com.github.loki4j.logback.Loki4jAppender";

        private LoggingCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Map attributes = metadata.getAnnotationAttributes(ConditionalOnAppender.class.getName());
            Object value = Objects.requireNonNull(attributes).get("value");
            Appender appender = Appender.valueOf(value.toString());
            Environment environment = context.getEnvironment();
            ClassLoader classLoader = context.getClassLoader();
            Boolean fileEnabled = (Boolean)environment.getProperty("mica.logging.files.enabled", Boolean.class, (Object)Boolean.TRUE);
            Boolean logStashEnabled = (Boolean)environment.getProperty("mica.logging.logstash.enabled", Boolean.class, (Object)Boolean.FALSE);
            Boolean lokiEnabled = (Boolean)environment.getProperty("mica.logging.loki.enabled", Boolean.class, (Object)Boolean.FALSE);
            if (Appender.LOKI == appender) {
                if (ObjectUtil.isFalse((Boolean)lokiEnabled)) {
                    return ConditionOutcome.noMatch((String)"Logging loki is not enabled.");
                }
                if (LoggingCondition.hasLokiDependencies(classLoader)) {
                    return ConditionOutcome.match();
                }
                throw new IllegalStateException("Logging loki is enabled, please add com.github.loki4j loki-logback-appender dependencies.");
            }
            if (Appender.LOG_STASH == appender) {
                if (ObjectUtil.isFalse((Boolean)logStashEnabled)) {
                    return ConditionOutcome.noMatch((String)"Logging logstash is not enabled.");
                }
                if (LoggingCondition.hasLogStashDependencies(classLoader)) {
                    return ConditionOutcome.match();
                }
                throw new IllegalStateException("Logging logstash is enabled, please add logstash-logback-encoder dependencies.");
            }
            if (Appender.FILE_JSON == appender) {
                Boolean isUseJsonFormat = (Boolean)environment.getProperty("mica.logging.files.use-json-format", Boolean.class, (Object)Boolean.FALSE);
                if (ObjectUtil.isFalse((Boolean)fileEnabled) || ObjectUtil.isFalse((Boolean)isUseJsonFormat)) {
                    return ConditionOutcome.noMatch((String)"Logging json file is not enabled.");
                }
                if (LoggingCondition.hasLogStashDependencies(classLoader)) {
                    return ConditionOutcome.match();
                }
                throw new IllegalStateException("Logging file json format is enabled, please add logstash-logback-encoder dependencies.");
            }
            if (Appender.FILE == appender) {
                if (ObjectUtil.isFalse((Boolean)fileEnabled)) {
                    return ConditionOutcome.noMatch((String)"Logging logstash is not enabled.");
                }
                return ConditionOutcome.match();
            }
            return ConditionOutcome.match();
        }

        private static boolean hasLogStashDependencies(ClassLoader classLoader) {
            return ClassUtils.isPresent((String)LOG_STASH_CLASS_NAME, (ClassLoader)classLoader);
        }

        private static boolean hasLokiDependencies(ClassLoader classLoader) {
            return ClassUtils.isPresent((String)LOKI_CLASS_NAME, (ClassLoader)classLoader);
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Conditional(value={LoggingCondition.class})
    private static @interface ConditionalOnAppender {
        public Appender value();
    }

    @AutoConfiguration
    @ConditionalOnAppender(value=Appender.LOKI)
    public static class LoggingLokiConfiguration {
        @Bean
        public LoggingLokiAppender loggingLokiAppender(Environment environment, MicaLoggingProperties properties) {
            return new LoggingLokiAppender(environment, properties);
        }
    }

    @AutoConfiguration
    @ConditionalOnAppender(value=Appender.LOG_STASH)
    public static class LoggingLogStashConfiguration {
        @Bean
        public LoggingLogStashAppender loggingLogStashAppender(Environment environment, MicaLoggingProperties properties) {
            return new LoggingLogStashAppender(environment, properties);
        }
    }

    @AutoConfiguration
    @ConditionalOnAppender(value=Appender.FILE_JSON)
    public static class LoggingJsonFileConfiguration {
        @Bean
        public LoggingJsonFileAppender loggingJsonFileAppender(Environment environment, MicaLoggingProperties properties) {
            return new LoggingJsonFileAppender(environment, properties);
        }
    }

    @AutoConfiguration
    @ConditionalOnAppender(value=Appender.FILE)
    public static class LoggingFileConfiguration {
        @Bean
        public LoggingFileAppender loggingFileAppender(Environment environment, MicaLoggingProperties properties) {
            return new LoggingFileAppender(environment, properties);
        }
    }
}

