/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.logging.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.util.ClassUtils;

@RefreshScope
@ConfigurationProperties(value="mica.logging")
public class MicaLoggingProperties {
    public static final String PREFIX = "mica.logging";
    private final Console console = new Console();
    private final Files files = new Files();
    private final Logstash logstash = new Logstash();
    private final Loki loki = new Loki();

    public Console getConsole() {
        return this.console;
    }

    public Files getFiles() {
        return this.files;
    }

    public Logstash getLogstash() {
        return this.logstash;
    }

    public Loki getLoki() {
        return this.loki;
    }

    public static enum HttpSender {
        JAVA11("java.net.http.HttpClient"),
        OKHttp("okhttp3.OkHttpClient"),
        ApacheHttp("org.apache.http.impl.client.HttpClients");

        private final String senderClass;

        public boolean isAvailable() {
            return ClassUtils.isPresent((String)this.senderClass, null);
        }

        public String getSenderClass() {
            return this.senderClass;
        }

        private HttpSender(String senderClass) {
            this.senderClass = senderClass;
        }
    }

    public static enum LokiEncoder {
        Json,
        ProtoBuf;

    }

    public static class Loki {
        public static final String PREFIX = "mica.logging.loki";
        private boolean enabled = false;
        private LokiEncoder encoder = LokiEncoder.Json;
        private HttpSender httpSender;
        private int batchMaxItems = 1000;
        private int batchMaxBytes = 0x400000;
        private long batchTimeoutMs = 60000L;
        private long sendQueueMaxBytes = 0x2800000L;
        private boolean useDirectBuffers = true;
        private boolean drainOnStop = true;
        private boolean metricsEnabled = false;
        private boolean verbose = false;
        private String httpUrl = "http://localhost:3100/loki/api/v1/push";
        private long httpConnectionTimeoutMs = 30000L;
        private long httpRequestTimeoutMs = 5000L;
        private String httpAuthUsername;
        private String httpAuthPassword;
        private String httpTenantId;
        private String formatLabelPattern = "appName=${appName},profile=${profile},host=${HOSTNAME},level=%level,traceId=%X{traceId:-NAN},requestId=%X{requestId:-NAN}";
        private String formatLabelPatternExtend;
        private String formatLabelPairSeparator = ",";
        private String formatLabelKeyValueSeparator = "=";
        private boolean formatLabelNoPex = true;
        private String formatMessagePattern;
        private boolean formatStaticLabels = false;
        private boolean formatSortByTime = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public LokiEncoder getEncoder() {
            return this.encoder;
        }

        public HttpSender getHttpSender() {
            return this.httpSender;
        }

        public int getBatchMaxItems() {
            return this.batchMaxItems;
        }

        public int getBatchMaxBytes() {
            return this.batchMaxBytes;
        }

        public long getBatchTimeoutMs() {
            return this.batchTimeoutMs;
        }

        public long getSendQueueMaxBytes() {
            return this.sendQueueMaxBytes;
        }

        public boolean isUseDirectBuffers() {
            return this.useDirectBuffers;
        }

        public boolean isDrainOnStop() {
            return this.drainOnStop;
        }

        public boolean isMetricsEnabled() {
            return this.metricsEnabled;
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        public String getHttpUrl() {
            return this.httpUrl;
        }

        public long getHttpConnectionTimeoutMs() {
            return this.httpConnectionTimeoutMs;
        }

        public long getHttpRequestTimeoutMs() {
            return this.httpRequestTimeoutMs;
        }

        public String getHttpAuthUsername() {
            return this.httpAuthUsername;
        }

        public String getHttpAuthPassword() {
            return this.httpAuthPassword;
        }

        public String getHttpTenantId() {
            return this.httpTenantId;
        }

        public String getFormatLabelPattern() {
            return this.formatLabelPattern;
        }

        public String getFormatLabelPatternExtend() {
            return this.formatLabelPatternExtend;
        }

        public String getFormatLabelPairSeparator() {
            return this.formatLabelPairSeparator;
        }

        public String getFormatLabelKeyValueSeparator() {
            return this.formatLabelKeyValueSeparator;
        }

        public boolean isFormatLabelNoPex() {
            return this.formatLabelNoPex;
        }

        public String getFormatMessagePattern() {
            return this.formatMessagePattern;
        }

        public boolean isFormatStaticLabels() {
            return this.formatStaticLabels;
        }

        public boolean isFormatSortByTime() {
            return this.formatSortByTime;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setEncoder(LokiEncoder encoder) {
            this.encoder = encoder;
        }

        public void setHttpSender(HttpSender httpSender) {
            this.httpSender = httpSender;
        }

        public void setBatchMaxItems(int batchMaxItems) {
            this.batchMaxItems = batchMaxItems;
        }

        public void setBatchMaxBytes(int batchMaxBytes) {
            this.batchMaxBytes = batchMaxBytes;
        }

        public void setBatchTimeoutMs(long batchTimeoutMs) {
            this.batchTimeoutMs = batchTimeoutMs;
        }

        public void setSendQueueMaxBytes(long sendQueueMaxBytes) {
            this.sendQueueMaxBytes = sendQueueMaxBytes;
        }

        public void setUseDirectBuffers(boolean useDirectBuffers) {
            this.useDirectBuffers = useDirectBuffers;
        }

        public void setDrainOnStop(boolean drainOnStop) {
            this.drainOnStop = drainOnStop;
        }

        public void setMetricsEnabled(boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public void setHttpUrl(String httpUrl) {
            this.httpUrl = httpUrl;
        }

        public void setHttpConnectionTimeoutMs(long httpConnectionTimeoutMs) {
            this.httpConnectionTimeoutMs = httpConnectionTimeoutMs;
        }

        public void setHttpRequestTimeoutMs(long httpRequestTimeoutMs) {
            this.httpRequestTimeoutMs = httpRequestTimeoutMs;
        }

        public void setHttpAuthUsername(String httpAuthUsername) {
            this.httpAuthUsername = httpAuthUsername;
        }

        public void setHttpAuthPassword(String httpAuthPassword) {
            this.httpAuthPassword = httpAuthPassword;
        }

        public void setHttpTenantId(String httpTenantId) {
            this.httpTenantId = httpTenantId;
        }

        public void setFormatLabelPattern(String formatLabelPattern) {
            this.formatLabelPattern = formatLabelPattern;
        }

        public void setFormatLabelPatternExtend(String formatLabelPatternExtend) {
            this.formatLabelPatternExtend = formatLabelPatternExtend;
        }

        public void setFormatLabelPairSeparator(String formatLabelPairSeparator) {
            this.formatLabelPairSeparator = formatLabelPairSeparator;
        }

        public void setFormatLabelKeyValueSeparator(String formatLabelKeyValueSeparator) {
            this.formatLabelKeyValueSeparator = formatLabelKeyValueSeparator;
        }

        public void setFormatLabelNoPex(boolean formatLabelNoPex) {
            this.formatLabelNoPex = formatLabelNoPex;
        }

        public void setFormatMessagePattern(String formatMessagePattern) {
            this.formatMessagePattern = formatMessagePattern;
        }

        public void setFormatStaticLabels(boolean formatStaticLabels) {
            this.formatStaticLabels = formatStaticLabels;
        }

        public void setFormatSortByTime(boolean formatSortByTime) {
            this.formatSortByTime = formatSortByTime;
        }
    }

    public static class Logstash {
        public static final String PREFIX = "mica.logging.logstash";
        private boolean enabled = false;
        private String destinations = "localhost:5000";
        private Map<String, Object> customFieldMap = new HashMap<String, Object>();
        private int ringBufferSize = 512;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getDestinations() {
            return this.destinations;
        }

        public Map<String, Object> getCustomFieldMap() {
            return this.customFieldMap;
        }

        public int getRingBufferSize() {
            return this.ringBufferSize;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setDestinations(String destinations) {
            this.destinations = destinations;
        }

        public void setCustomFieldMap(Map<String, Object> customFieldMap) {
            this.customFieldMap = customFieldMap;
        }

        public void setRingBufferSize(int ringBufferSize) {
            this.ringBufferSize = ringBufferSize;
        }
    }

    public static class Files {
        public static final String PREFIX = "mica.logging.files";
        private boolean enabled = true;
        private boolean useJsonFormat = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isUseJsonFormat() {
            return this.useJsonFormat;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setUseJsonFormat(boolean useJsonFormat) {
            this.useJsonFormat = useJsonFormat;
        }
    }

    public static class Console {
        private boolean closeAfterStart = false;

        public boolean isCloseAfterStart() {
            return this.closeAfterStart;
        }

        public void setCloseAfterStart(boolean closeAfterStart) {
            this.closeAfterStart = closeAfterStart;
        }
    }
}

