/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.core.exception;

import java.util.Locale;
import net.guerlab.commons.exception.ApplicationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.lang.Nullable;

public abstract class AbstractI18nApplicationException
extends ApplicationException {
    private static final long serialVersionUID = 1L;
    private static final String EMPTY_KEY = "";

    protected AbstractI18nApplicationException() {
    }

    protected AbstractI18nApplicationException(int errorCode) {
        super(errorCode);
    }

    protected AbstractI18nApplicationException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    protected AbstractI18nApplicationException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, int errorCode) {
        super(message, cause, enableSuppression, writableStackTrace, errorCode);
    }

    protected AbstractI18nApplicationException(String message, Throwable cause) {
        super(message, cause);
    }

    protected AbstractI18nApplicationException(String message, Throwable cause, int errorCode) {
        super(message, cause, errorCode);
    }

    protected AbstractI18nApplicationException(String message) {
        super(message);
    }

    protected AbstractI18nApplicationException(String message, int errorCode) {
        super(message, errorCode);
    }

    protected AbstractI18nApplicationException(Throwable cause) {
        super(cause);
    }

    protected AbstractI18nApplicationException(Throwable cause, int errorCode) {
        super(cause, errorCode);
    }

    @Nullable
    public final String getMessage(MessageSource messageSource) {
        String key = this.getKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            return this.getDefaultMessage();
        }
        Locale locale = LocaleContextHolder.getLocale();
        return messageSource.getMessage(key, this.getArgs(), this.getDefaultMessage(), locale);
    }

    protected String getKey() {
        return EMPTY_KEY;
    }

    protected Object[] getArgs() {
        return new Object[0];
    }

    protected String getDefaultMessage() {
        return this.getLocalizedMessage();
    }
}

