/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.core.result;

import java.util.Collection;
import java.util.Collections;
import org.springframework.lang.Nullable;

public class Pageable<T> {
    public static final Pageable EMPTY = new EmptyPageable();
    private Collection<T> list = Collections.emptyList();
    private long count = 0L;
    private long pageSize = 10L;
    private long currentPageId = 1L;
    private long maxPageId = 1L;

    public Pageable() {
    }

    public Pageable(int pageSize) {
        this.pageSize = pageSize;
    }

    public Pageable(long pageSize, long count) {
        this.pageSize = pageSize;
        this.count = count;
    }

    public Pageable(long pageSize, long count, @Nullable Collection<T> dataList) {
        this(pageSize, count);
        if (dataList != null) {
            this.list = dataList;
        }
    }

    public static <T> Pageable<T> empty() {
        return EMPTY;
    }

    public Collection<T> getList() {
        return this.list;
    }

    public long getCount() {
        return this.count;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public long getCurrentPageId() {
        return this.currentPageId;
    }

    public long getMaxPageId() {
        return this.maxPageId;
    }

    public void setList(Collection<T> list) {
        this.list = list;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public void setCurrentPageId(long currentPageId) {
        this.currentPageId = currentPageId;
    }

    public void setMaxPageId(long maxPageId) {
        this.maxPageId = maxPageId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pageable)) {
            return false;
        }
        Pageable other = (Pageable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getCurrentPageId() != other.getCurrentPageId()) {
            return false;
        }
        if (this.getMaxPageId() != other.getMaxPageId()) {
            return false;
        }
        Collection<T> this$list = this.getList();
        Collection<T> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pageable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $count = this.getCount();
        result = result * 59 + (int)($count >>> 32 ^ $count);
        long $pageSize = this.getPageSize();
        result = result * 59 + (int)($pageSize >>> 32 ^ $pageSize);
        long $currentPageId = this.getCurrentPageId();
        result = result * 59 + (int)($currentPageId >>> 32 ^ $currentPageId);
        long $maxPageId = this.getMaxPageId();
        result = result * 59 + (int)($maxPageId >>> 32 ^ $maxPageId);
        Collection<T> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public String toString() {
        return "Pageable(list=" + this.getList() + ", count=" + this.getCount() + ", pageSize=" + this.getPageSize() + ", currentPageId=" + this.getCurrentPageId() + ", maxPageId=" + this.getMaxPageId() + ")";
    }

    private static class EmptyPageable<E>
    extends Pageable<E> {
        private EmptyPageable() {
        }

        @Override
        public void setList(Collection<E> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCount(long count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPageSize(long pageSize) {
            throw new UnsupportedOperationException();
        }
    }
}

