/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.base.exception.BusinessException;
import net.mingsoft.basic.action.BaseFileAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.UploadConfigBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.config.MSProperties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u57fa\u7840\u63a5\u53e3")
@Controller(value="ManageFileAction")
@RequestMapping(value={"${ms.manager.path}/file"})
public class ManageFileAction
extends BaseFileAction {
    @Operation(summary="\u5904\u7406post\u8bf7\u6c42\u4e0a\u4f20\u6587\u4ef6")
    @LogAnn(title="\u5904\u7406post\u8bf7\u6c42\u4e0a\u4f20\u6587\u4ef6", businessType=BusinessTypeEnum.OTHER)
    @Parameters(value={@Parameter(name="uploadPath", description="\u4e0a\u4f20\u6587\u4ef6\u5939\u5730\u5740", required=false, in=ParameterIn.QUERY, style=ParameterStyle.FORM), @Parameter(name="file", description="\u6587\u4ef6\u6d41", required=false, style=ParameterStyle.FORM), @Parameter(name="rename", description="\u662f\u5426\u91cd\u547d\u540d", required=false, style=ParameterStyle.FORM, schema=@Schema(defaultValue="true")), @Parameter(name="appId", description="\u4e0a\u4f20\u8def\u5f84\u662f\u5426\u9700\u8981\u62fc\u63a5appId", required=false, style=ParameterStyle.FORM, schema=@Schema(defaultValue="false")), @Parameter(name="uploadFolderPath", description="\u662f\u5426\u4fee\u6539\u4e0a\u4f20\u76ee\u5f55", required=false, style=ParameterStyle.FORM, schema=@Schema(defaultValue="false"))})
    @PostMapping(value={"/upload"}, consumes={"multipart/*"}, headers={"content-type=multipart/form-data"})
    @ResponseBody
    public ResultData upload(@Parameter(hidden=true) UploadConfigBean bean, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (this.checkUploadPath(bean)) {
            return ResultData.build().error();
        }
        if (bean.isAppId()) {
            bean.setUploadPath(BasicUtil.getApp().getAppId() + File.separator + (StringUtils.isNotBlank((CharSequence)bean.getUploadPath()) ? bean.getUploadPath() : ""));
        }
        UploadConfigBean config = new UploadConfigBean(bean.getUploadPath(), bean.getFile(), null, bean.isRename());
        return this.upload(config);
    }

    @Operation(summary="\u5904\u7406post\u8bf7\u6c42\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6")
    @Parameters(value={@Parameter(name="uploadPath", description="\u4e0a\u4f20\u6587\u4ef6\u5939\u5730\u5740", required=false, in=ParameterIn.QUERY, style=ParameterStyle.FORM), @Parameter(name="file", description="\u6587\u4ef6\u6d41", required=false, style=ParameterStyle.FORM), @Parameter(name="rename", description="\u662f\u5426\u91cd\u547d\u540d", required=false, style=ParameterStyle.FORM, schema=@Schema(defaultValue="true")), @Parameter(name="appId", description="\u4e0a\u4f20\u8def\u5f84\u662f\u5426\u9700\u8981\u62fc\u63a5appId", required=false, style=ParameterStyle.FORM, schema=@Schema(defaultValue="false")), @Parameter(name="uploadFolderPath", description="\u662f\u5426\u4fee\u6539\u4e0a\u4f20\u76ee\u5f55", required=false, style=ParameterStyle.FORM, schema=@Schema(defaultValue="false"))})
    @PostMapping(value={"/uploadTemplate"})
    @ResponseBody
    public ResultData uploadTemplate(@Parameter(hidden=true) UploadConfigBean bean, HttpServletResponse res) throws IOException {
        String dataPath;
        String uploadTemplatePath = MSProperties.upload.template;
        if (this.checkUploadPath(bean)) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("file.path")}));
        }
        if (StringUtils.isEmpty((CharSequence)bean.getUploadPath())) {
            bean.setUploadPath(uploadTemplatePath + File.separator + BasicUtil.getApp().getAppId());
        } else if (!bean.getUploadPath().substring(0, uploadTemplatePath.length()).equalsIgnoreCase(uploadTemplatePath)) {
            return ResultData.build().error("uploadPath\u53c2\u6570\u9519\u8bef");
        }
        UploadConfigBean config = new UploadConfigBean(bean.getUploadPath(), bean.getFile(), null, bean.isRename());
        ResultData resultData = this.uploadTemplate(config);
        if (!resultData.isSuccess()) {
            return ResultData.build().error(resultData.getMsg());
        }
        String templateUrl = uploadTemplatePath + File.separator + BasicUtil.getApp().getAppId();
        if (!templateUrl.equals(bean.getUploadPath())) {
            return ResultData.build().success();
        }
        String fileUrl = (String)resultData.get((Object)"data");
        if (fileUrl != null && (fileUrl.contains("../") || fileUrl.contains("..\\"))) {
            return ResultData.build().error();
        }
        File zipFile = new File(BasicUtil.getRealTemplatePath(fileUrl));
        try {
            ZipUtil.unzip((String)zipFile.getPath(), (String)zipFile.getParent(), (Charset)Charset.forName("GBK"));
        }
        catch (Exception e) {
            ZipUtil.unzip((String)zipFile.getPath(), (String)zipFile.getParent(), (Charset)StandardCharsets.UTF_8);
        }
        FileUtil.del((File)zipFile);
        String htmlPath = zipFile.getParent() + "/html";
        if (FileUtil.exist((String)htmlPath)) {
            FileUtil.del((String)htmlPath);
        }
        if (FileUtil.exist((String)(dataPath = zipFile.getParent() + "/data"))) {
            FileUtil.del((String)dataPath);
        }
        List files = FileUtil.loopFiles((String)zipFile.getParent());
        List deniedList = Arrays.stream(MSProperties.upload.denied.split(",")).map(String::toLowerCase).collect(Collectors.toList());
        for (File file : files) {
            FileInputStream fileInputStream = new FileInputStream(file);
            String fileType = FileTypeUtil.getType((File)file).toLowerCase();
            if (deniedList.contains(fileType) || deniedList.contains(FileNameUtil.extName((File)file).toLowerCase())) {
                IOUtils.closeQuietly((InputStream)fileInputStream);
                FileUtil.del((String)zipFile.getParent());
                throw new BusinessException(StrUtil.format((CharSequence)"\u538b\u7f29\u5305\u5185\u6587\u4ef6{}\u6587\u4ef6\u5f02\u5e38", (Object[])new Object[]{file.getName()}));
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
        return ResultData.build().success();
    }

    protected boolean checkUploadPath(UploadConfigBean bean) {
        return bean.getUploadPath() != null && (bean.getUploadPath().contains("../") || bean.getUploadPath().contains("..\\"));
    }
}

