/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.people.action;

import cn.hutool.crypto.digest.DigestUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.FileUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.people.action.BaseAction;
import net.mingsoft.people.bean.PeopleBean;
import net.mingsoft.people.biz.IPeopleBiz;
import net.mingsoft.people.biz.IPeopleUserBiz;
import net.mingsoft.people.constant.Const;
import net.mingsoft.people.entity.PeopleEntity;
import net.mingsoft.people.entity.PeopleUserEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u7528\u6237\u57fa\u7840\u4fe1\u606f\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/people/peopleUser"})
public class PeopleUserAction
extends BaseAction {
    @Autowired
    private IPeopleUserBiz peopleUserBiz;
    @Autowired
    private IPeopleBiz peopleBiz;

    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/people/user/index";
    }

    @ApiOperation(value="\u7528\u6237\u57fa\u7840\u4fe1\u606f\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="peopleName", value="\u7528\u6237\u8d26\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="puSex", value="\u7528\u6237\u6027\u522b", required=false, paramType="query"), @ApiImplicitParam(name="puNickname", value="\u7528\u6237\u6635\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="peopleState", value="\u5ba1\u6838\u72b6\u6001", required=false, paramType="query"), @ApiImplicitParam(name="puRealName", value="\u771f\u5b9e\u59d3\u540d", required=false, paramType="query"), @ApiImplicitParam(name="peopleDateTimes", value="\u6ce8\u518c\u65f6\u95f4\u8303\u56f4\uff0c\u59822019-01-23\u81f32019-01-24", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore PeopleBean peopleUser, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (peopleUser == null) {
            peopleUser = new PeopleBean();
        }
        peopleUser.setPeopleAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List peopleUserList = this.peopleUserBiz.query((BaseEntity)peopleUser);
        EUListBean list = new EUListBean(peopleUserList, (int)BasicUtil.endPage((List)peopleUserList).getTotal());
        return ResultData.build().success((Object)list);
    }

    @GetMapping(value={"/form"})
    public String form(@ModelAttribute PeopleUserEntity peopleUser, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (peopleUser.getPuPeopleId() != null) {
            BaseEntity peopleUserEntity = this.peopleUserBiz.getEntity(peopleUser.getPuPeopleId());
            model.addAttribute("peopleUserEntity", (Object)peopleUserEntity);
        }
        return "/people/user/form";
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u57fa\u7840\u8be6\u60c5\u63a5\u53e3")
    @ApiImplicitParam(name="puPeopleId", value="\u7528\u6237\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore PeopleUserEntity peopleUser, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (peopleUser.getPuPeopleId() <= 0) {
            return ResultData.build().error(this.getResString("err.error", this.getResString("pu.people.id")));
        }
        PeopleUserEntity _peopleUser = (PeopleUserEntity)this.peopleUserBiz.getEntity(peopleUser.getPuPeopleId());
        return ResultData.build().success((Object)_peopleUser);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u57fa\u7840\u4fe1\u606f\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="puRealName", value="\u7528\u6237\u771f\u5b9e\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="peopleName", value="\u767b\u5f55\u8d26\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="peoplePassword", value="\u7528\u6237\u5bc6\u7801", required=true, paramType="query"), @ApiImplicitParam(name="puAddress", value="\u7528\u6237\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="puIcon", value="\u7528\u6237\u5934\u50cf\u56fe\u6807\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="puNickname", value="\u7528\u6237\u6635\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="puSex", value="\u7528\u6237\u6027\u522b", required=false, paramType="query"), @ApiImplicitParam(name="puCard", value="\u8eab\u4efd\u8bc1", required=false, paramType="query")})
    @LogAnn(title="\u4fdd\u5b58\u7528\u6237\u57fa\u7840\u4fe1\u606f\u63a5\u53e3", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"people:save"})
    public ResultData save(@ModelAttribute @ApiIgnore PeopleUserEntity peopleUser, HttpServletResponse response, HttpServletRequest request) {
        if (!StringUtil.checkLength((String)(peopleUser.getPuRealName() + ""), (int)0, (int)50)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("pu.real.name"), "0", "50"));
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuAddress() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("pu.address"), "0", "200"));
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuIcon() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("pu.icon"), "0", "200"));
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuNickname() + ""), (int)0, (int)50)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("pu.nickname"), "0", "50"));
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuSex() + ""), (int)0, (int)10)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("pu.sex"), "0", "10"));
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuCard() + ""), (int)0, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("pu.card"), "0", "255"));
        }
        if (!StringUtils.isBlank((CharSequence)DigestUtil.md5Hex((String)peopleUser.getPeoplePassword()))) {
            peopleUser.setPeoplePassword(DigestUtil.md5Hex((String)peopleUser.getPeoplePassword()));
        }
        if (!this.checkPeople(peopleUser, request, response)) {
            return ResultData.build().error();
        }
        peopleUser.setPeopleDateTime(new Date());
        peopleUser.setPeopleAppId(BasicUtil.getAppId());
        this.peopleUserBiz.savePeople(peopleUser);
        return ResultData.build().success((Object)peopleUser);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7528\u6237\u63a5\u53e3")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u7528\u6237\u63a5\u53e3", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"people:del"})
    public ResultData delete(@RequestBody List<PeopleUserEntity> peopleUsers, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[peopleUsers.size()];
        for (int i = 0; i < peopleUsers.size(); ++i) {
            ids[i] = peopleUsers.get(i).getPuPeopleId();
        }
        FileUtil.del(peopleUsers);
        this.peopleUserBiz.deletePeople(ids);
        return ResultData.build().success();
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u57fa\u7840\u4fe1\u606f\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="puPeopleId", value="\u7528\u6237\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="peopleName", value="\u767b\u5f55\u8d26\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="peoplePassword", value="\u7528\u6237\u5bc6\u7801", required=true, paramType="query"), @ApiImplicitParam(name="puRealName", value="\u7528\u6237\u771f\u5b9e\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="puAddress", value="\u7528\u6237\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="puIcon", value="\u7528\u6237\u5934\u50cf\u56fe\u6807\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="puNickname", value="\u7528\u6237\u6635\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="puSex", value="\u7528\u6237\u6027\u522b", required=false, paramType="query"), @ApiImplicitParam(name="puCard", value="\u8eab\u4efd\u8bc1", required=false, paramType="query")})
    @LogAnn(title="\u4fee\u6539\u7528\u6237\u57fa\u7840\u4fe1\u606f\u63a5\u53e3", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"people:update"})
    public ResultData update(@ModelAttribute @ApiIgnore PeopleUserEntity peopleUser, HttpServletResponse response, HttpServletRequest request) {
        if (!StringUtil.checkLength((String)(peopleUser.getPuRealName() + ""), (int)0, (int)50)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("pu.real.name"), "0", "50"));
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuAddress() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("pu.address"), "0", "200"));
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuIcon() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("pu.icon"), "0", "200"));
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuNickname() + ""), (int)0, (int)50)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("pu.nickname"), "0", "50"));
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuSex() + ""), (int)0, (int)10)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("pu.sex"), "0", "10"));
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuCard() + ""), (int)0, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("pu.card"), "0", "255"));
        }
        if (!this.checkUpdatePeople(peopleUser, request, response)) {
            return ResultData.build().error();
        }
        if (!StringUtils.isBlank((CharSequence)peopleUser.getPeoplePassword())) {
            peopleUser.setPeoplePassword(DigestUtil.md5Hex((String)peopleUser.getPeoplePassword()));
        }
        peopleUser.setPeopleId(peopleUser.getPuPeopleId());
        this.peopleUserBiz.updatePeople(peopleUser);
        return ResultData.build().success((Object)peopleUser);
    }

    public boolean checkUpdatePeople(PeopleUserEntity peopleUser, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity peoplePhone;
        PeopleUserEntity oldPeopleUser = (PeopleUserEntity)this.peopleUserBiz.getEntity(peopleUser.getPuPeopleId());
        int appId = BasicUtil.getAppId();
        if (!StringUtils.isBlank((CharSequence)peopleUser.getPeopleMail()) && !StringUtil.isEmail((String)peopleUser.getPeopleMail()).booleanValue()) {
            ResultData.build().error(this.getResString("people.msg.mail.format.error", Const.RESOURCES));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)peopleUser.getPeopleName())) {
            ResultData.build().error(this.getResString("people.msg.name.error", Const.RESOURCES));
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)peopleUser.getPeoplePhone()) && !StringUtil.isMobile((String)peopleUser.getPeoplePhone())) {
            ResultData.build().error(this.getResString("people.msg.phone.format.error", Const.RESOURCES));
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)peopleUser.getPeopleName())) {
            peoplePhone = this.peopleBiz.getEntityByUserName(peopleUser.getPeopleName(), appId);
            if (StringUtils.isBlank((CharSequence)oldPeopleUser.getPeopleName())) {
                if (peoplePhone != null) {
                    ResultData.build().error(this.getResString("people.register.msg.name.repeat.error", Const.RESOURCES));
                    return false;
                }
            } else if (!oldPeopleUser.getPeopleName().equals(peopleUser.getPeopleName()) && peoplePhone != null) {
                ResultData.build().error(this.getResString("people.register.msg.name.repeat.error", Const.RESOURCES));
                return false;
            }
        }
        if (!StringUtils.isBlank((CharSequence)peopleUser.getPeoplePhone())) {
            peoplePhone = this.peopleBiz.getEntityByUserName(peopleUser.getPeoplePhone(), appId);
            if (StringUtils.isBlank((CharSequence)oldPeopleUser.getPeoplePhone())) {
                if (peoplePhone != null) {
                    ResultData.build().error(this.getResString("people.register.msg.name.repeat.error", Const.RESOURCES));
                    return false;
                }
            } else if (!oldPeopleUser.getPeoplePhone().equals(peopleUser.getPeoplePhone()) && peoplePhone != null) {
                ResultData.build().error(this.getResString("people.register.msg.name.repeat.error", Const.RESOURCES));
                return false;
            }
        }
        if (!StringUtils.isBlank((CharSequence)peopleUser.getPeopleMail())) {
            peoplePhone = this.peopleBiz.getEntityByUserName(peopleUser.getPeopleMail(), appId);
            if (StringUtils.isBlank((CharSequence)oldPeopleUser.getPeopleMail())) {
                if (peoplePhone != null) {
                    ResultData.build().error(this.getResString("people.register.msg.name.repeat.error", Const.RESOURCES));
                    return false;
                }
            } else if (!oldPeopleUser.getPeopleMail().equals(peopleUser.getPeopleMail()) && peoplePhone != null) {
                ResultData.build().error(this.getResString("people.register.msg.name.repeat.error", Const.RESOURCES));
                return false;
            }
        }
        return true;
    }

    public boolean checkPeople(PeopleUserEntity peopleUser, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity peopleMail;
        PeopleEntity peoplePhone;
        int appId = BasicUtil.getAppId();
        if (!StringUtils.isBlank((CharSequence)peopleUser.getPeopleMail()) && !StringUtil.isEmail((String)peopleUser.getPeopleMail()).booleanValue()) {
            ResultData.build().error(this.getResString("people.msg.mail.format.error", Const.RESOURCES));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)peopleUser.getPeopleName())) {
            ResultData.build().error(this.getResString("people.msg.name.error", Const.RESOURCES));
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)peopleUser.getPeoplePhone()) && !StringUtil.isMobile((String)peopleUser.getPeoplePhone())) {
            ResultData.build().error(this.getResString("people.msg.phone.format.error", Const.RESOURCES));
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)peopleUser.getPeopleName()) && (peoplePhone = this.peopleBiz.getEntityByUserName(peopleUser.getPeopleName(), appId)) != null) {
            ResultData.build().error(this.getResString("people.register.msg.name.repeat.error", Const.RESOURCES));
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)peopleUser.getPeoplePhone()) && (peoplePhone = this.peopleBiz.getEntityByUserName(peopleUser.getPeoplePhone(), appId)) != null) {
            ResultData.build().error(this.getResString("people.register.msg.phone.repeat.error", Const.RESOURCES));
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)peopleUser.getPeopleMail()) && (peopleMail = this.peopleBiz.getEntityByUserName(peopleUser.getPeopleMail(), appId)) != null) {
            ResultData.build().error(this.getResString("people.register.msg.mail.repeat.error", Const.RESOURCES));
            return false;
        }
        return true;
    }

    @Deprecated
    @GetMapping(value={"/getEntity"})
    @ResponseBody
    public ResultData getEntity(String peopleId, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)peopleId) || !StringUtil.isInteger((Object)peopleId)) {
            return ResultData.build().error();
        }
        PeopleUserEntity peopleUser = (PeopleUserEntity)this.peopleUserBiz.getEntity(Integer.parseInt(peopleId));
        if (peopleUser == null) {
            return ResultData.build().error();
        }
        return ResultData.build().success((Object)peopleUser);
    }
}

