/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.util;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.SheetSettings;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.VerticalAlignment;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class ExcelUtil {
    public static final String exportExcel(String fileName, String[] titles, List<Object> listContent, HttpServletResponse response) {
        String result = "\u7cfb\u7edf\u63d0\u793a\uff1aExcel\u6587\u4ef6\u5bfc\u51fa\u6210\u529f\uff01";
        try {
            ServletOutputStream os = response.getOutputStream();
            response.reset();
            response.setHeader("Content-disposition", "attachment; filename=" + new String(fileName.getBytes("GB2312"), "ISO8859-1"));
            response.setContentType("application/msexcel");
            WritableWorkbook workbook = Workbook.createWorkbook((OutputStream)os);
            WritableSheet sheet = workbook.createSheet("Sheet1", 0);
            SheetSettings sheetset = sheet.getSettings();
            sheetset.setProtected(false);
            WritableFont NormalFont = new WritableFont(WritableFont.ARIAL, 10);
            WritableFont BoldFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
            WritableCellFormat wcf_center = new WritableCellFormat(BoldFont);
            wcf_center.setBorder(Border.ALL, BorderLineStyle.THIN);
            wcf_center.setVerticalAlignment(VerticalAlignment.CENTRE);
            wcf_center.setAlignment(Alignment.CENTRE);
            wcf_center.setWrap(false);
            WritableCellFormat wcf_left = new WritableCellFormat(NormalFont);
            wcf_left.setBorder(Border.NONE, BorderLineStyle.THIN);
            wcf_left.setVerticalAlignment(VerticalAlignment.CENTRE);
            wcf_left.setAlignment(Alignment.LEFT);
            wcf_left.setWrap(false);
            int i = 0;
            while (i < titles.length) {
                sheet.addCell((WritableCell)new Label(i, 0, titles[i], (CellFormat)wcf_center));
                ++i;
            }
            i = 1;
            for (Object obj : listContent) {
                int j = 0;
                Object[] objectArray = (Object[])obj;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object field = objectArray[n2];
                    if (field instanceof Map) {
                        if (field != null) {
                            Map temp = (Map)field;
                            if (temp.get("format") != null && temp.get("format") instanceof WritableCellFormat) {
                                sheet.addCell((WritableCell)new Label(j, i, field != null ? String.valueOf(temp.get("value")) : "", (CellFormat)((WritableCellFormat)temp.get("format"))));
                            } else {
                                sheet.addCell((WritableCell)new Label(j, i, field != null ? String.valueOf(field) : "", (CellFormat)wcf_left));
                            }
                        }
                    } else {
                        sheet.addCell((WritableCell)new Label(j, i, field != null ? String.valueOf(field) : "", (CellFormat)wcf_left));
                    }
                    ++j;
                    ++n2;
                }
                ++i;
            }
            workbook.write();
            workbook.close();
        }
        catch (Exception e) {
            result = "\u7cfb\u7edf\u63d0\u793a\uff1aExcel\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.toString();
            System.out.println(result);
            e.printStackTrace();
        }
        return result;
    }
}

