/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.util;

import com.mingsoft.util.MapKeyComparator;
import com.mingsoft.util.MapValueComparator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.sql.Date;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static StringBuilder sb = new StringBuilder();

    public static boolean checkEmail(String email) {
        String regex = "^[a-zA-Z][a-zA-Z0-9._-]*\\@\\w+(\\.)*\\w+\\.\\w+$";
        Pattern p = Pattern.compile(regex);
        Matcher matcher = p.matcher(email);
        return matcher.matches();
    }

    public static String formatHTMLIn(String html) {
        html = html.replaceAll("&", "&amp;");
        html = html.replaceAll("<", "&lt;");
        html = html.replaceAll(">", "&gt;");
        html = html.replaceAll("\"", "&quot;");
        return html;
    }

    public static String formatHTMLOut(String html) {
        html = html.replaceAll("&amp;", "&");
        html = html.replaceAll("&lt;", "<");
        html = html.replaceAll("&gt;", ">");
        html = html.replaceAll("&quot;", "\"");
        return html;
    }

    public static String subString(String str, int length) {
        if (StringUtil.isBlank(str)) {
            return "";
        }
        if (str.getBytes().length <= length) {
            return str;
        }
        char[] ch = null;
        ch = str.length() >= length ? str.substring(0, length).toCharArray() : str.toCharArray();
        int readLen = 0;
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < ch.length) {
            String c = String.valueOf(ch[i]);
            if ((readLen += c.getBytes().length) > length) {
                return sb.toString();
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static boolean checkLength(String str, int minLength, int maxLength) {
        if (str != null) {
            int len = str.length();
            if (minLength == 0) {
                return len <= maxLength;
            }
            if (maxLength == 0) {
                return len >= minLength;
            }
            return len >= minLength && len <= maxLength;
        }
        return false;
    }

    public static String decodeStringByUTF8(String str) {
        if (StringUtil.isBlank(str)) {
            return "";
        }
        try {
            return URLDecoder.decode(str, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String encodeStringByUTF8(String str) {
        if (StringUtil.isBlank(str)) {
            return "";
        }
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String isoToUTF8(String str) {
        if (StringUtil.isBlank(str)) {
            return "";
        }
        try {
            return new String(str.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String utf8ToISO(String str) {
        if (StringUtil.isBlank(str)) {
            return "";
        }
        try {
            return new String(str.getBytes("UTF-8"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String utf8Togb2312(String str) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    break;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(str.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    i += 2;
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        String result = sb.toString();
        String res = null;
        try {
            byte[] inputBytes = result.getBytes("8859_1");
            res = new String(inputBytes, "UTF-8");
        }
        catch (Exception exception) {}
        return res;
    }

    public static String getFormatDateStr(java.util.Date date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().equals("") || str.length() < 0;
    }

    public static boolean isBlank(Object str) {
        return str == null || str.toString().trim().equals("") || str.toString().length() < 0;
    }

    public static boolean isBlank(String[] args) {
        return args == null || args.length == 0;
    }

    public static boolean isInteger(String str) {
        if (StringUtil.isBlank(str)) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isInteger(Object str) {
        String temp = "" + str;
        if (StringUtil.isBlank(str)) {
            return false;
        }
        try {
            Integer.parseInt(temp);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String null2String(String str) {
        if (str == null || str.equals("") || str.trim().length() == 0) {
            str = "";
            return "";
        }
        return str;
    }

    public static int string2Int(String str) {
        int valueInt = 0;
        if (!StringUtil.isBlank(str)) {
            valueInt = Integer.parseInt(str);
        }
        return valueInt;
    }

    public static String int2String(int comment) {
        String srt = "";
        srt = Integer.toString(comment);
        return srt;
    }

    public static boolean isMaxZeroInteger(Object str) {
        if (StringUtil.isBlank(str)) {
            return false;
        }
        try {
            int temp = Integer.parseInt(str.toString());
            return temp > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isLong(String str) {
        if (StringUtil.isBlank(str)) {
            return false;
        }
        try {
            Long.parseLong(str);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isLongs(String[] str) {
        try {
            int i = 0;
            while (i < str.length) {
                Long.parseLong(str[i]);
                ++i;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isIntegers(String[] str) {
        try {
            int i = 0;
            while (i < str.length) {
                Integer.parseInt(str[i]);
                ++i;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDoubles(String[] str) {
        try {
            int i = 0;
            while (i < str.length) {
                Double.parseDouble(str[i]);
                ++i;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Deprecated
    public static String Md5(String plainText) {
        StringBuffer buf = new StringBuffer("");
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            byte[] b = md.digest();
            int i = 0;
            int offset = 0;
            while (offset < b.length) {
                i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
                ++offset;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public static String Md5(String plainText, String coding) {
        StringBuffer buf = new StringBuffer("");
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes(coding));
            byte[] b = md.digest();
            int i = 0;
            int offset = 0;
            while (offset < b.length) {
                i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
                ++offset;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public static long[] stringsToLongs(String[] str) {
        long[] lon = new long[str.length];
        int i = 0;
        while (i < lon.length) {
            lon[i] = Long.parseLong(str[i]);
            ++i;
        }
        return lon;
    }

    public static Integer[] stringsToIntegers(String[] str) {
        Integer[] array = new Integer[str.length];
        int i = 0;
        while (i < array.length) {
            array[i] = Integer.parseInt(str[i]);
            ++i;
        }
        return array;
    }

    public static int[] stringsToInts(String[] str) {
        int[] array = new int[str.length];
        int i = 0;
        while (i < array.length) {
            array[i] = Integer.parseInt(str[i]);
            ++i;
        }
        return array;
    }

    public static double[] stringsToDoubles(String[] str) {
        double[] array = new double[str.length];
        int i = 0;
        while (i < array.length) {
            array[i] = Double.parseDouble(str[i]);
            ++i;
        }
        return array;
    }

    public static String[] delLopStrings(String[] str) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < str.length) {
            if (!list.contains(str[i])) {
                list.add(str[i]);
            }
            ++i;
        }
        String[] array = new String[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            array[i2] = (String)list.get(i2);
            ++i2;
        }
        return array;
    }

    public static boolean[] stringsToBooleans(String[] str) {
        boolean[] array = new boolean[str.length];
        int i = 0;
        while (i < array.length) {
            array[i] = Boolean.parseBoolean(str[i]);
            ++i;
        }
        return array;
    }

    public static boolean isTimestamp(String str) {
        try {
            Date.valueOf(str);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int getPageStart(String pageNo) {
        int istart = 1;
        if (StringUtil.isBlank(pageNo)) {
            return istart;
        }
        try {
            istart = Integer.parseInt(pageNo) < 0 ? istart : Integer.parseInt(pageNo);
        }
        catch (NumberFormatException numberFormatException) {}
        return istart;
    }

    public static String getDateSimpleStr() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static Long[] StrToLong(String[] args) {
        if (args == null) {
            return null;
        }
        Long[] _ref = new Long[args.length];
        int i = 0;
        while (i < args.length) {
            _ref[i] = new Long(args[i]);
            ++i;
        }
        return _ref;
    }

    public static Integer[] StrToInteger(String[] args) {
        if (args == null) {
            return null;
        }
        Integer[] _ref = new Integer[args.length];
        int i = 0;
        while (i < args.length) {
            _ref[i] = new Integer(args[i]);
            ++i;
        }
        return _ref;
    }

    public static String getSimpleDateStr(java.util.Date day, String fomStr) {
        SimpleDateFormat format = new SimpleDateFormat(fomStr);
        return format.format(day);
    }

    public static java.util.Date getDateForStr(String str) {
        Date sqlDate = Date.valueOf(str);
        return sqlDate;
    }

    public static java.util.Date addDays(java.util.Date time, int day) {
        if (time == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(time);
        c.set(5, c.get(5) + day);
        return c.getTime();
    }

    public static java.util.Date addMonths(java.util.Date time, int month) {
        if (time == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(time);
        c.set(2, c.get(2) + month);
        return c.getTime();
    }

    public static String getIpStringFromBytes(byte[] ip) {
        sb.delete(0, sb.length());
        sb.append(ip[0] & 0xFF);
        sb.append('.');
        sb.append(ip[1] & 0xFF);
        sb.append('.');
        sb.append(ip[2] & 0xFF);
        sb.append('.');
        sb.append(ip[3] & 0xFF);
        return sb.toString();
    }

    public static boolean isIpEquals(byte[] ip1, byte[] ip2) {
        return ip1[0] == ip2[0] && ip1[1] == ip2[1] && ip1[2] == ip2[2] && ip1[3] == ip2[3];
    }

    public static String getString(byte[] b, int offset, int len, String encoding) {
        try {
            return new String(b, offset, len, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(b, offset, len);
        }
    }

    public static String stringToBinary(byte[] src) {
        int j;
        StringBuffer sb = new StringBuffer();
        byte[][] des = new byte[src.length][16];
        int i = 0;
        while (i < src.length) {
            j = 0;
            while (j < 16) {
                des[i][j] = (byte)(src[i] >> j & 1);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < src.length) {
            j = 0;
            while (j < 16) {
                sb.append(des[i][j]);
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String randomNumber(int len) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        int i = 0;
        while (i < len) {
            sb.append(Math.abs(random.nextInt()) % 10);
            ++i;
        }
        return sb.toString();
    }

    public static String timeForString() {
        Long l = System.currentTimeMillis();
        return String.valueOf(Math.abs(l.intValue()));
    }

    public static String getParString(String str) {
        if (StringUtil.isBlank(str)) {
            return "";
        }
        return str;
    }

    public static boolean isChinese(char chChar) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(chChar);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean isMobile(String phoneNumber) {
        phoneNumber = phoneNumber.trim();
        String pattern = "^[1][1-8][0-9]{9}";
        return phoneNumber.matches(pattern);
    }

    public static String formatResource(Object[] info, String require) {
        require = require.replaceAll("'", "\"");
        String result = MessageFormat.format(require, info);
        return result.replaceAll("\"", "'");
    }

    public static int getDaysBetween(Calendar beginDate, Calendar endDate) {
        if (beginDate.after(endDate)) {
            Calendar swap = beginDate;
            beginDate = endDate;
            endDate = swap;
        }
        int days = endDate.get(6) - beginDate.get(6);
        int y2 = endDate.get(1);
        if (beginDate.get(1) != y2) {
            beginDate = (Calendar)beginDate.clone();
            do {
                days += beginDate.getActualMaximum(6);
                beginDate.add(1, 1);
            } while (beginDate.get(1) != y2);
        }
        return days;
    }

    public static String getFileFix(String filePath) {
        String temp = "";
        if (filePath != null) {
            temp = filePath.substring(filePath.indexOf("."), filePath.length());
        }
        return temp;
    }

    public static String convertStreamToString(InputStream dataFlow) {
        StringBuilder sb;
        block12: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(dataFlow));
            sb = new StringBuilder();
            String line = null;
            try {
                try {
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        dataFlow.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    dataFlow.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                dataFlow.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static String checkStr(String str) {
        String s = null;
        char[] cc = str.toCharArray();
        int i = 0;
        while (i < cc.length) {
            boolean b = StringUtil.isValidChar(cc[i]);
            if (!b) {
                cc[i] = 32;
            }
            ++i;
        }
        s = String.valueOf(cc);
        return s;
    }

    private static boolean isValidChar(char ch) {
        if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
            return true;
        }
        return ch >= '\u4e00' && ch <= Short.MAX_VALUE || ch >= '\u8000' && ch <= '\u952f';
    }

    public static String removeRepeatStr(String content, String target) {
        StringBuffer sb = new StringBuffer(content);
        int i = 0;
        while (i < sb.length() - 1) {
            if (sb.substring(i, i + target.length()).equals(target) && sb.substring(i, i + target.length()).equals(sb.substring(i + 1, i + target.length() + 1))) {
                sb.delete(i, i + target.length());
                if (i + target.length() + 1 > sb.length()) break;
                --i;
            }
            ++i;
        }
        return sb.toString();
    }

    public static Boolean isEmail(String email) {
        boolean tag = true;
        Pattern pattern = Pattern.compile("^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$");
        Matcher mat = pattern.matcher(email);
        if (!mat.find()) {
            tag = false;
        }
        return tag;
    }

    public static String buildUrl(String url, String parm) {
        if (url.indexOf("?") > 0) {
            url = String.valueOf(url) + "&" + parm;
            return url;
        }
        url = String.valueOf(url) + "?" + parm;
        return url;
    }

    public static String buildPath(Object ... params) {
        String temp = "";
        Object[] objectArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            temp = String.valueOf(temp) + File.separator + o;
            ++n2;
        }
        return temp;
    }

    public static String buildUrl(String url, Map parms) {
        Iterator key = parms.keySet().iterator();
        String paramsStr = "";
        while (key.hasNext()) {
            Object temp = key.next();
            if (StringUtil.isBlank(parms.get(temp))) continue;
            if (paramsStr != "") {
                paramsStr = String.valueOf(paramsStr) + "&";
            }
            paramsStr = String.valueOf(paramsStr) + temp + "=" + parms.get(temp);
        }
        if (paramsStr != "") {
            if (url.indexOf("?") > 0) {
                url = String.valueOf(url) + "&" + paramsStr;
                return url;
            }
            url = String.valueOf(url) + "?" + paramsStr;
            return url;
        }
        return url;
    }

    public static String javaProperty2DatabaseCloumn(String property) {
        String[] ss = property.split("(?<!^)(?=[A-Z])");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ss.length) {
            sb.append(ss[i]);
            if (i < ss.length - 1) {
                sb.append("_");
            }
            ++i;
        }
        if (!StringUtil.isBlank(sb)) {
            return sb.toString().toUpperCase();
        }
        return null;
    }

    public static Map<String, String> sortMapByKey(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        TreeMap<String, String> sortMap = new TreeMap<String, String>(new MapKeyComparator());
        sortMap.putAll(map);
        return sortMap;
    }

    public static Map<String, String> sortMapByValue(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
        ArrayList<Map.Entry<String, String>> entryList = new ArrayList<Map.Entry<String, String>>(map.entrySet());
        Collections.sort(entryList, new MapValueComparator());
        Iterator iter = entryList.iterator();
        Map.Entry tmpEntry = null;
        while (iter.hasNext()) {
            tmpEntry = (Map.Entry)iter.next();
            sortedMap.put((String)tmpEntry.getKey(), (String)tmpEntry.getValue());
        }
        return sortedMap;
    }

    public static boolean isExpressNo(String str) {
        if (StringUtil.isBlank(str)) {
            return false;
        }
        if (str.length() == 13) {
            return true;
        }
        if (str.length() == 12) {
            return true;
        }
        return true;
    }
}

