/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.util.Collection;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.J2CacheConfig;
import net.oschina.j2cache.Level1Cache;
import net.oschina.j2cache.Level2Cache;
import net.oschina.j2cache.NullCacheProvider;
import net.oschina.j2cache.caffeine.CaffeineProvider;
import net.oschina.j2cache.ehcache.EhCacheProvider;
import net.oschina.j2cache.ehcache.EhCacheProvider3;
import net.oschina.j2cache.redis.ReadonlyRedisCacheProvider;
import net.oschina.j2cache.redis.RedisCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheProviderHolder {
    private static final Logger log = LoggerFactory.getLogger(CacheProviderHolder.class);
    private static CacheProvider l1_provider;
    private static CacheProvider l2_provider;
    private static CacheExpiredListener listener;

    public static void init(J2CacheConfig config, CacheExpiredListener listener) {
        CacheProviderHolder.listener = listener;
        l1_provider = CacheProviderHolder.loadProviderInstance(config.getL1CacheName());
        if (!l1_provider.isLevel(1)) {
            throw new CacheException(l1_provider.getClass().getName() + " is not level_1 cache provider");
        }
        l1_provider.start(config.getL1CacheProperties());
        log.info("Using L1 CacheProvider : " + l1_provider.getClass().getName());
        l2_provider = CacheProviderHolder.loadProviderInstance(config.getL2CacheName());
        if (!l2_provider.isLevel(2)) {
            throw new CacheException(l2_provider.getClass().getName() + " is not level_2 cache provider");
        }
        l2_provider.start(config.getL2CacheProperties());
        log.info("Using L2 CacheProvider : " + l2_provider.getClass().getName());
    }

    public static final void shutdown() {
        l1_provider.stop();
        l2_provider.stop();
    }

    private static final CacheProvider loadProviderInstance(String cacheIdent) {
        if ("ehcache".equalsIgnoreCase(cacheIdent)) {
            return new EhCacheProvider();
        }
        if ("ehcache3".equalsIgnoreCase(cacheIdent)) {
            return new EhCacheProvider3();
        }
        if ("caffeine".equalsIgnoreCase(cacheIdent)) {
            return new CaffeineProvider();
        }
        if ("redis".equalsIgnoreCase(cacheIdent)) {
            return new RedisCacheProvider();
        }
        if ("readonly-redis".equalsIgnoreCase(cacheIdent)) {
            return new ReadonlyRedisCacheProvider();
        }
        if ("none".equalsIgnoreCase(cacheIdent)) {
            return new NullCacheProvider();
        }
        try {
            return (CacheProvider)Class.forName(cacheIdent).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new CacheException("Failed to initialize cache providers", e);
        }
    }

    public static final CacheProvider getL1Provider() {
        return l1_provider;
    }

    public static final CacheProvider getL2Provider() {
        return l2_provider;
    }

    public static final Level1Cache getLevel1Cache(String region) {
        return (Level1Cache)l1_provider.buildCache(region, listener);
    }

    public static final Level1Cache getLevel1Cache(String region, long timeToLiveSeconds) {
        return (Level1Cache)l1_provider.buildCache(region, timeToLiveSeconds, listener);
    }

    public static final Level2Cache getLevel2Cache(String region) {
        return (Level2Cache)l2_provider.buildCache(region, listener);
    }

    public static final Collection<CacheChannel.Region> regions() {
        return l1_provider.regions();
    }
}

