/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import jline.console.ConsoleReader;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheObject;
import net.oschina.j2cache.J2Cache;

public class J2CacheCmd {
    private static long TTL = 0L;

    public static void main(String[] args) throws IOException {
        CacheChannel cache = J2Cache.getChannel();
        ConsoleReader reader = new ConsoleReader();
        block3: while (true) {
            try {
                String line;
                while ((line = reader.readLine("> ")) != null && !line.equalsIgnoreCase("quit") && !line.equalsIgnoreCase("exit")) {
                    Object keys;
                    String[] cmds = line.split(" ");
                    if ("get".equalsIgnoreCase(cmds[0])) {
                        CacheObject obj2 = cache.get(cmds[1], cmds[2], new boolean[0]);
                        System.out.printf("[%s,%s,L%d]=>%s(TTL:%d)%n", obj2.getRegion(), obj2.getKey(), obj2.getLevel(), obj2.getValue(), TTL);
                        continue;
                    }
                    if ("mget".equalsIgnoreCase(cmds[0])) {
                        keys = Arrays.stream(cmds).skip(2L).collect(Collectors.toList());
                        Map<String, CacheObject> values = cache.get(cmds[1], (Collection<String>)keys);
                        if (values != null && values.size() > 0) {
                            values.forEach((key, obj) -> System.out.printf("[%s,%s,L%d]=>%s(TTL:%d)%n", obj.getRegion(), obj.getKey(), obj.getLevel(), obj.getValue(), TTL));
                            continue;
                        }
                        System.out.println("none!");
                        continue;
                    }
                    if ("set".equalsIgnoreCase(cmds[0])) {
                        if ("null".equalsIgnoreCase(cmds[3])) {
                            cmds[3] = null;
                        }
                        cache.set(cmds[1], cmds[2], cmds[3], TTL, true);
                        System.out.printf("[%s,%s]<=%s(TTL:%d)%n", cmds[1], cmds[2], cmds[3], TTL);
                        continue;
                    }
                    if ("mset".equalsIgnoreCase(cmds[0])) {
                        String region = cmds[1];
                        HashMap<String, Object> objs = new HashMap<String, Object>();
                        for (int i = 2; i < cmds.length; ++i) {
                            String[] obj3 = cmds[i].split(":");
                            if ("null".equalsIgnoreCase(obj3[1])) {
                                obj3[1] = null;
                            }
                            objs.put(obj3[0], obj3[1]);
                        }
                        cache.set(cmds[1], objs, TTL, true);
                        objs.forEach((k, v) -> System.out.printf("[%s,%s]<=%s(TTL:%d)%n", region, k, v, TTL));
                        continue;
                    }
                    if ("evict".equalsIgnoreCase(cmds[0])) {
                        keys = (String[])Arrays.stream(cmds).skip(2L).toArray(String[]::new);
                        cache.evict(cmds[1], (String)keys);
                        for (String key2 : keys) {
                            System.out.printf("[%s,%s]=>null%n", cmds[1], key2);
                        }
                        continue block3;
                    }
                    if ("clear".equalsIgnoreCase(cmds[0])) {
                        cache.clear(cmds[1]);
                        System.out.printf("Cache [%s] clear.%n", cmds[1]);
                        continue;
                    }
                    if ("regions".equalsIgnoreCase(cmds[0])) {
                        System.out.println("Regions:");
                        cache.regions().forEach(r -> System.out.println(r));
                        continue;
                    }
                    if ("keys".equalsIgnoreCase(cmds[0])) {
                        keys = cache.keys(cmds[1]);
                        if (keys != null) {
                            System.out.printf("[%s:keys] => (%s)(TTL:%d)%n", cmds[1], String.join((CharSequence)",", (Iterable<? extends CharSequence>)keys), TTL);
                            continue;
                        }
                        System.out.println("none!");
                        continue;
                    }
                    if ("ttl".equalsIgnoreCase(cmds[0])) {
                        if (cmds.length == 1) {
                            System.out.printf("TTL => %d%n", TTL);
                            continue;
                        }
                        TTL = Long.parseLong(cmds[1]);
                        System.out.printf("TTL <= %d%n", TTL);
                        continue;
                    }
                    if ("help".equalsIgnoreCase(cmds[0])) {
                        J2CacheCmd.printHelp();
                        continue;
                    }
                    System.out.println("Unknown command.");
                    J2CacheCmd.printHelp();
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("Wrong arguments.");
                J2CacheCmd.printHelp();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        cache.close();
        reader.shutdown();
        System.exit(0);
    }

    private static void printHelp() {
        System.out.println("Usage: [cmd] region key [value]");
        System.out.println("cmd: get/mget/set/mset/evict/regions/keys/clear/ttl/quit/exit/help");
        System.out.println("Examples:");
        System.out.println("\tset region key value");
        System.out.println("\tget region key");
        System.out.println("\tmget region key1 key2 key3");
        System.out.println("\tmset region key1:value1 key2:value2 key3:value3");
        System.out.println("\tkeys region");
        System.out.println("\tttl [seconds]");
        System.out.println("\texit");
    }
}

