/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.util.Collection;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.J2CacheConfig;
import net.oschina.j2cache.Level1Cache;
import net.oschina.j2cache.Level2Cache;
import net.oschina.j2cache.NullCacheProvider;
import net.oschina.j2cache.caffeine.CaffeineProvider;
import net.oschina.j2cache.ehcache.EhCacheProvider;
import net.oschina.j2cache.ehcache.EhCacheProvider3;
import net.oschina.j2cache.lettuce.LettuceCacheProvider;
import net.oschina.j2cache.memcached.XmemcachedCacheProvider;
import net.oschina.j2cache.redis.ReadonlyRedisCacheProvider;
import net.oschina.j2cache.redis.RedisCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheProviderHolder {
    private static final Logger log = LoggerFactory.getLogger(CacheProviderHolder.class);
    private CacheProvider l1_provider;
    private CacheProvider l2_provider;
    private CacheExpiredListener listener;

    private CacheProviderHolder() {
    }

    public static CacheProviderHolder init(J2CacheConfig config, CacheExpiredListener listener) {
        CacheProviderHolder holder = new CacheProviderHolder();
        holder.listener = listener;
        holder.l1_provider = CacheProviderHolder.loadProviderInstance(config.getL1CacheName());
        if (!holder.l1_provider.isLevel(1)) {
            throw new CacheException(holder.l1_provider.getClass().getName() + " is not level_1 cache provider");
        }
        holder.l1_provider.start(config.getL1CacheProperties());
        log.info("Using L1 CacheProvider : " + holder.l1_provider.getClass().getName());
        holder.l2_provider = CacheProviderHolder.loadProviderInstance(config.getL2CacheName());
        if (!holder.l2_provider.isLevel(2)) {
            throw new CacheException(holder.l2_provider.getClass().getName() + " is not level_2 cache provider");
        }
        holder.l2_provider.start(config.getL2CacheProperties());
        log.info("Using L2 CacheProvider : " + holder.l2_provider.getClass().getName());
        return holder;
    }

    public void shutdown() {
        this.l1_provider.stop();
        this.l2_provider.stop();
    }

    private static CacheProvider loadProviderInstance(String cacheIdent) {
        if ("ehcache".equalsIgnoreCase(cacheIdent)) {
            return new EhCacheProvider();
        }
        if ("ehcache3".equalsIgnoreCase(cacheIdent)) {
            return new EhCacheProvider3();
        }
        if ("caffeine".equalsIgnoreCase(cacheIdent)) {
            return new CaffeineProvider();
        }
        if ("redis".equalsIgnoreCase(cacheIdent)) {
            return new RedisCacheProvider();
        }
        if ("readonly-redis".equalsIgnoreCase(cacheIdent)) {
            return new ReadonlyRedisCacheProvider();
        }
        if ("memcached".equalsIgnoreCase(cacheIdent)) {
            return new XmemcachedCacheProvider();
        }
        if ("lettuce".equalsIgnoreCase(cacheIdent)) {
            return new LettuceCacheProvider();
        }
        if ("none".equalsIgnoreCase(cacheIdent)) {
            return new NullCacheProvider();
        }
        try {
            return (CacheProvider)Class.forName(cacheIdent).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new CacheException("Failed to initialize cache providers", e);
        }
    }

    public CacheProvider getL1Provider() {
        return this.l1_provider;
    }

    public CacheProvider getL2Provider() {
        return this.l2_provider;
    }

    public Level1Cache getLevel1Cache(String region) {
        return (Level1Cache)this.l1_provider.buildCache(region, this.listener);
    }

    public Level1Cache getLevel1Cache(String region, long timeToLiveSeconds) {
        return (Level1Cache)this.l1_provider.buildCache(region, timeToLiveSeconds, this.listener);
    }

    public Level2Cache getLevel2Cache(String region) {
        return (Level2Cache)this.l2_provider.buildCache(region, this.listener);
    }

    public Collection<CacheChannel.Region> regions() {
        return this.l1_provider.regions();
    }
}

