/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.image.loader;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.util.UnitConv;
import org.apache.xmlgraphics.util.io.SubInputStream;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeException;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.image.loader.ImageBarcode;
import org.krysalis.barcode4j.tools.ConfigurationUtil;
import org.krysalis.barcode4j.tools.MessageUtil;
import org.krysalis.barcode4j.tools.PageInfo;
import org.krysalis.barcode4j.tools.VariableUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PreloaderBarcode
extends AbstractImagePreloader {
    public ImageInfo preloadImage(String uri, Source src, ImageContext context) throws IOException {
        ImageInfo info = null;
        if (!this.isSupportedSource(src)) {
            return null;
        }
        info = this.getImage(uri, src, context);
        if (info != null) {
            ImageUtil.closeQuietly((Source)src);
        }
        return info;
    }

    private ImageInfo getImage(String uri, Source src, ImageContext context) throws IOException {
        InputStream in = null;
        try {
            ImageInfo info;
            Document doc;
            if (src instanceof DOMSource) {
                DOMSource domSrc = (DOMSource)src;
                doc = (Document)domSrc.getNode();
            } else {
                in = ImageUtil.needInputStream((Source)src);
                int length = in.available();
                in.mark(length + 1);
                try {
                    doc = this.getDocument((InputStream)new SubInputStream(in, Long.MAX_VALUE, false));
                }
                catch (IOException ioe) {
                    this.resetInputStream(in);
                    return null;
                }
            }
            if (!"http://barcode4j.krysalis.org/ns".equals(doc.getDocumentElement().getNamespaceURI())) {
                this.resetInputStream(in);
                return null;
            }
            try {
                info = this.createImageInfo(uri, context, doc);
            }
            catch (ConfigurationException e) {
                this.resetInputStream(in);
                throw new IOException("Error in Barcode XML: " + e.getLocalizedMessage());
            }
            catch (BarcodeException e) {
                this.resetInputStream(in);
                throw new IOException("Error processing Barcode XML: " + e.getLocalizedMessage());
            }
            return info;
        }
        catch (SAXException se) {
            this.resetInputStream(in);
            return null;
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    private void resetInputStream(InputStream in) {
        try {
            if (in != null) {
                in.reset();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ImageInfo createImageInfo(String uri, ImageContext context, Document doc) throws ConfigurationException, BarcodeException {
        Configuration cfg = ConfigurationUtil.buildConfiguration((Node)doc);
        String msg = ConfigurationUtil.getMessage((Configuration)cfg);
        msg = MessageUtil.unescapeUnicode((String)msg);
        int orientation = cfg.getAttributeAsInteger("orientation", 0);
        orientation = BarcodeDimension.normalizeOrientation((int)orientation);
        BarcodeGenerator bargen = BarcodeUtil.getInstance().createBarcodeGenerator(cfg);
        String expandedMsg = VariableUtil.getExpandedMessage((PageInfo)null, (String)msg);
        BarcodeDimension bardim = bargen.calcDimensions(expandedMsg);
        int widthMpt = (int)Math.ceil(UnitConv.mm2mpt((double)bardim.getWidthPlusQuiet(orientation)));
        int heightMpt = (int)Math.ceil(UnitConv.mm2mpt((double)bardim.getHeightPlusQuiet(orientation)));
        ImageInfo info = new ImageInfo(uri, "application/x-barcode4j+xml");
        ImageSize size = new ImageSize();
        size.setSizeInMillipoints(widthMpt, heightMpt);
        size.setResolution((double)context.getSourceResolution());
        size.calcPixelsFromSize();
        info.setSize(size);
        ImageBarcode barcodeImage = new ImageBarcode(info, cfg, bardim);
        info.getCustomObjects().put(ImageInfo.ORIGINAL_IMAGE, barcodeImage);
        info.getCustomObjects().put(ImageBarcode.MESSAGE, msg);
        return info;
    }

    private boolean isSupportedSource(Source src) {
        if (src instanceof DOMSource) {
            DOMSource domSrc = (DOMSource)src;
            return domSrc.getNode() instanceof Document;
        }
        return ImageUtil.hasInputStream((Source)src);
    }

    private Document getDocument(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            public void warning(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        Document doc = db.parse(in);
        return doc;
    }
}

