/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.sample;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import net.sf.jxls.sample.model.Department;
import net.sf.jxls.sample.model.Employee;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;

public class StressXlsxTest {
    private static String templateFileDir;
    private static String destFileDir;

    public static void main(String[] args) throws IOException, InvalidFormatException {
        if (args.length >= 2) {
            templateFileDir = args[0];
            destFileDir = args[1];
        }
        StressXlsxTest test = new StressXlsxTest();
        test.testStress1();
        test.testStress2();
    }

    public void testStress1() throws InvalidFormatException, IOException {
        HashMap<String, List<Employee>> beans = new HashMap<String, List<Employee>>();
        int employeeCount = 30000;
        List<Employee> employees = Employee.generate(30000);
        beans.put("employees", employees);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(templateFileDir + "stress1.xlsx"));
        XLSTransformer transformer = new XLSTransformer();
        long startTime = System.nanoTime();
        Workbook resultWorkbook = transformer.transformXLS((InputStream)is, beans);
        long endTime = System.nanoTime();
        ((InputStream)is).close();
        this.saveWorkbook(resultWorkbook, destFileDir + "stress1_output.xlsx");
        System.out.println("Stress1 XLSX time (s): " + (endTime - startTime) / 1000000000L);
    }

    public void testStress2() throws InvalidFormatException, IOException {
        HashMap<String, List<Department>> beans = new HashMap<String, List<Department>>();
        int employeeCount = 500;
        int depCount = 100;
        List<Department> departments = Department.generate(100, 500);
        beans.put("departments", departments);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(templateFileDir + "stress2.xlsx"));
        XLSTransformer transformer = new XLSTransformer();
        long startTime = System.nanoTime();
        Workbook resultWorkbook = transformer.transformXLS((InputStream)is, beans);
        long endTime = System.nanoTime();
        ((InputStream)is).close();
        this.saveWorkbook(resultWorkbook, destFileDir + "stress2_output.xlsx");
        System.out.println("Stress2 XLSX time (s): " + (endTime - startTime) / 1000000000L);
    }

    private void saveWorkbook(Workbook resultWorkbook, String fileName) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(fileName));
        resultWorkbook.write((OutputStream)os);
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
    }
}

