/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.sample.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Employee {
    private String name;
    private int age;
    private Double payment;
    private Double bonus;
    private Date birthDate;
    private Employee superior;
    static Random random = new Random(System.currentTimeMillis());
    static long current = System.currentTimeMillis();

    public Employee(String name, int age, Double payment, Double bonus) {
        this.name = name;
        this.age = age;
        this.payment = payment;
        this.bonus = bonus;
    }

    public Employee(String name, int age, double payment, double bonus, Date birthDate) {
        this.name = name;
        this.age = age;
        this.payment = new Double(payment);
        this.bonus = new Double(bonus);
        this.birthDate = birthDate;
    }

    public Employee(String name, int age, double payment, double bonus) {
        this.name = name;
        this.age = age;
        this.payment = new Double(payment);
        this.bonus = new Double(bonus);
    }

    public static List<Employee> generate(int num) {
        ArrayList<Employee> result = new ArrayList<Employee>();
        for (int index = 0; index < num; ++index) {
            result.add(Employee.generateOne("" + index));
        }
        return result;
    }

    public static Employee generateOne(String nameSuffix) {
        return new Employee("Employee " + nameSuffix, random.nextInt(100), 1000.0 + random.nextDouble() * 5000.0, (double)random.nextInt(100) / 100.0, new Date(current - (long)(1000000 + random.nextInt(1000000))));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public Double getPayment() {
        return this.payment;
    }

    public void setPayment(Double payment) {
        this.payment = payment;
    }

    public Double getBonus() {
        return this.bonus;
    }

    public void setBonus(Double bonus) {
        this.bonus = bonus;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    public Employee getSuperior() {
        return this.superior;
    }

    public void setSuperior(Employee superior) {
        this.superior = superior;
    }
}

