/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyColumnInfo;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.IndexInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.PrimaryKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.sql.TokenizerSessPropsInteractions;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.TaskThreadPool;
import org.easymock.classextension.EasyMock;

public class FwTestUtil {
    public static IMessageHandler getEasyMockMessageHandler() {
        IMessageHandler result = (IMessageHandler)EasyMock.createMock(IMessageHandler.class);
        result.showErrorMessage((Throwable)org.easymock.EasyMock.isA(Throwable.class), null);
        result.showErrorMessage((String)org.easymock.EasyMock.isA(String.class));
        result.showMessage((String)org.easymock.EasyMock.isA(String.class));
        result.showMessage((Throwable)org.easymock.EasyMock.isA(Throwable.class), null);
        result.showWarningMessage((String)org.easymock.EasyMock.isA(String.class));
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    public static IQueryTokenizer getEasyMockQueryTokenizer() {
        return FwTestUtil.getEasyMockQueryTokenizer(";", "--", true, 5);
    }

    public static IQueryTokenizer getEasyMockQueryTokenizer(String sep, String solComment, boolean removeMultiLineComment, int queryCount) {
        IQueryTokenizer tokenizer = (IQueryTokenizer)EasyMock.createMock(IQueryTokenizer.class);
        org.easymock.EasyMock.expect((Object)tokenizer.getSQLStatementSeparator()).andReturn((Object)sep).anyTimes();
        org.easymock.EasyMock.expect((Object)tokenizer.getLineCommentBegin()).andReturn((Object)solComment).anyTimes();
        org.easymock.EasyMock.expect((Object)tokenizer.isRemoveMultiLineComment()).andReturn((Object)removeMultiLineComment).anyTimes();
        org.easymock.EasyMock.expect((Object)tokenizer.getQueryCount()).andReturn((Object)queryCount).anyTimes();
        TokenizerSessPropsInteractions tspi = (TokenizerSessPropsInteractions)EasyMock.createMock(TokenizerSessPropsInteractions.class);
        org.easymock.EasyMock.expect((Object)tspi.isTokenizerDefinesRemoveMultiLineComment()).andStubReturn((Object)true);
        org.easymock.EasyMock.expect((Object)tspi.isTokenizerDefinesStartOfLineComment()).andStubReturn((Object)true);
        org.easymock.EasyMock.expect((Object)tspi.isTokenizerDefinesStatementSeparator()).andStubReturn((Object)true);
        org.easymock.EasyMock.expect((Object)tokenizer.getTokenizerSessPropsInteractions()).andStubReturn((Object)tspi);
        EasyMock.replay((Object[])new Object[]{tspi});
        EasyMock.replay((Object[])new Object[]{tokenizer});
        return tokenizer;
    }

    public static SQLConnection getEasyMockSQLConnection() throws SQLException {
        SQLConnection result = (SQLConnection)EasyMock.createMock(SQLConnection.class);
        result.addPropertyChangeListener((PropertyChangeListener)EasyMock.isA(PropertyChangeListener.class));
        org.easymock.EasyMock.expect((Object)result.getCatalog()).andReturn((Object)"TestCatalog").anyTimes();
        return result;
    }

    public static ISQLConnection getEasyMockSQLConnection(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("rs cannot be null");
        }
        Statement stmt = (Statement)EasyMock.createNiceMock(Statement.class);
        org.easymock.EasyMock.expect((Object)stmt.executeQuery(org.easymock.EasyMock.startsWith((String)"select"))).andReturn((Object)rs).anyTimes();
        EasyMock.replay((Object[])new Object[]{stmt});
        Connection con = (Connection)EasyMock.createNiceMock(Connection.class);
        org.easymock.EasyMock.expect((Object)con.createStatement()).andReturn((Object)stmt);
        org.easymock.EasyMock.expect((Object)con.createStatement(1003, 1007)).andReturn((Object)stmt);
        EasyMock.replay((Object[])new Object[]{con});
        ISQLConnection sqlCon = (ISQLConnection)EasyMock.createNiceMock(ISQLConnection.class);
        org.easymock.EasyMock.expect((Object)sqlCon.getConnection()).andReturn((Object)con);
        EasyMock.replay((Object[])new Object[]{sqlCon});
        return sqlCon;
    }

    public static ISQLDatabaseMetaData getEasyMockH2SQLMetaData() throws SQLException {
        ISQLDatabaseMetaData md = (ISQLDatabaseMetaData)EasyMock.createMock(ISQLDatabaseMetaData.class);
        org.easymock.EasyMock.expect((Object)md.getDatabaseProductName()).andReturn((Object)"H2").anyTimes();
        org.easymock.EasyMock.expect((Object)md.getDatabaseProductVersion()).andReturn((Object)"1.0 (2007-04-29)").anyTimes();
        org.easymock.EasyMock.expect((Object)md.supportsSchemasInDataManipulation()).andReturn((Object)true).anyTimes();
        org.easymock.EasyMock.expect((Object)md.supportsSchemasInTableDefinitions()).andStubReturn((Object)true);
        org.easymock.EasyMock.expect((Object)md.supportsCatalogsInDataManipulation()).andReturn((Object)false).anyTimes();
        org.easymock.EasyMock.expect((Object)md.getCatalogSeparator()).andReturn((Object)".").anyTimes();
        org.easymock.EasyMock.expect((Object)md.getIdentifierQuoteString()).andReturn((Object)"\"").anyTimes();
        org.easymock.EasyMock.expect((Object)md.getURL()).andReturn((Object)"jdbc:h2:tcp://localhost:9094/testDatabase").anyTimes();
        EasyMock.replay((Object[])new Object[]{md});
        return md;
    }

    public static ISQLDatabaseMetaData getEasyMockSybase15SQLMetaData() throws SQLException {
        ISQLDatabaseMetaData md = FwTestUtil.getSybaseSQLMetaData();
        String version = "Adaptive Server Enterprise/15.0/EBF 13194 EC ESD/P/Linux Intel/Linux 2.4.21-20.ELsmp i686/ase150/2179/32-bit/FBO/Mon Feb  6 04:14:19 2006";
        org.easymock.EasyMock.expect((Object)md.getDatabaseProductVersion()).andReturn((Object)version).anyTimes();
        org.easymock.EasyMock.expect((Object)md.supportsSchemasInTableDefinitions()).andStubReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{md});
        return md;
    }

    public static ISQLDatabaseMetaData getEasyMockSybase12SQLMetaData() throws SQLException {
        ISQLDatabaseMetaData md = FwTestUtil.getSybaseSQLMetaData();
        String version = "Adaptive Server Enterprise/12.5.4/EBF 13194 EC ESD/P/Linux Intel/Linux 2.4.21-20.ELsmp i686/ase120/2179/32-bit/FBO/Mon Feb  6 04:14:19 2006";
        org.easymock.EasyMock.expect((Object)md.getDatabaseProductVersion()).andReturn((Object)version).anyTimes();
        org.easymock.EasyMock.expect((Object)md.supportsSchemasInTableDefinitions()).andStubReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{md});
        return md;
    }

    private static ISQLDatabaseMetaData getSybaseSQLMetaData() throws SQLException {
        ISQLDatabaseMetaData md = (ISQLDatabaseMetaData)EasyMock.createMock(ISQLDatabaseMetaData.class);
        org.easymock.EasyMock.expect((Object)md.getDatabaseProductName()).andReturn((Object)"Adaptive Server Enterprise").anyTimes();
        org.easymock.EasyMock.expect((Object)md.supportsSchemasInDataManipulation()).andReturn((Object)true).anyTimes();
        org.easymock.EasyMock.expect((Object)md.supportsCatalogsInDataManipulation()).andReturn((Object)true).anyTimes();
        org.easymock.EasyMock.expect((Object)md.getCatalogSeparator()).andReturn((Object)".").anyTimes();
        org.easymock.EasyMock.expect((Object)md.getIdentifierQuoteString()).andReturn((Object)"\"").anyTimes();
        org.easymock.EasyMock.expect((Object)md.getURL()).andReturn((Object)"jdbc:sybase:Tds:192.168.1.135:4115/dbcopydest").anyTimes();
        return md;
    }

    public static ISQLDatabaseMetaData getEasyMockSQLMetaData(String dbName, String dbURL, DatabaseMetaData md) throws SQLException {
        ISQLDatabaseMetaData result = FwTestUtil.getEasyMockSQLMetaData(dbName, dbURL, false, false);
        org.easymock.EasyMock.expect((Object)result.getJDBCMetaData()).andReturn((Object)md);
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    public static ISQLDatabaseMetaData getEasyMockSQLMetaData(String dbName, String dbURL, boolean nice, boolean replay) throws SQLException {
        ISQLDatabaseMetaData md = null;
        md = nice ? (ISQLDatabaseMetaData)EasyMock.createNiceMock(ISQLDatabaseMetaData.class) : (ISQLDatabaseMetaData)EasyMock.createMock(ISQLDatabaseMetaData.class);
        org.easymock.EasyMock.expect((Object)md.getDatabaseProductName()).andReturn((Object)dbName).anyTimes();
        org.easymock.EasyMock.expect((Object)md.getDatabaseProductVersion()).andReturn((Object)"1.0").anyTimes();
        org.easymock.EasyMock.expect((Object)md.supportsSchemasInDataManipulation()).andReturn((Object)true).anyTimes();
        org.easymock.EasyMock.expect((Object)md.supportsCatalogsInDataManipulation()).andReturn((Object)true).anyTimes();
        org.easymock.EasyMock.expect((Object)md.supportsSchemasInTableDefinitions()).andStubReturn((Object)true);
        org.easymock.EasyMock.expect((Object)md.getCatalogSeparator()).andReturn((Object)"").anyTimes();
        org.easymock.EasyMock.expect((Object)md.getIdentifierQuoteString()).andReturn((Object)"\"").anyTimes();
        org.easymock.EasyMock.expect((Object)md.getURL()).andReturn((Object)dbURL).anyTimes();
        DatabaseMetaData dbmd = (DatabaseMetaData)EasyMock.createMock(DatabaseMetaData.class);
        org.easymock.EasyMock.expect((Object)md.getJDBCMetaData()).andReturn((Object)dbmd).anyTimes();
        if (replay) {
            EasyMock.replay((Object[])new Object[]{md});
        }
        return md;
    }

    public static ISQLDatabaseMetaData getEasyMockSQLMetaData(String dbName, String dbURL) throws SQLException {
        return FwTestUtil.getEasyMockSQLMetaData(dbName, dbURL, true, true);
    }

    public static ISQLDatabaseMetaData getEasyMockSQLMetaData(String dbName, String dbURL, boolean nice) throws SQLException {
        return FwTestUtil.getEasyMockSQLMetaData(dbName, dbURL, nice, true);
    }

    public static SQLDriverManager getEasyMockSQLDriverManager() {
        SQLDriverManager result = (SQLDriverManager)EasyMock.createMock(SQLDriverManager.class);
        Driver mockDriver = (Driver)EasyMock.createMock(Driver.class);
        EasyMock.replay((Object[])new Object[]{mockDriver});
        org.easymock.EasyMock.expect((Object)result.getJDBCDriver((IIdentifier)org.easymock.EasyMock.isA(IIdentifier.class))).andReturn((Object)mockDriver).anyTimes();
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    public static TaskThreadPool getEasyMockTaskThreadPool() {
        TaskThreadPool result = (TaskThreadPool)EasyMock.createMock(TaskThreadPool.class);
        result.addTask((Runnable)org.easymock.EasyMock.isA(Runnable.class));
        org.easymock.EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    public static IIdentifier getEasyMockIdentifier() {
        IIdentifier result = (IIdentifier)EasyMock.createMock(IIdentifier.class);
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    public static TaskThreadPool getThreadPool() {
        TaskThreadPool result = (TaskThreadPool)EasyMock.createMock(TaskThreadPool.class);
        result.addTask((Runnable)org.easymock.EasyMock.isA(Runnable.class));
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    public static ForeignKeyInfo[] getEasyMockForeignKeyInfos(String fkName, String ctab, String ccol, String ptab, String pcol) {
        ForeignKeyInfo result = (ForeignKeyInfo)EasyMock.createMock(ForeignKeyInfo.class);
        org.easymock.EasyMock.expect((Object)result.getSimpleName()).andReturn((Object)fkName).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getForeignKeyColumnName()).andReturn((Object)ccol).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getPrimaryKeyColumnName()).andReturn((Object)pcol).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getForeignKeyTableName()).andReturn((Object)ctab).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getPrimaryKeyTableName()).andReturn((Object)ptab).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getDeleteRule()).andReturn((Object)0).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getUpdateRule()).andReturn((Object)0).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getForeignKeySchemaName()).andStubReturn((Object)"TestSchema");
        org.easymock.EasyMock.expect((Object)result.getPrimaryKeySchemaName()).andStubReturn((Object)"TestSchema");
        ForeignKeyColumnInfo mockForeignKeyColumnInfo = (ForeignKeyColumnInfo)EasyMock.createMock((String)"mockForeignKeyColumnInfo", ForeignKeyColumnInfo.class);
        org.easymock.EasyMock.expect((Object)mockForeignKeyColumnInfo.getForeignKeyColumnName()).andStubReturn((Object)ccol);
        org.easymock.EasyMock.expect((Object)mockForeignKeyColumnInfo.getPrimaryKeyColumnName()).andStubReturn((Object)pcol);
        org.easymock.EasyMock.expect((Object)mockForeignKeyColumnInfo.getKeySequence()).andStubReturn((Object)0);
        org.easymock.EasyMock.expect((Object)result.getForeignKeyColumnInfo()).andStubReturn((Object)new ForeignKeyColumnInfo[]{mockForeignKeyColumnInfo});
        EasyMock.replay((Object[])new Object[]{mockForeignKeyColumnInfo});
        EasyMock.replay((Object[])new Object[]{result});
        return new ForeignKeyInfo[]{result};
    }

    public static List<IndexInfo> getEasyMockIndexInfos(String tableName, String columnName) {
        IndexInfo result = (IndexInfo)EasyMock.createMock(IndexInfo.class);
        org.easymock.EasyMock.expect((Object)result.getColumnName()).andReturn((Object)columnName).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getSimpleName()).andReturn((Object)"TestIndex").anyTimes();
        org.easymock.EasyMock.expect((Object)result.getOrdinalPosition()).andReturn((Object)1).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getTableName()).andReturn((Object)tableName).anyTimes();
        org.easymock.EasyMock.expect((Object)result.isNonUnique()).andReturn((Object)false).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getSchemaName()).andStubReturn((Object)"TestSchema");
        EasyMock.replay((Object[])new Object[]{result});
        return Arrays.asList(result);
    }

    public static PrimaryKeyInfo getEasyMockPrimaryKeyInfo(String catalog, String schemaName, String tableName, String columnName, short keySequence, String pkName, boolean replay) {
        PrimaryKeyInfo pki = (PrimaryKeyInfo)EasyMock.createMock(PrimaryKeyInfo.class);
        org.easymock.EasyMock.expect((Object)pki.getCatalogName()).andReturn((Object)catalog).anyTimes();
        org.easymock.EasyMock.expect((Object)pki.getColumnName()).andReturn((Object)columnName).anyTimes();
        org.easymock.EasyMock.expect((Object)pki.getDatabaseObjectType()).andReturn((Object)DatabaseObjectType.PRIMARY_KEY).anyTimes();
        org.easymock.EasyMock.expect((Object)pki.getKeySequence()).andReturn((Object)keySequence).anyTimes();
        org.easymock.EasyMock.expect((Object)pki.getQualifiedColumnName()).andReturn((Object)columnName).anyTimes();
        org.easymock.EasyMock.expect((Object)pki.getQualifiedName()).andReturn((Object)pkName).anyTimes();
        org.easymock.EasyMock.expect((Object)pki.getSchemaName()).andReturn((Object)schemaName).anyTimes();
        org.easymock.EasyMock.expect((Object)pki.getSimpleName()).andReturn((Object)pkName).anyTimes();
        org.easymock.EasyMock.expect((Object)pki.getTableName()).andReturn((Object)tableName).anyTimes();
        if (replay) {
            EasyMock.replay((Object[])new Object[]{pki});
        }
        return pki;
    }

    public static PrimaryKeyInfo getEasyMockPrimaryKeyInfo(String catalog, String schemaName, String tableName, String columnName, short keySequence, String pkName) {
        return FwTestUtil.getEasyMockPrimaryKeyInfo(catalog, schemaName, tableName, columnName, keySequence, pkName, true);
    }

    public static TableColumnInfo getEasyMockTableColumn(String catalogName, String schemaName, String tableName, String columnName, int dataType) {
        String[] columnNames = new String[]{columnName};
        Integer[] dataTypes = new Integer[]{dataType};
        TableColumnInfo[] result = FwTestUtil.getEasyMockTableColumns(catalogName, schemaName, tableName, Arrays.asList(columnNames), Arrays.asList(dataTypes));
        return result[0];
    }

    public static TableColumnInfo[] getEasyMockTableColumns(String catalogName, String schemaName, String tableName, List<String> columnNames, List<Integer> dataTypes) {
        if (columnNames.size() != dataTypes.size()) {
            throw new IllegalArgumentException("columnNames.size() != dataTypes.size()");
        }
        ArrayList<TableColumnInfo> result = new ArrayList<TableColumnInfo>();
        int index = 0;
        for (String columnName : columnNames) {
            Integer columnDataType = dataTypes.get(index++);
            TableColumnInfo info = FwTestUtil.getEasyMockTableColumnInfo(catalogName, schemaName, tableName, columnName, columnDataType, 10, "defval", "remark", 10, 10, 10, true);
            result.add(info);
        }
        return result.toArray(new TableColumnInfo[0]);
    }

    public static TableColumnInfo getEasyMockTableColumnInfo(String catalogName, String schemaName, String tableName, String columnName, int dataType, int columnSize, String defaultValue, String remarks, int decimalDigits, int octetLength, int radix, boolean nullable) {
        TableColumnInfo info = (TableColumnInfo)EasyMock.createMock(TableColumnInfo.class);
        org.easymock.EasyMock.expect((Object)info.getCatalogName()).andReturn((Object)catalogName).anyTimes();
        org.easymock.EasyMock.expect((Object)info.getSchemaName()).andReturn((Object)schemaName).anyTimes();
        org.easymock.EasyMock.expect((Object)info.getTableName()).andReturn((Object)tableName).anyTimes();
        org.easymock.EasyMock.expect((Object)info.getColumnName()).andReturn((Object)columnName).anyTimes();
        org.easymock.EasyMock.expect((Object)info.getDataType()).andReturn((Object)dataType).anyTimes();
        org.easymock.EasyMock.expect((Object)info.getTypeName()).andReturn((Object)JDBCTypeMapper.getJdbcTypeName((int)dataType)).anyTimes();
        org.easymock.EasyMock.expect((Object)info.getColumnSize()).andReturn((Object)columnSize).anyTimes();
        org.easymock.EasyMock.expect((Object)info.getDatabaseObjectType()).andReturn((Object)DatabaseObjectType.COLUMN).anyTimes();
        org.easymock.EasyMock.expect((Object)info.getDefaultValue()).andReturn((Object)defaultValue).anyTimes();
        org.easymock.EasyMock.expect((Object)info.getRemarks()).andReturn((Object)remarks).anyTimes();
        org.easymock.EasyMock.expect((Object)info.getDecimalDigits()).andReturn((Object)decimalDigits).anyTimes();
        org.easymock.EasyMock.expect((Object)info.getOctetLength()).andReturn((Object)octetLength).anyTimes();
        org.easymock.EasyMock.expect((Object)info.getQualifiedName()).andReturn((Object)(schemaName + "." + tableName + "." + columnName)).anyTimes();
        org.easymock.EasyMock.expect((Object)info.getRadix()).andReturn((Object)radix).anyTimes();
        if (nullable) {
            org.easymock.EasyMock.expect((Object)info.isNullable()).andReturn((Object)"YES").anyTimes();
            org.easymock.EasyMock.expect((Object)info.isNullAllowed()).andReturn((Object)1).anyTimes();
        } else {
            org.easymock.EasyMock.expect((Object)info.isNullable()).andReturn((Object)"NO").anyTimes();
            org.easymock.EasyMock.expect((Object)info.isNullAllowed()).andReturn((Object)0).anyTimes();
        }
        EasyMock.replay((Object[])new Object[]{info});
        return info;
    }

    public static TableColumnInfo setEasyMockTableColumnInfoSize(TableColumnInfo info, int newSize) {
        TableColumnInfo result = FwTestUtil.getEasyMockTableColumnInfo(info.getCatalogName(), info.getSchemaName(), info.getTableName(), info.getColumnName(), info.getDataType(), newSize, info.getDefaultValue(), info.getRemarks(), info.getDecimalDigits(), info.getOctetLength(), info.getRadix(), info.isNullAllowed() == 1);
        return result;
    }

    public static TableColumnInfo setEasyMockTableColumnInfoNullable(TableColumnInfo info, boolean nullable) {
        TableColumnInfo result = FwTestUtil.getEasyMockTableColumnInfo(info.getCatalogName(), info.getSchemaName(), info.getTableName(), info.getColumnName(), info.getDataType(), info.getColumnSize(), info.getDefaultValue(), info.getRemarks(), info.getDecimalDigits(), info.getOctetLength(), info.getRadix(), nullable);
        return result;
    }

    public static TableColumnInfo setEasyMockTableColumnInfoType(TableColumnInfo info, int dataType) {
        TableColumnInfo result = FwTestUtil.getEasyMockTableColumnInfo(info.getCatalogName(), info.getSchemaName(), info.getTableName(), info.getColumnName(), dataType, info.getColumnSize(), info.getDefaultValue(), info.getRemarks(), info.getDecimalDigits(), info.getOctetLength(), info.getRadix(), info.isNullAllowed() == 1);
        return result;
    }

    public static TableColumnInfo getBigintColumnInfo(ISQLDatabaseMetaData md, boolean nullable) {
        return FwTestUtil.getTableColumnInfo(md, -5, 20, 10, nullable);
    }

    public static TableColumnInfo getBinaryColumnInfo(ISQLDatabaseMetaData md, boolean nullable) {
        return FwTestUtil.getTableColumnInfo(md, -2, -1, 0, nullable);
    }

    public static TableColumnInfo getBlobColumnInfo(ISQLDatabaseMetaData md, boolean nullable) {
        return FwTestUtil.getTableColumnInfo(md, 2004, Integer.MAX_VALUE, 0, nullable);
    }

    public static TableColumnInfo getClobColumnInfo(ISQLDatabaseMetaData md, boolean nullable) {
        return FwTestUtil.getTableColumnInfo(md, 2005, Integer.MAX_VALUE, 0, nullable);
    }

    public static TableColumnInfo getIntegerColumnInfo(ISQLDatabaseMetaData md, boolean nullable) {
        return FwTestUtil.getTableColumnInfo(md, 4, 10, 0, nullable);
    }

    public static TableColumnInfo getDateColumnInfo(ISQLDatabaseMetaData md, boolean nullable) {
        return FwTestUtil.getTableColumnInfo(md, 91, 0, 0, nullable);
    }

    public static TableColumnInfo getLongVarcharColumnInfo(ISQLDatabaseMetaData md, boolean nullable, int length) {
        return FwTestUtil.getTableColumnInfo(md, -1, length, 0, nullable);
    }

    public static TableColumnInfo getVarcharColumnInfo(ISQLDatabaseMetaData md, boolean nullable, int length) {
        return FwTestUtil.getTableColumnInfo(md, 12, length, 0, nullable);
    }

    public static TableColumnInfo getTableColumnInfo(ISQLDatabaseMetaData md, int type, int columnSize, int decimalDigits, boolean nullable) {
        return FwTestUtil.getTableColumnInfo(md, "TestColumn", type, columnSize, decimalDigits, nullable);
    }

    public static TableColumnInfo getTableColumnInfo(ISQLDatabaseMetaData md, String columnName, int type, int columnSize, int decimalDigits, boolean nullable) {
        int isNullableInt = 0;
        String isNullableStr = "no";
        if (nullable) {
            isNullableInt = 1;
            isNullableStr = "yes";
        }
        TableColumnInfo info = new TableColumnInfo("TestCatalog", "TestSchema", "TestTable", columnName, type, JDBCTypeMapper.getJdbcTypeName((int)type), columnSize, decimalDigits, 0, isNullableInt, "TestRemark", "0", 0, 0, isNullableStr, md);
        return info;
    }

    public static String findAncestorSquirrelSqlDistDirBase(String dirToFind) {
        File f = new File("../" + dirToFind);
        if (f.exists()) {
            return "../";
        }
        f = new File("../../" + dirToFind);
        if (f.exists()) {
            return "../../";
        }
        f = new File("../../../" + dirToFind);
        if (f.exists()) {
            return "../../../";
        }
        f = new File("../../../../" + dirToFind);
        if (f.exists()) {
            return "../../../../";
        }
        f = new File("../../../../../" + dirToFind);
        if (f.exists()) {
            return "../../../../../";
        }
        return null;
    }

    public static IDatabaseObjectInfo getEasyMockDatabaseObjectInfo(String catalog, String schema, String simpleName, String qualName, DatabaseObjectType type) {
        IDatabaseObjectInfo result = (IDatabaseObjectInfo)EasyMock.createMock(IDatabaseObjectInfo.class);
        org.easymock.EasyMock.expect((Object)result.getCatalogName()).andReturn((Object)catalog).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getSchemaName()).andReturn((Object)schema).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getSimpleName()).andReturn((Object)simpleName).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getQualifiedName()).andReturn((Object)qualName).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getDatabaseObjectType()).andReturn((Object)type).anyTimes();
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    public static ITableInfo getEasyMockTableInfo(String catalog, String schema, String simpleName, String qualName) {
        ITableInfo result = (ITableInfo)EasyMock.createMock(ITableInfo.class);
        org.easymock.EasyMock.expect((Object)result.getCatalogName()).andReturn((Object)catalog).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getSchemaName()).andReturn((Object)schema).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getSimpleName()).andReturn((Object)simpleName).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getQualifiedName()).andReturn((Object)qualName).anyTimes();
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    public static <T> T createClassMock(Class<T> toMock) {
        return (T)EasyMock.createMock(toMock);
    }

    public static void replayClassMock(Object ... mocks) {
        EasyMock.replay((Object[])mocks);
    }

    public static void verifyClassMock(Object ... mocks) {
        EasyMock.verify((Object[])mocks);
    }

    public static void resetClassMock(Object ... mocks) {
        EasyMock.reset((Object[])mocks);
    }
}

