/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.completion.util;

import net.sourceforge.squirrel_sql.fw.completion.util.CompletionParser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompletionParserTest {
    CompletionParser classUnderTest = null;
    String token1 = "schema1";
    String token2 = "table11";
    String qualifiedTableName = this.token1 + "." + this.token2;
    String testSqlPrefix = "select col1 as alias1, col2 as alias2 from ";
    String testSql = this.testSqlPrefix + this.qualifiedTableName;

    @Before
    public void setUp() throws Exception {
        this.classUnderTest = new CompletionParser(this.testSql);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCompletionParserString() {
    }

    @Test
    public void testCompletionParserStringBoolean() {
    }

    @Test
    public void testIsQualified() {
        Assert.assertTrue((boolean)this.classUnderTest.isQualified());
    }

    @Test
    public void testGetStringToParse() {
        Assert.assertEquals((Object)this.qualifiedTableName, (Object)this.classUnderTest.getStringToParse());
    }

    @Test
    public void testGetToken() {
        Assert.assertEquals((Object)this.token1, (Object)this.classUnderTest.getToken(0));
        Assert.assertEquals((Object)this.token2, (Object)this.classUnderTest.getToken(1));
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)2L, (long)this.classUnderTest.size());
    }

    @Test
    public void testGetStringToParsePosition() {
        Assert.assertEquals((long)(this.testSqlPrefix.length() - 1), (long)this.classUnderTest.getStringToParsePosition());
    }

    @Test
    public void testGetStringToReplace() {
        Assert.assertEquals((Object)this.token2, (Object)this.classUnderTest.getStringToReplace());
    }

    @Test
    public void testGetReplacementStart() {
        Assert.assertEquals((long)(this.testSqlPrefix + this.token1 + ".").length(), (long)this.classUnderTest.getReplacementStart());
    }

    @Test
    public void testGetTextTillCarret() {
        Assert.assertEquals((long)this.testSql.length(), (long)this.classUnderTest.getTextTillCarret().length());
        Assert.assertEquals((Object)this.testSql, (Object)this.classUnderTest.getTextTillCarret());
    }

    @Test
    public void testGetLastToken() {
        Assert.assertEquals((Object)this.classUnderTest.getLastToken(), (Object)this.token2);
    }

    @Test
    public void testGetAllButFirst() {
        Assert.assertEquals((Object)this.classUnderTest.getAllButFirst(), (Object)this.token2);
    }
}

