/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import net.sourceforge.squirrel_sql.BaseSQuirreLJUnit4TestCase;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DatabaseTypesDataSet;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import utils.EasyMockHelper;

public class DatabaseTypesDataSetTest
extends BaseSQuirreLJUnit4TestCase {
    private DatabaseTypesDataSet classUnderTest = null;
    private EasyMockHelper mockHelper = new EasyMockHelper();
    private ResultSet resultSet = this.mockHelper.createMock(ResultSet.class);
    private ResultSetMetaData resultSetMetaData = this.mockHelper.createMock(ResultSetMetaData.class);

    @Before
    public void setUp() throws Exception {
        EasyMock.expect((Object)this.resultSet.getMetaData()).andStubReturn((Object)this.resultSetMetaData);
    }

    @After
    public void tearDown() throws Exception {
        this.mockHelper.resetAll();
    }

    @Test
    public void testDatabaseTypesDataSetResultSet_Nullable() throws Exception {
        int[] columnIndices = new int[]{7};
        EasyMock.expect((Object)this.resultSetMetaData.getColumnDisplaySize(7)).andStubReturn((Object)7);
        EasyMock.expect((Object)this.resultSetMetaData.getColumnLabel(7)).andStubReturn((Object)"NULLABLE");
        this.resultSet.close();
        EasyMock.expect((Object)this.resultSet.next()).andReturn((Object)true).times(3);
        EasyMock.expect((Object)this.resultSet.next()).andReturn((Object)false);
        EasyMock.expect((Object)this.resultSet.getShort(7)).andReturn((Object)0);
        EasyMock.expect((Object)this.resultSet.getShort(7)).andReturn((Object)1);
        EasyMock.expect((Object)this.resultSet.getShort(7)).andReturn((Object)2);
        this.mockHelper.replayAll();
        this.classUnderTest = new DatabaseTypesDataSet(this.resultSet, columnIndices);
        this.classUnderTest.next(null);
        Assert.assertNotNull((Object)this.classUnderTest.get(0));
        this.mockHelper.verifyAll();
    }

    @Test
    public void testDatabaseTypesDataSetResultSet_Searchable() throws Exception {
        int[] columnIndices = new int[]{9};
        EasyMock.expect((Object)this.resultSetMetaData.getColumnDisplaySize(9)).andStubReturn((Object)9);
        EasyMock.expect((Object)this.resultSetMetaData.getColumnLabel(9)).andStubReturn((Object)"SEARCHABLE");
        this.resultSet.close();
        EasyMock.expect((Object)this.resultSet.next()).andReturn((Object)true).times(4);
        EasyMock.expect((Object)this.resultSet.next()).andReturn((Object)false);
        EasyMock.expect((Object)this.resultSet.getShort(9)).andReturn((Object)1);
        EasyMock.expect((Object)this.resultSet.getShort(9)).andReturn((Object)2);
        EasyMock.expect((Object)this.resultSet.getShort(9)).andReturn((Object)0);
        EasyMock.expect((Object)this.resultSet.getShort(9)).andReturn((Object)3);
        this.mockHelper.replayAll();
        this.classUnderTest = new DatabaseTypesDataSet(this.resultSet, columnIndices);
        Assert.assertEquals((long)1L, (long)this.classUnderTest.getColumnCount());
        Assert.assertNotNull((Object)this.classUnderTest.getDataSetDefinition());
        Assert.assertTrue((boolean)this.classUnderTest.next(null));
        Assert.assertTrue((boolean)this.classUnderTest.next(null));
        Assert.assertTrue((boolean)this.classUnderTest.next(null));
        Assert.assertTrue((boolean)this.classUnderTest.next(null));
        Assert.assertFalse((boolean)this.classUnderTest.next(null));
        this.mockHelper.verifyAll();
    }
}

