/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.BaseSQuirreLJUnit4TestCase;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IToolkitBeepHelper;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractDataTypeComponentTest
extends BaseSQuirreLJUnit4TestCase {
    protected IDataTypeComponent classUnderTest = null;
    protected ColumnDisplayDefinition mockColumnDisplayDefinition = this.mockHelper.createMock(ColumnDisplayDefinition.class);
    protected ISQLDatabaseMetaData mockMetaData = this.mockHelper.createMock(ISQLDatabaseMetaData.class);
    protected IToolkitBeepHelper mockBeepHelper = this.mockHelper.createMock(IToolkitBeepHelper.class);
    protected boolean defaultValueIsNull = false;
    protected boolean canDoFileIO = true;
    protected boolean isEditableInCell = true;
    protected boolean isEditableInPopup = true;

    protected ColumnDisplayDefinition getMockColumnDisplayDefinition() {
        ColumnDisplayDefinition columnDisplayDefinition = this.mockHelper.createMock("testColumnDisplayDefinition", ColumnDisplayDefinition.class);
        EasyMock.expect((Object)columnDisplayDefinition.isNullable()).andStubReturn((Object)false);
        EasyMock.expect((Object)columnDisplayDefinition.isSigned()).andStubReturn((Object)false);
        EasyMock.expect((Object)columnDisplayDefinition.getPrecision()).andStubReturn((Object)10);
        EasyMock.expect((Object)columnDisplayDefinition.getScale()).andStubReturn((Object)3);
        EasyMock.expect((Object)columnDisplayDefinition.getColumnSize()).andStubReturn((Object)10);
        EasyMock.expect((Object)columnDisplayDefinition.getColumnName()).andStubReturn((Object)"testLabel");
        EasyMock.expect((Object)columnDisplayDefinition.getSqlType()).andStubReturn((Object)12);
        EasyMock.expect((Object)columnDisplayDefinition.getSqlTypeName()).andStubReturn((Object)"VARCHAR");
        return columnDisplayDefinition;
    }

    @Before
    public void setUp() throws Exception {
        this.classUnderTest.setColumnDisplayDefinition(this.mockColumnDisplayDefinition);
        this.classUnderTest.setBeepHelper(this.mockBeepHelper);
        EasyMock.expect((Object)this.mockColumnDisplayDefinition.getColumnName()).andStubReturn((Object)"testLabel");
        EasyMock.expect((Object)this.mockMetaData.getDatabaseProductName()).andStubReturn((Object)"testDatabaseProductName");
        EasyMock.expect((Object)this.mockMetaData.getDatabaseProductVersion()).andStubReturn((Object)"testDatabaseProductVersion");
        this.mockBeepHelper.beep((Component)EasyMock.isA(Component.class));
        EasyMock.expectLastCall().anyTimes();
    }

    @After
    public void tearDown() throws Exception {
        this.classUnderTest = null;
        this.mockHelper.resetAll();
    }

    @Test
    public void testGetClassName() throws Exception {
        Assert.assertNotNull((Object)this.classUnderTest.getClassName());
        Class.forName(this.classUnderTest.getClassName());
    }

    @Test
    public void testCanDoFileIO() {
        this.mockHelper.replayAll();
        if (this.canDoFileIO) {
            Assert.assertTrue((boolean)this.classUnderTest.canDoFileIO());
        } else {
            Assert.assertFalse((boolean)this.classUnderTest.canDoFileIO());
        }
        this.mockHelper.verifyAll();
    }

    @Test
    public void testGetDefaultValue() {
        this.mockHelper.replayAll();
        if (this.defaultValueIsNull) {
            Assert.assertNull((Object)this.classUnderTest.getDefaultValue(null));
        } else {
            Assert.assertNotNull((Object)this.classUnderTest.getDefaultValue(null));
        }
        this.mockHelper.verifyAll();
    }

    @Test
    public void testIsEditableInCell() {
        Object testObject = this.getEqualsTestObject();
        this.mockHelper.replayAll();
        if (this.isEditableInCell) {
            Assert.assertTrue((boolean)this.classUnderTest.isEditableInCell(testObject));
            Assert.assertTrue((boolean)this.classUnderTest.isEditableInCell(null));
        } else {
            Assert.assertFalse((boolean)this.classUnderTest.isEditableInCell(testObject));
            Assert.assertFalse((boolean)this.classUnderTest.isEditableInCell(null));
        }
        this.mockHelper.verifyAll();
    }

    @Test
    public void testIsEditableInPopup() {
        Object testObject = this.getEqualsTestObject();
        this.mockHelper.replayAll();
        if (this.isEditableInPopup) {
            Assert.assertTrue((boolean)this.classUnderTest.isEditableInPopup(testObject));
            Assert.assertTrue((boolean)this.classUnderTest.isEditableInPopup(null));
        } else {
            Assert.assertFalse((boolean)this.classUnderTest.isEditableInPopup(testObject));
            Assert.assertFalse((boolean)this.classUnderTest.isEditableInPopup(null));
        }
        this.mockHelper.verifyAll();
    }

    @Test
    public void testNeedToReRead() {
        this.mockHelper.replayAll();
        Assert.assertFalse((boolean)this.classUnderTest.needToReRead(null));
        this.mockHelper.verifyAll();
    }

    @Test
    public void testUseBinaryEditingPanel() {
        this.mockHelper.replayAll();
        this.classUnderTest.useBinaryEditingPanel();
        this.mockHelper.verifyAll();
    }

    @Test
    public void testAreEqual() {
        Object testObject = this.getEqualsTestObject();
        this.mockHelper.replayAll();
        Assert.assertFalse((boolean)this.classUnderTest.areEqual(testObject, null));
        Assert.assertFalse((boolean)this.classUnderTest.areEqual(null, testObject));
        Assert.assertTrue((boolean)this.classUnderTest.areEqual(testObject, testObject));
        this.mockHelper.verifyAll();
    }

    protected abstract Object getEqualsTestObject();

    @Test
    public void testTextComponents() {
        JTextField tf = this.classUnderTest.getJTextField();
        tf.setText("111111111111");
        this.testKeyListener(tf);
        JTextArea ta = this.classUnderTest.getJTextArea(null);
        ta.setText("111111111111");
        this.testKeyListener(ta);
    }

    protected void testKeyListener(Component c) {
        KeyListener[] listeners = c.getKeyListeners();
        if (listeners.length > 0) {
            KeyListener listener = listeners[0];
            KeyEvent e = new KeyEvent(c, -1, 1111111111L, -1, -1, '\n');
            listener.keyTyped(e);
        }
    }

    @Test
    public void testGetWhereClauseValue() {
        ColumnDisplayDefinition localMockColumnDisplayDefinition = this.getMockColumnDisplayDefinition();
        this.mockHelper.replayAll();
        this.classUnderTest.setColumnDisplayDefinition(localMockColumnDisplayDefinition);
        Assert.assertNotNull((Object)this.classUnderTest.getWhereClauseValue(null, this.mockMetaData));
        Assert.assertNotNull((Object)this.classUnderTest.getWhereClauseValue(this.getWhereClauseValueObject(), this.mockMetaData));
        this.mockHelper.verifyAll();
    }

    protected Object getWhereClauseValueObject() {
        return "aTestValue";
    }
}

