/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Types;
import java.util.Vector;
import net.sourceforge.squirrel_sql.BaseSQuirreLJUnit4TestCase;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.easymock.EasyMock;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.junit.Assert;
import org.junit.Test;
import utils.EasyMockHelper;

public abstract class AbstractDialectExtTest
extends BaseSQuirreLJUnit4TestCase {
    protected HibernateDialect classUnderTest = null;
    protected EasyMockHelper mockHelper = new EasyMockHelper();
    private TableColumnInfo mockColumnInfo = this.mockHelper.createMock(TableColumnInfo.class);
    private DatabaseObjectQualifier mockQualifier = this.mockHelper.createMock(DatabaseObjectQualifier.class);
    private SqlGenerationPreferences mockPrefs = this.mockHelper.createMock(SqlGenerationPreferences.class);

    public AbstractDialectExtTest() {
        AbstractDialectExtTest.disableLogging(Dialect.class);
    }

    private void setCommonExpectations() {
        EasyMock.expect((Object)this.mockColumnInfo.getTableName()).andStubReturn((Object)"aTestTableName");
        EasyMock.expect((Object)this.mockColumnInfo.getColumnName()).andStubReturn((Object)"aTestColumnName");
        EasyMock.expect((Object)this.mockColumnInfo.getRemarks()).andStubReturn((Object)"aRemark");
        EasyMock.expect((Object)this.mockColumnInfo.getDataType()).andStubReturn((Object)12);
        EasyMock.expect((Object)this.mockColumnInfo.getColumnSize()).andStubReturn((Object)1024);
        EasyMock.expect((Object)this.mockColumnInfo.getDecimalDigits()).andStubReturn((Object)0);
        EasyMock.expect((Object)this.mockColumnInfo.getDefaultValue()).andStubReturn(null);
        EasyMock.expect((Object)this.mockColumnInfo.isNullable()).andStubReturn((Object)"YES");
        EasyMock.expect((Object)this.mockQualifier.getSchema()).andStubReturn((Object)"aTestSchema");
        EasyMock.expect((Object)this.mockQualifier.getCatalog()).andStubReturn((Object)"aTestCatalog");
        EasyMock.expect((Object)this.mockPrefs.isQualifyTableNames()).andStubReturn((Object)true);
        EasyMock.expect((Object)this.mockPrefs.isQuoteIdentifiers()).andStubReturn((Object)true);
        EasyMock.expect((Object)this.mockPrefs.isQuoteColumnNames()).andStubReturn((Object)true);
        EasyMock.expect((Object)this.mockPrefs.isQuoteConstraintNames()).andStubReturn((Object)true);
        this.mockPrefs.setQuoteColumnNames(false);
        EasyMock.expectLastCall().anyTimes();
        this.mockPrefs.setQuoteConstraintNames(false);
        EasyMock.expectLastCall().anyTimes();
    }

    @Test
    public void testSupportsProduct() {
        Assert.assertFalse((boolean)this.classUnderTest.supportsProduct(null, null));
        Assert.assertFalse((boolean)this.classUnderTest.supportsProduct("FOOBAR", "1"));
    }

    @Test
    public void testGetLengthFunction() {
        for (String type : JDBCTypeMapper.getJdbcTypeList()) {
            int dataType = JDBCTypeMapper.getJdbcType((String)type);
            String lengthFunction = this.classUnderTest.getLengthFunction(dataType);
            Assert.assertNotNull((Object)lengthFunction);
            Assert.assertFalse((boolean)"".equals(lengthFunction));
        }
    }

    @Test
    public void testCanPasteTo() throws Exception {
        IDatabaseObjectInfo mockDboInfo = this.mockHelper.createMock(IDatabaseObjectInfo.class);
        boolean canPasteTo = false;
        DatabaseObjectType t = DatabaseObjectType.DATABASE_TYPE_DBO;
        for (Field f : t.getClass().getFields()) {
            if (!Modifier.isPublic(f.getModifiers())) continue;
            Object o = f.get(t);
            EasyMock.expect((Object)mockDboInfo.getDatabaseObjectType()).andStubReturn((Object)((DatabaseObjectType)o));
            this.mockHelper.replayAll();
            canPasteTo = canPasteTo || this.classUnderTest.canPasteTo(mockDboInfo);
            this.mockHelper.resetAll();
        }
        String displayName = this.classUnderTest.getDisplayName();
        Assert.assertTrue((String)("Dialect (" + displayName + ") can't paste to any object"), (boolean)canPasteTo);
    }

    @Test
    public void testGetMaxFunction() {
        String displayName = this.classUnderTest.getDisplayName();
        Assert.assertNotNull((String)("Dialect (" + displayName + ") doesn't return a valid max function"), (Object)this.classUnderTest.getMaxFunction());
        Assert.assertFalse((String)("Dialect (" + displayName + ") doesn't return a valid max function"), (boolean)"".equals(this.classUnderTest.getMaxFunction()));
    }

    @Test
    public void testGetPrecisionDigits() {
        for (String type : JDBCTypeMapper.getJdbcTypeList()) {
            int dataType = JDBCTypeMapper.getJdbcType((String)type);
            Assert.assertTrue((this.classUnderTest.getPrecisionDigits(10, dataType) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetMaxPrecision() {
        for (String type : JDBCTypeMapper.getJdbcTypeList()) {
            int dataType = JDBCTypeMapper.getJdbcType((String)type);
            Assert.assertTrue((this.classUnderTest.getMaxPrecision(dataType) >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetMaxScale() {
        for (String type : JDBCTypeMapper.getJdbcTypeList()) {
            int dataType = JDBCTypeMapper.getJdbcType((String)type);
            Assert.assertTrue((this.classUnderTest.getMaxScale(dataType) >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetColumnLength() {
        for (String type : JDBCTypeMapper.getJdbcTypeList()) {
            int dataType = JDBCTypeMapper.getJdbcType((String)type);
            Assert.assertTrue((this.classUnderTest.getColumnLength(10, dataType) >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetDialectType() {
        Assert.assertNotNull((Object)this.classUnderTest.getDialectType());
    }

    @Test
    public void testgetAddForeignKeyConstraintSQL() {
        block4: {
            this.setCommonExpectations();
            this.mockHelper.replayAll();
            try {
                Vector<String[]> localRefCols = new Vector<String[]>();
                localRefCols.add(new String[]{"aCol", "bCol"});
                String[] sql = this.classUnderTest.getAddForeignKeyConstraintSQL("localTableName", "refTableName", "constraintName", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), true, "fkIndexName", localRefCols, "updateAction", "onDeleteAction", this.mockQualifier, this.mockPrefs);
                if (this.classUnderTest.supportsAddForeignKeyConstraint()) {
                    Assert.assertNotNull((String)"supportsAddForeignKeyConstraint == true, but sql returned was null", (Object)sql);
                    Assert.assertTrue((sql.length != 0 ? 1 : 0) != 0);
                } else {
                    Assert.fail((String)("Expected dialect (" + this.classUnderTest.getDisplayName() + ") to throw UnsupportedOperationException when trying to retrieve SQL for adding " + "a foreign key constraint"));
                }
            }
            catch (UnsupportedOperationException e) {
                if (!this.classUnderTest.supportsAddForeignKeyConstraint()) break block4;
                this.failForUnsupported("supportsAddForeignKeyConstraint", e);
            }
        }
        this.mockHelper.verifyAll();
    }

    @Test
    public void testGetColumnDefaultAlterSQL() {
        block4: {
            this.setCommonExpectations();
            this.mockHelper.replayAll();
            try {
                String sql = this.classUnderTest.getColumnDefaultAlterSQL(this.mockColumnInfo, this.mockQualifier, this.mockPrefs);
                if (this.classUnderTest.supportsAlterColumnDefault()) {
                    Assert.assertNotNull((String)"supportsAlterColumnDefault == true, but sql returned was null", (Object)sql);
                } else {
                    Assert.fail((String)("Expected dialect (" + this.classUnderTest.getDisplayName() + ") to throw UnsupportedOperationException when trying to retrieve SQL for altering " + "a column default"));
                }
            }
            catch (UnsupportedOperationException e) {
                if (!this.classUnderTest.supportsAlterColumnDefault()) break block4;
                this.failForUnsupported("supportsAlterColumnDefault", e);
            }
        }
        this.mockHelper.verifyAll();
    }

    @Test
    public void testGetColumnDropSQL() {
        block4: {
            this.setCommonExpectations();
            this.mockHelper.replayAll();
            try {
                String sql = this.classUnderTest.getColumnDropSQL("aTestTableName", "aTestColumnName", this.mockQualifier, this.mockPrefs);
                if (this.classUnderTest.supportsDropColumn()) {
                    Assert.assertNotNull((String)"supportsDropColumn == true, but sql returned was null", (Object)sql);
                } else {
                    Assert.fail((String)("Expected dialect (" + this.classUnderTest.getDisplayName() + ") to throw UnsupportedOperationException when trying to retrieve SQL for dropping a column"));
                }
            }
            catch (UnsupportedOperationException e) {
                if (!this.classUnderTest.supportsDropColumn()) break block4;
                this.failForUnsupported("supportsDropColumn", e);
            }
        }
        this.mockHelper.verifyAll();
    }

    @Test
    public void testGetColumnNullAlter() {
        block4: {
            this.setCommonExpectations();
            this.mockHelper.replayAll();
            try {
                String[] sql = this.classUnderTest.getColumnNullableAlterSQL(this.mockColumnInfo, this.mockQualifier, this.mockPrefs);
                if (this.classUnderTest.supportsAlterColumnNull()) {
                    Assert.assertNotNull((String)"supportsAlterColumnNull == true, but sql returned was null", (Object)sql);
                    Assert.assertTrue((sql.length != 0 ? 1 : 0) != 0);
                } else {
                    Assert.fail((String)("Expected dialect (" + this.classUnderTest.getDisplayName() + ") to throw UnsupportedOperationException when trying to retrieve SQL for modify a column's nullability"));
                }
            }
            catch (UnsupportedOperationException e) {
                if (!this.classUnderTest.supportsAlterColumnNull()) break block4;
                this.failForUnsupported("supportsAlterColumnNull", e);
            }
        }
        this.mockHelper.verifyAll();
    }

    @Test
    public void testGetColumnNameAlter() {
        block4: {
            this.setCommonExpectations();
            TableColumnInfo mockToInfo = this.mockHelper.createMock(TableColumnInfo.class);
            EasyMock.expect((Object)mockToInfo.getColumnName()).andStubReturn((Object)"aNewColumnName");
            this.mockHelper.replayAll();
            try {
                String sql = this.classUnderTest.getColumnNameAlterSQL(this.mockColumnInfo, mockToInfo, this.mockQualifier, this.mockPrefs);
                if (this.classUnderTest.supportsRenameColumn()) {
                    Assert.assertNotNull((String)"supportsRenameColumn == true, but sql returned was null", (Object)sql);
                } else {
                    Assert.fail((String)("Expected dialect (" + this.classUnderTest.getDisplayName() + ") to throw UnsupportedOperationException when trying to retrieve SQL for re-naming a column"));
                }
            }
            catch (UnsupportedOperationException e) {
                if (!this.classUnderTest.supportsRenameColumn()) break block4;
                this.failForUnsupported("supportsRenameColumn", e);
            }
        }
        this.mockHelper.verifyAll();
    }

    @Test
    public void testAddColumnQualifiedNamesQuotedIdentifiers() {
        block3: {
            this.setCommonExpectations();
            this.mockHelper.replayAll();
            try {
                String[] sql = this.classUnderTest.getAddColumnSQL(this.mockColumnInfo, this.mockQualifier, this.mockPrefs);
                if (!this.classUnderTest.supportsAddColumn()) {
                    Assert.fail((String)("Expected dialect (" + this.classUnderTest.getDisplayName() + ") to throw UnsupportedOperationException when trying to retrieve SQL for adding a column"));
                }
                Assert.assertNotNull((Object)sql);
                Assert.assertTrue((sql.length != 0 ? 1 : 0) != 0);
            }
            catch (UnsupportedOperationException e) {
                if (!this.classUnderTest.supportsAddColumn()) break block3;
                this.failForUnsupported("supportsAddColumn", e);
            }
        }
        this.mockHelper.verifyAll();
    }

    @Test
    public void testGetTypeNameInt() {
        this.testAllTypes(this.classUnderTest);
    }

    @Test
    public void testGetCreateSequenceSQL() {
        block4: {
            this.setCommonExpectations();
            this.mockHelper.replayAll();
            try {
                String sql = this.classUnderTest.getCreateSequenceSQL("sSequenceName", "1", "1", "2000", "1", "20", true, this.mockQualifier, this.mockPrefs);
                if (this.classUnderTest.supportsSequence()) {
                    Assert.assertNotNull((String)"supportsSequence == true, but sql returned was null", (Object)sql);
                } else {
                    Assert.fail((String)("Expected dialect (" + this.classUnderTest.getDisplayName() + ") to throw UnsupportedOperationException when trying to create a sequence"));
                }
            }
            catch (UnsupportedOperationException e) {
                if (!this.classUnderTest.supportsSequence()) break block4;
                this.failForUnsupported("supportsSequence", e);
            }
        }
        this.mockHelper.verifyAll();
    }

    @Test
    public void testGetAlterSequenceSQL() {
        block4: {
            this.setCommonExpectations();
            this.mockHelper.replayAll();
            try {
                String[] sql = this.classUnderTest.getAlterSequenceSQL("sSequenceName", "1", "1", "2000", "1", "20", true, this.mockQualifier, this.mockPrefs);
                if (this.classUnderTest.supportsSequence() && this.classUnderTest.supportsAlterSequence()) {
                    Assert.assertNotNull((String)"supportsSequence == true, but sql returned was null", (Object)sql);
                    Assert.assertTrue((sql.length != 0 ? 1 : 0) != 0);
                } else {
                    Assert.fail((String)("Expected dialect (" + this.classUnderTest.getDisplayName() + ") to throw UnsupportedOperationException when trying to alter a sequence"));
                }
            }
            catch (UnsupportedOperationException e) {
                if (!this.classUnderTest.supportsSequence()) break block4;
                this.failForUnsupported("supportsSequence", e);
            }
        }
        this.mockHelper.verifyAll();
    }

    private void failForUnsupported(String supportsMethod, UnsupportedOperationException e) {
        String message = e.getMessage();
        if (!message.equals("Not yet implemented")) {
            Assert.fail((String)("For dialect (" + this.classUnderTest.getDisplayName() + ") " + supportsMethod + " was true, but still got an UnsupportedOperationException: " + e.getMessage()));
        }
    }

    private void testAllTypes(HibernateDialect d) {
        try {
            Field[] fields = Types.class.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                Integer jdbcType = field.getInt(null);
                this.testType(jdbcType, d);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private void testType(int type, HibernateDialect dialect) {
        block2: {
            try {
                dialect.getTypeName(type, 10, 0, 0);
            }
            catch (MappingException e) {
                if (type == 0 || type == 70 || type == 1111 || type == 2000 || type == 2001 || type == 2002 || type == 2003 || type == 2006 || type == -8 || type == -9 || type == -15 || type == -16 || type == 2011 || type == 2009) break block2;
                Assert.fail((String)("Dialect (" + this.classUnderTest.getDisplayName() + ") has no mapping for type: " + type + "=" + JDBCTypeMapper.getJdbcTypeName((int)type)));
            }
        }
    }
}

