/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.squirrel_sql.BaseSQuirreLJUnit4TestCase;
import net.sourceforge.squirrel_sql.fw.FwTestUtil;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HSQLDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyColumnInfo;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.IndexInfo;
import net.sourceforge.squirrel_sql.fw.sql.PrimaryKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableInfo;
import org.easymock.classextension.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DialectUtilsTest
extends BaseSQuirreLJUnit4TestCase {
    private static final String catalog = "testCatalog";
    private static final String schema = "testSchema";
    private static final String table = "testTable";
    private static final String pkCol = "id";
    private static final String pkName = "PKtestTable";
    private static final List<IndexInfo> noIndexList = new ArrayList<IndexInfo>();
    private static final ForeignKeyInfo[] noFKArray = new ForeignKeyInfo[0];
    private static final PrimaryKeyInfo[] noPrimaryKey = new PrimaryKeyInfo[0];
    CreateScriptPreferences prefs = null;
    ISQLDatabaseMetaData mockMetaData;
    ITableInfo childTableInfo;
    ITableInfo parentTableInfo;
    List<ITableInfo> oneTableList = new ArrayList<ITableInfo>();
    List<ITableInfo> twoTableList = new ArrayList<ITableInfo>();
    PrimaryKeyInfo mockPrimaryKeyInfo;
    PrimaryKeyInfo[] pkInfos;
    ForeignKeyInfo[] fkinfos;
    IndexInfo mockIndexInfo;
    List<IndexInfo> mockIndexInfos;
    ForeignKeyColumnInfo mockForeignKeyColumnInfo = this.mockHelper.createMock("mockForeignKeyColumnInfo", ForeignKeyColumnInfo.class);

    @Before
    public void setUp() throws Exception {
        this.prefs = new CreateScriptPreferences();
        this.prefs.setIncludeExternalReferences(true);
        this.mockMetaData = FwTestUtil.getEasyMockSQLMetaData("oracle", "jdbc:oracle:thin", false, false);
        this.mockPrimaryKeyInfo = FwTestUtil.getEasyMockPrimaryKeyInfo(catalog, schema, table, pkCol, (short)1, pkName, true);
        this.pkInfos = new PrimaryKeyInfo[]{this.mockPrimaryKeyInfo};
        List<String> columnNames = Arrays.asList(pkCol, "fkcol", "data");
        List<Integer> dataTypes = Arrays.asList(4, 12, 12);
        List<String> parentColumnNames = Arrays.asList(pkCol, "startTime");
        List<Integer> parentDataTypes = Arrays.asList(4, 91);
        TableColumnInfo[] childColInfos = FwTestUtil.getEasyMockTableColumns(catalog, schema, table, columnNames, dataTypes);
        TableColumnInfo[] parentColInfos = FwTestUtil.getEasyMockTableColumns(catalog, schema, table, parentColumnNames, parentDataTypes);
        ISQLDatabaseMetaData tableMockMetaData = FwTestUtil.getEasyMockSQLMetaData("oracle", "jdbc:oracle:thin", false, true);
        this.childTableInfo = new TableInfo(catalog, schema, "childTable", "TABLE", "a comment", tableMockMetaData);
        this.parentTableInfo = new TableInfo(catalog, schema, "parentTable", "TABLE", "a comment", tableMockMetaData);
        this.oneTableList.add(this.childTableInfo);
        this.twoTableList.add(this.childTableInfo);
        this.twoTableList.add(this.parentTableInfo);
        this.mockIndexInfos = FwTestUtil.getEasyMockIndexInfos(table, "data1");
        this.fkinfos = FwTestUtil.getEasyMockForeignKeyInfos("ChildTable_FK", "childTable", "fkcol", "parentTable", pkCol);
        org.easymock.EasyMock.expect((Object)this.mockMetaData.getPrimaryKey(this.childTableInfo)).andReturn((Object)this.pkInfos).anyTimes();
        org.easymock.EasyMock.expect((Object)this.mockMetaData.getPrimaryKey(this.parentTableInfo)).andReturn((Object)noPrimaryKey).anyTimes();
        org.easymock.EasyMock.expect((Object)this.mockMetaData.getColumnInfo(this.childTableInfo)).andReturn((Object)childColInfos).anyTimes();
        org.easymock.EasyMock.expect((Object)this.mockMetaData.getColumnInfo(this.parentTableInfo)).andReturn((Object)parentColInfos).anyTimes();
        org.easymock.EasyMock.expect((Object)this.mockMetaData.getImportedKeysInfo(this.childTableInfo)).andReturn((Object)this.fkinfos).anyTimes();
        org.easymock.EasyMock.expect((Object)this.mockMetaData.getImportedKeysInfo(this.parentTableInfo)).andReturn((Object)noFKArray).anyTimes();
        org.easymock.EasyMock.expect((Object)this.mockMetaData.getIndexInfo(this.childTableInfo)).andReturn(this.mockIndexInfos).anyTimes();
        org.easymock.EasyMock.expect((Object)this.mockMetaData.getIndexInfo(this.parentTableInfo)).andReturn(noIndexList).anyTimes();
        this.replayMocks();
    }

    @After
    public void tearDown() throws Exception {
        this.mockMetaData = null;
        this.childTableInfo = null;
    }

    private void replayMocks() {
        EasyMock.replay((Object[])new Object[]{this.mockMetaData});
    }

    @Test
    public void testGetTableSource() throws SQLException {
        Object[] dbNames;
        for (Object dbName : dbNames = DialectFactory.getDbNames()) {
            HibernateDialect dialect = DialectFactory.getDialect((String)dbName.toString());
            this.checkGetTableSource(dialect, this.oneTableList, this.mockMetaData, this.prefs, false, 3);
        }
    }

    @Test
    public void testConstraintsAfterTable() throws SQLException {
        this.prefs.setConstraintsAtEnd(false);
        this.checkGetTableSource((HibernateDialect)new HSQLDialectExt(), this.twoTableList, this.mockMetaData, this.prefs, false, 4);
    }

    @Test
    public void testGetTableSourceDeleteAction() throws SQLException {
        this.prefs.setDeleteRefAction(true);
        this.prefs.setDeleteAction(0);
        List<String> sqls = this.checkGetTableSource((HibernateDialect)new HSQLDialectExt(), this.twoTableList, this.mockMetaData, this.prefs, false, 4);
        this.checkAction(sqls, "ALTER TABLE", " ON DELETE CASCADE");
        this.prefs.setDeleteAction(2);
        sqls = this.checkGetTableSource((HibernateDialect)new HSQLDialectExt(), this.twoTableList, this.mockMetaData, this.prefs, false, 4);
        this.checkAction(sqls, "ALTER TABLE", " ON DELETE SET NULL");
        this.prefs.setDeleteAction(4);
        sqls = this.checkGetTableSource((HibernateDialect)new HSQLDialectExt(), this.twoTableList, this.mockMetaData, this.prefs, false, 4);
        this.checkAction(sqls, "ALTER TABLE", " ON DELETE SET DEFAULT");
    }

    @Test
    public void testIsJdbcOdbc() throws SQLException {
        this.checkGetTableSource((HibernateDialect)new HSQLDialectExt(), this.twoTableList, this.mockMetaData, this.prefs, true, 2);
    }

    private List<String> checkGetTableSource(HibernateDialect d, List<ITableInfo> tableList, ISQLDatabaseMetaData md, CreateScriptPreferences scriptPrefs, boolean isJdbcOdbc, int sqlCount) throws SQLException {
        List createSQLs = DialectUtils.getCreateTableSQL(tableList, (ISQLDatabaseMetaData)md, (HibernateDialect)d, (CreateScriptPreferences)scriptPrefs, (boolean)isJdbcOdbc);
        Assert.assertEquals((String)"SQL Statement Count", (long)sqlCount, (long)createSQLs.size());
        for (String sql : createSQLs) {
            Assert.assertEquals((String)"sql.length() <= 0", (Object)true, (Object)(sql.length() > 0 ? 1 : 0));
        }
        return createSQLs;
    }

    private void checkAction(List<String> sqls, String prefix, String actionClause) {
        for (String sql : sqls) {
            if (!sql.startsWith(prefix)) continue;
            int idx = sql.indexOf(actionClause);
            Assert.assertTrue((String)("idx == -1: actionClause(" + actionClause + ") not found in sql: " + sql), (idx != -1 ? 1 : 0) != 0);
        }
    }
}

