/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.BaseSQuirreLJUnit4TestCase;
import net.sourceforge.squirrel_sql.fw.sql.ResultSetColumnReader;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ResultSetColumnReaderTest
extends BaseSQuirreLJUnit4TestCase {
    ResultSetColumnReader readerUnderTest = null;
    ResultSet mockResultSet = null;
    ResultSetMetaData mockResultSetMetaData = null;

    @Before
    public void setUp() throws Exception {
        this.mockResultSet = (ResultSet)EasyMock.createMock(ResultSet.class);
        this.mockResultSetMetaData = (ResultSetMetaData)EasyMock.createMock(ResultSetMetaData.class);
    }

    @After
    public void tearDown() throws Exception {
    }

    private void replayAll() {
        EasyMock.replay((Object[])new Object[]{this.mockResultSet});
        EasyMock.replay((Object[])new Object[]{this.mockResultSetMetaData});
    }

    private void verifyAll() {
        EasyMock.verify((Object[])new Object[]{this.mockResultSet});
        EasyMock.verify((Object[])new Object[]{this.mockResultSetMetaData});
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testNullArg() throws SQLException {
        this.readerUnderTest = new ResultSetColumnReader(null);
    }

    @Test
    @Ignore
    public final void testNext() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public final void testGetBoolean() throws SQLException {
        int index = 1;
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)-7);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)-7);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)16);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)16);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)16);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)12);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)12);
        index = 1;
        EasyMock.expect((Object)this.mockResultSet.getMetaData()).andReturn((Object)this.mockResultSetMetaData).anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)1L).anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)0).anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)"true").anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)"false").anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)"true").anyTimes();
        index = 1;
        this.replayAll();
        this.readerUnderTest = new ResultSetColumnReader(this.mockResultSet);
        Boolean value = this.readerUnderTest.getBoolean(index++);
        Assert.assertEquals((Object)true, (Object)value);
        value = this.readerUnderTest.getBoolean(index++);
        Assert.assertEquals((Object)false, (Object)value);
        value = this.readerUnderTest.getBoolean(index++);
        Assert.assertEquals((Object)true, (Object)value);
        value = this.readerUnderTest.getBoolean(index++);
        Assert.assertEquals((Object)false, (Object)value);
        value = this.readerUnderTest.getBoolean(index++);
        Assert.assertEquals((Object)true, (Object)value);
        value = this.readerUnderTest.getBoolean(index++);
        Assert.assertEquals((Object)false, (Object)value);
        value = this.readerUnderTest.getBoolean(index++);
        Assert.assertEquals((Object)true, (Object)value);
        this.verifyAll();
    }

    @Test
    @Ignore
    public final void testGetDate() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public final void testGetDoubleFromNumber() throws SQLException {
        int index = 1;
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)7);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)7);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)7);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)7);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)7);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)12);
        index = 1;
        EasyMock.expect((Object)this.mockResultSet.getMetaData()).andReturn((Object)this.mockResultSetMetaData).anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)123L).anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)345).anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)Float.valueOf(123.5f)).anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)127).anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)"567").anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)"789").anyTimes();
        index = 1;
        this.replayAll();
        this.readerUnderTest = new ResultSetColumnReader(this.mockResultSet);
        Double value = this.readerUnderTest.getDouble(index++);
        Assert.assertEquals((String)"", (Object)new Double(123.0), (Object)value);
        value = this.readerUnderTest.getDouble(index++);
        Assert.assertEquals((Object)new Double(345.0), (Object)value);
        value = this.readerUnderTest.getDouble(index++);
        Assert.assertEquals((Object)new Double(123.5), (Object)value);
        value = this.readerUnderTest.getDouble(index++);
        Assert.assertEquals((Object)new Double(127.0), (Object)value);
        value = this.readerUnderTest.getDouble(index++);
        Assert.assertEquals((Object)new Double(567.0), (Object)value);
        value = this.readerUnderTest.getDouble(index++);
        Assert.assertEquals((Object)new Double(789.0), (Object)value);
        this.verifyAll();
    }

    @Test
    public final void testGetLong() throws SQLException {
        int index = 1;
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)5);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)-6);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)4);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)-5);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)7);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)12);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)-7);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(index++)).andReturn((Object)-7);
        index = 1;
        EasyMock.expect((Object)this.mockResultSet.getMetaData()).andReturn((Object)this.mockResultSetMetaData).anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)123L).anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)345).anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)"123").anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)127).anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)"567").anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)"789").anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)"true").anyTimes();
        EasyMock.expect((Object)this.mockResultSet.getObject(index++)).andReturn((Object)"false").anyTimes();
        index = 1;
        this.replayAll();
        this.readerUnderTest = new ResultSetColumnReader(this.mockResultSet);
        Long value = this.readerUnderTest.getLong(index++);
        Assert.assertEquals((Object)new Long(123L), (Object)value);
        value = this.readerUnderTest.getLong(index++);
        Assert.assertEquals((Object)new Long(345L), (Object)value);
        value = this.readerUnderTest.getLong(index++);
        Assert.assertEquals((Object)new Long(123L), (Object)value);
        value = this.readerUnderTest.getLong(index++);
        Assert.assertEquals((Object)new Long(127L), (Object)value);
        value = this.readerUnderTest.getLong(index++);
        Assert.assertEquals((Object)new Long(567L), (Object)value);
        value = this.readerUnderTest.getLong(index++);
        Assert.assertEquals((Object)new Long(789L), (Object)value);
        value = this.readerUnderTest.getLong(index++);
        Assert.assertEquals((Object)new Long(1L), (Object)value);
        value = this.readerUnderTest.getLong(index++);
        Assert.assertEquals((Object)new Long(0L), (Object)value);
        this.verifyAll();
    }

    @Test
    @Ignore
    public final void testGetObject() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public final void testGetString() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public final void testGetTime() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public final void testGetTimeStamp() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public final void testWasNull() {
        Assert.fail((String)"Not yet implemented");
    }
}

