/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import net.sourceforge.squirrel_sql.BaseSQuirreLTestCase;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DTProperties;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.sql.ResultSetReader;
import org.easymock.EasyMock;
import utils.EasyMockHelper;

public class ResultSetReaderTest
extends BaseSQuirreLTestCase {
    private static final String dateClassName = "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeDate";
    EasyMockHelper mockHelper = new EasyMockHelper();
    ResultSet mockResultSet = null;
    ResultSetMetaData mockResultSetMetaData = null;
    ResultSetReader readerUnderTest = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.mockResultSet = (ResultSet)EasyMock.createMock(ResultSet.class);
        this.mockResultSetMetaData = (ResultSetMetaData)EasyMock.createMock(ResultSetMetaData.class);
        EasyMock.expect((Object)this.mockResultSet.getMetaData()).andReturn((Object)this.mockResultSetMetaData);
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnCount()).andReturn((Object)1).atLeastOnce();
        EasyMock.expect((Object)this.mockResultSet.next()).andReturn((Object)true).once();
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnType(1)).andReturn((Object)91).anyTimes();
        EasyMock.expect((Object)this.mockResultSetMetaData.getColumnTypeName(1)).andReturn((Object)"DATE").anyTimes();
        EasyMock.expect((Object)this.mockResultSet.wasNull()).andReturn((Object)false).anyTimes();
    }

    private void verifyAll() {
        EasyMock.verify((Object[])new Object[]{this.mockResultSet});
        EasyMock.verify((Object[])new Object[]{this.mockResultSetMetaData});
    }

    private void replayAll() {
        EasyMock.replay((Object[])new Object[]{this.mockResultSet});
        EasyMock.replay((Object[])new Object[]{this.mockResultSetMetaData});
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReadDateAsTimestamp() throws SQLException {
        this.testReadType(Timestamp.class.getName(), "true");
    }

    public void testReadDateAsDate() throws SQLException {
        this.testReadType(Date.class.getName(), "false");
    }

    public void testReadDateAsDefault() throws SQLException {
        this.testReadType(Date.class.getName(), null);
    }

    public void testReadLongValue() throws SQLException {
        Long unsignedIntegerValue = 0xFFFFFFFFL;
        ResultSet localMockResultSet = this.mockHelper.createMock(ResultSet.class);
        ResultSetMetaData mockResultSetMetaData = this.mockHelper.createMock(ResultSetMetaData.class);
        EasyMock.expect((Object)localMockResultSet.getMetaData()).andReturn((Object)mockResultSetMetaData);
        EasyMock.expect((Object)mockResultSetMetaData.getColumnCount()).andReturn((Object)1);
        EasyMock.expect((Object)localMockResultSet.next()).andReturn((Object)true);
        EasyMock.expect((Object)mockResultSetMetaData.getColumnType(1)).andReturn((Object)4);
        EasyMock.expect((Object)mockResultSetMetaData.getColumnTypeName(1)).andReturn((Object)"INTEGER UNSIGNED");
        EasyMock.expect((Object)localMockResultSet.getObject(1)).andReturn((Object)unsignedIntegerValue);
        EasyMock.expect((Object)localMockResultSet.wasNull()).andReturn((Object)false);
        this.mockHelper.replayAll();
        this.readerUnderTest = new ResultSetReader(localMockResultSet, DialectType.MYSQL5);
        Object[] row = this.readerUnderTest.readRow();
        ResultSetReaderTest.assertEquals((Object)unsignedIntegerValue, (Object)row[0]);
        this.mockHelper.verifyAll();
    }

    private void testReadType(String type, String readDatePropVal) throws SQLException {
        DTProperties.put((String)dateClassName, (String)"readDateAsTimestamp", (String)readDatePropVal);
        long now = System.currentTimeMillis();
        if (type.equals(Date.class.getName())) {
            EasyMock.expect((Object)this.mockResultSet.getDate(1)).andReturn((Object)new Date(now));
        }
        if (type.equals(Timestamp.class.getName())) {
            EasyMock.expect((Object)this.mockResultSet.getTimestamp(1)).andReturn((Object)new Timestamp(now));
        }
        this.replayAll();
        this.readerUnderTest = new ResultSetReader(this.mockResultSet, DialectType.ORACLE);
        Object[] result = this.readerUnderTest.readRow();
        if (!result[0].getClass().getName().equals(type)) {
            ResultSetReaderTest.fail((String)("result[0] not a Date: " + result[0].getClass().getName()));
        }
        this.verifyAll();
    }
}

