/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.BaseSQuirreLJUnit4TestCase;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.IUDTInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.dbobj.BestRowIdentifier;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import utils.EasyMockHelper;

public class SQLDatabaseMetaDataTest
extends BaseSQuirreLJUnit4TestCase {
    private static final String TEST_TABLE = "aTable";
    private static final String TEST_SCHEMA = "aSchema";
    private static final String TEST_CATALOG = "aCatalog";
    private SQLDatabaseMetaData classUnderTest = null;
    private EasyMockHelper mockHelper = new EasyMockHelper();
    private Connection mockConnection = this.mockHelper.createMock(Connection.class);
    private ISQLConnection mockSqlConnection = this.mockHelper.createMock(ISQLConnection.class);
    private DatabaseMetaData mockDatabaseMetaData = this.mockHelper.createMock(DatabaseMetaData.class);

    @Before
    public void setUp() throws Exception {
        EasyMock.expect((Object)this.mockDatabaseMetaData.getDatabaseProductName()).andStubReturn((Object)"PostgreSQL");
        EasyMock.expect((Object)this.mockDatabaseMetaData.getDatabaseProductVersion()).andStubReturn((Object)"8.1.8");
        EasyMock.expect((Object)this.mockDatabaseMetaData.supportsSchemasInIndexDefinitions()).andStubReturn((Object)true);
        EasyMock.expect((Object)this.mockDatabaseMetaData.supportsSchemasInDataManipulation()).andStubReturn((Object)true);
        EasyMock.expect((Object)this.mockDatabaseMetaData.supportsCatalogsInDataManipulation()).andStubReturn((Object)true);
        EasyMock.expect((Object)this.mockDatabaseMetaData.supportsSchemasInTableDefinitions()).andStubReturn((Object)true);
        EasyMock.expect((Object)this.mockDatabaseMetaData.getCatalogSeparator()).andStubReturn((Object)".");
        EasyMock.expect((Object)this.mockDatabaseMetaData.getIdentifierQuoteString()).andStubReturn((Object)"\"");
        EasyMock.expect((Object)this.mockConnection.getMetaData()).andStubReturn((Object)this.mockDatabaseMetaData);
        EasyMock.expect((Object)this.mockSqlConnection.getConnection()).andStubReturn((Object)this.mockConnection);
    }

    @Test
    public void testGetSchemas() throws SQLException {
        ResultSet schemaResultSet1 = this.buildVarcharResultSetAsRows("schemaResultSet1", new String[]{TEST_SCHEMA});
        ResultSet schemaResultSet2 = this.buildVarcharResultSetAsRows("schemaResultSet2", new String[]{TEST_SCHEMA, "aSchema2"});
        EasyMock.expect((Object)this.mockDatabaseMetaData.getSchemas()).andReturn((Object)schemaResultSet1);
        EasyMock.expect((Object)this.mockDatabaseMetaData.getSchemas()).andReturn((Object)schemaResultSet2);
        this.mockHelper.replayAll();
        this.classUnderTest = new SQLDatabaseMetaData(this.mockSqlConnection);
        String[] currentSchemas = this.classUnderTest.getSchemas();
        Assert.assertEquals((long)1L, (long)currentSchemas.length);
        currentSchemas = this.classUnderTest.getSchemas();
        Assert.assertEquals((long)2L, (long)currentSchemas.length);
        this.mockHelper.verifyAll();
    }

    @Test
    public void testGetCatalogs() throws SQLException {
        ResultSet catalogResultSet1 = this.buildVarcharResultSetAsRows(null, new String[]{TEST_CATALOG});
        ResultSet catalogResultSet2 = this.buildVarcharResultSetAsRows(null, new String[]{TEST_CATALOG, "aCatalog2"});
        EasyMock.expect((Object)this.mockDatabaseMetaData.getCatalogs()).andReturn((Object)catalogResultSet1);
        EasyMock.expect((Object)this.mockDatabaseMetaData.getCatalogs()).andReturn((Object)catalogResultSet2);
        this.mockHelper.replayAll();
        this.classUnderTest = new SQLDatabaseMetaData(this.mockSqlConnection);
        String[] currentCatalogs = this.classUnderTest.getCatalogs();
        Assert.assertEquals((long)1L, (long)currentCatalogs.length);
        currentCatalogs = this.classUnderTest.getCatalogs();
        Assert.assertEquals((long)2L, (long)currentCatalogs.length);
        this.mockHelper.verifyAll();
    }

    @Test
    public void testPGGetTableTypes() throws SQLException {
        ResultSet mockTableTypeResultSet = this.buildVarcharResultSetAsRows("mockTableTypeResultSet", new String[]{"SYSTEM INDEX", "SYSTEM VIEW", "SYSTEM TABLE", "SYSTEM TOAST INDEX", "SYSTEM TOAST TABLE", "SYSTEM VIEW", "TABLE", "TEMPORARY INDEX", "TEMPORARY TABLE", "VIEW"});
        EasyMock.expect((Object)this.mockDatabaseMetaData.getTableTypes()).andStubReturn((Object)mockTableTypeResultSet);
        this.mockHelper.replayAll();
        this.classUnderTest = new SQLDatabaseMetaData(this.mockSqlConnection);
        String[] tableTypes = this.classUnderTest.getTableTypes();
        for (int i = 0; i < tableTypes.length; ++i) {
            String type = tableTypes[i];
            Assert.assertFalse((String)"'SYSTEM INDEX' is a type returned from SQLDatabaseMetaData.getTableTypes for PostgreSQL - it should not be.", (boolean)"SYSTEM INDEX".equals(type));
        }
        this.mockHelper.verifyAll();
    }

    @Test
    public void testGetIdentifierQuoteStringMSSQL() throws SQLException {
        Connection mockCon = this.mockHelper.createMock(Connection.class);
        DatabaseMetaData md = this.mockHelper.createMock(DatabaseMetaData.class);
        EasyMock.expect((Object)md.getIdentifierQuoteString()).andStubReturn((Object)"foo");
        EasyMock.expect((Object)mockCon.getMetaData()).andStubReturn((Object)md);
        ISQLConnection sqlcon = this.mockHelper.createMock(ISQLConnection.class);
        EasyMock.expect((Object)sqlcon.getConnection()).andStubReturn((Object)mockCon);
        SQLDatabaseMetaData sqlmd = new SQLDatabaseMetaData(sqlcon);
        this.mockHelper.replayAll();
        String quoteString = sqlmd.getIdentifierQuoteString();
        Assert.assertEquals((Object)"foo", (Object)quoteString);
        quoteString = sqlmd.getIdentifierQuoteString();
        Assert.assertEquals((Object)"foo", (Object)quoteString);
        quoteString = sqlmd.getIdentifierQuoteString();
        Assert.assertEquals((Object)"foo", (Object)quoteString);
        quoteString = sqlmd.getIdentifierQuoteString();
        Assert.assertEquals((Object)"foo", (Object)quoteString);
        this.mockHelper.verifyAll();
    }

    @Test
    public void testGetBestRowIdentifier() throws SQLException {
        ITableInfo mockTableInfo = this.mockHelper.createMock(ITableInfo.class);
        ResultSet mockBestRowIdResultSet = this.mockHelper.createMock(ResultSet.class);
        ResultSetMetaData mockResultSetMetaData = this.mockHelper.createMock(ResultSetMetaData.class);
        EasyMock.expect((Object)mockTableInfo.getCatalogName()).andStubReturn((Object)TEST_CATALOG);
        EasyMock.expect((Object)mockTableInfo.getSchemaName()).andStubReturn((Object)TEST_SCHEMA);
        EasyMock.expect((Object)mockTableInfo.getSimpleName()).andStubReturn((Object)TEST_TABLE);
        EasyMock.expect((Object)this.mockDatabaseMetaData.getBestRowIdentifier(TEST_CATALOG, TEST_SCHEMA, TEST_TABLE, 1, true));
        EasyMock.expectLastCall().andReturn((Object)mockBestRowIdResultSet);
        EasyMock.expect((Object)mockBestRowIdResultSet.getMetaData()).andReturn((Object)mockResultSetMetaData);
        EasyMock.expect((Object)mockBestRowIdResultSet.getObject(1)).andReturn((Object)1);
        EasyMock.expect((Object)mockResultSetMetaData.getColumnType(1)).andReturn((Object)-5);
        EasyMock.expect((Object)mockBestRowIdResultSet.getString(2)).andReturn((Object)"aColumn");
        EasyMock.expect((Object)mockBestRowIdResultSet.getObject(3)).andReturn((Object)3);
        EasyMock.expect((Object)mockResultSetMetaData.getColumnType(3)).andReturn((Object)5);
        EasyMock.expect((Object)mockBestRowIdResultSet.getString(4)).andReturn((Object)"SMALLINT");
        EasyMock.expect((Object)mockBestRowIdResultSet.getObject(5)).andReturn((Object)5);
        EasyMock.expect((Object)mockResultSetMetaData.getColumnType(5)).andReturn((Object)4);
        EasyMock.expect((Object)mockBestRowIdResultSet.getObject(7)).andReturn((Object)7);
        EasyMock.expect((Object)mockResultSetMetaData.getColumnType(7)).andReturn((Object)-6);
        EasyMock.expect((Object)mockBestRowIdResultSet.getObject(8)).andReturn((Object)8);
        EasyMock.expect((Object)mockResultSetMetaData.getColumnType(8)).andReturn((Object)-6);
        EasyMock.expect((Object)mockBestRowIdResultSet.next()).andReturn((Object)true);
        EasyMock.expect((Object)mockBestRowIdResultSet.next()).andReturn((Object)false);
        mockBestRowIdResultSet.close();
        this.mockHelper.replayAll();
        this.classUnderTest = new SQLDatabaseMetaData(this.mockSqlConnection);
        BestRowIdentifier[] result = this.classUnderTest.getBestRowIdentifier(mockTableInfo);
        Assert.assertEquals((long)1L, (long)result.length);
        BestRowIdentifier rid = result[0];
        Assert.assertEquals((long)1L, (long)rid.getScope());
        Assert.assertEquals((Object)"aColumn", (Object)rid.getColumnName());
        Assert.assertEquals((long)3L, (long)rid.getSQLDataType());
        Assert.assertEquals((Object)"SMALLINT", (Object)rid.getTypeName());
        Assert.assertEquals((long)5L, (long)rid.getPrecision());
        Assert.assertEquals((long)7L, (long)rid.getScale());
        Assert.assertEquals((long)8L, (long)rid.getPseudoColumn());
        this.mockHelper.verifyAll();
    }

    @Test
    public void testGetUDTs() throws SQLException {
        String javaClassName = "java.lang.String";
        String remarkValue = "remark";
        String dataType = "12";
        String[] values = new String[]{TEST_CATALOG, TEST_SCHEMA, "JAVA_OBJECT", "java.lang.String", "12", "remark"};
        ResultSet mockResultSet = this.buildVarcharResultSetAsColumns("UDTResultSet", values);
        this.mockDatabaseMetaData.getUDTs(TEST_CATALOG, TEST_SCHEMA, TEST_TABLE, null);
        EasyMock.expectLastCall().andStubReturn((Object)mockResultSet);
        this.mockHelper.replayAll();
        this.classUnderTest = new SQLDatabaseMetaData(this.mockSqlConnection);
        IUDTInfo[] result = this.classUnderTest.getUDTs(TEST_CATALOG, TEST_SCHEMA, TEST_TABLE, null);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertEquals((Object)"java.lang.String", (Object)result[0].getJavaClassName());
        Assert.assertEquals((Object)"12", (Object)result[0].getDataType());
        Assert.assertEquals((Object)"remark", (Object)result[0].getRemarks());
        this.mockHelper.verifyAll();
    }

    private ResultSet buildVarcharResultSetAsColumns(String mockName, String[] values) throws SQLException {
        ResultSetMetaData rsmd = this.mockHelper.createMock(mockName, ResultSetMetaData.class);
        EasyMock.expect((Object)rsmd.getColumnCount()).andStubReturn((Object)values.length);
        ResultSet rs = this.mockHelper.createMock(ResultSet.class);
        EasyMock.expect((Object)rs.getMetaData()).andStubReturn((Object)rsmd);
        int count = 1;
        for (String value : values) {
            EasyMock.expect((Object)rs.getString(count)).andStubReturn((Object)value);
            EasyMock.expect((Object)rs.wasNull()).andStubReturn((Object)false);
            EasyMock.expect((Object)rsmd.getColumnTypeName(count)).andStubReturn((Object)"varchar");
            EasyMock.expect((Object)rsmd.getColumnType(count++)).andStubReturn((Object)12);
        }
        EasyMock.expect((Object)rs.next()).andReturn((Object)true);
        EasyMock.expect((Object)rs.next()).andReturn((Object)false);
        rs.close();
        return rs;
    }

    private ResultSet buildVarcharResultSetAsRows(String mockName, String[] values) throws SQLException {
        ResultSetMetaData rsmd = this.mockHelper.createMock(mockName + "MetaData", ResultSetMetaData.class);
        EasyMock.expect((Object)rsmd.getColumnCount()).andStubReturn((Object)1);
        ResultSet rs = this.mockHelper.createMock(mockName, ResultSet.class);
        EasyMock.expect((Object)rs.getMetaData()).andStubReturn((Object)rsmd);
        EasyMock.expect((Object)rsmd.getColumnTypeName(1)).andStubReturn((Object)"varchar");
        EasyMock.expect((Object)rsmd.getColumnType(1)).andStubReturn((Object)12);
        for (String value : values) {
            EasyMock.expect((Object)rs.getString(1)).andReturn((Object)value);
            EasyMock.expect((Object)rs.next()).andReturn((Object)true);
            EasyMock.expect((Object)rs.wasNull()).andStubReturn((Object)false);
        }
        EasyMock.expect((Object)rs.next()).andReturn((Object)false);
        rs.close();
        return rs;
    }
}

