/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import com.gargoylesoftware.base.testing.EqualsTester;
import net.sourceforge.squirrel_sql.BaseSQuirreLJUnit4TestCase;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriver;
import org.junit.Assert;
import org.junit.Test;
import utils.EasyMockHelper;

public class SQLDriverTest
extends BaseSQuirreLJUnit4TestCase {
    SQLDriver classUnderTest = new SQLDriver();
    EasyMockHelper mockHelper = new EasyMockHelper();

    @Test
    public void testGetName() throws Exception {
        this.classUnderTest.setName("aTestString");
        Assert.assertEquals((Object)"aTestString", (Object)this.classUnderTest.getName());
    }

    @Test
    public void testGetJarFileNames() throws Exception {
        this.classUnderTest.setJarFileNames(null);
        Assert.assertEquals((long)0L, (long)this.classUnderTest.getJarFileNames().length);
    }

    @Test
    public void testGetDriverClassName() throws Exception {
        this.classUnderTest.setDriverClassName("aTestString");
        Assert.assertEquals((Object)"aTestString", (Object)this.classUnderTest.getDriverClassName());
    }

    @Test(expected=ValidationException.class)
    public void testSetDriverClassNameNull() throws Exception {
        this.classUnderTest.setDriverClassName(null);
    }

    @Test
    public void testGetUrl() throws Exception {
        this.classUnderTest.setUrl("aTestString");
        Assert.assertEquals((Object)"aTestString", (Object)this.classUnderTest.getUrl());
    }

    @Test(expected=ValidationException.class)
    public void testSetUrlNull() throws Exception {
        this.classUnderTest.setUrl(null);
    }

    @Test
    public void testIsJDBCDriverClassLoaded() throws Exception {
        this.classUnderTest.setJDBCDriverClassLoaded(true);
        Assert.assertEquals((Object)true, (Object)this.classUnderTest.isJDBCDriverClassLoaded());
    }

    @Test
    public void testGetWebSiteUrl() throws Exception {
        this.classUnderTest.setWebSiteUrl("aTestString");
        Assert.assertEquals((Object)"aTestString", (Object)this.classUnderTest.getWebSiteUrl());
    }

    @Test
    public void testGetIdentifier() throws Exception {
        this.classUnderTest.setIdentifier(null);
        Assert.assertNull((Object)this.classUnderTest.getIdentifier());
    }

    @Test
    public void testGetJarFileName() throws Exception {
        this.classUnderTest.setJarFileName("aTestString");
        Assert.assertEquals((Object)"aTestString", (Object)this.classUnderTest.getJarFileName());
    }

    @Test
    public void testGetJarFileNameWrappers() throws Exception {
        this.classUnderTest.setJarFileNameWrappers(null);
        Assert.assertTrue((this.classUnderTest.getJarFileNameWrappers().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetJarFileNameWrapper() throws Exception {
        this.classUnderTest.setJarFileNames(new String[]{"test.jar"});
        Assert.assertEquals((Object)"test.jar", (Object)this.classUnderTest.getJarFileNameWrapper(0).getString());
    }

    @Test
    public void testEqualsAndHashcode() throws Exception {
        IIdentifier id1 = this.mockHelper.createMock(IIdentifier.class);
        IIdentifier id2 = this.mockHelper.createMock(IIdentifier.class);
        this.mockHelper.replayAll();
        SQLDriver a = new SQLDriver(id1);
        SQLDriver b = new SQLDriver(id1);
        SQLDriver c = new SQLDriver(id2);
        SQLDriver d = new SQLDriver(id1){
            private static final long serialVersionUID = 1L;
        };
        new EqualsTester((Object)a, (Object)b, (Object)c, (Object)d);
        this.mockHelper.verifyAll();
    }
}

