/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import org.junit.Assert;

public class SQLUtil {
    private static int genericSQLCount = 0;

    public static String getGenericSQLScript() {
        StringBuffer result = new StringBuffer();
        result.append("create table student (     sno     integer,     sname   varchar(10),     age     integer ); ");
        result.append("\n\n");
        result.append("create table courses (     cno     varchar(5),     title   varchar(10),     credits integer ); ");
        result.append("\n\n");
        result.append("create table professor (     lname   varchar(10),     dept    varchar(10),     salary  integer,     age     integer ); ");
        result.append("\n\n");
        result.append("create table take (     sno     integer,     cno varchar(15) ); ");
        result.append("\n\n");
        result.append("create table teach (     lname   varchar(10),     cno     varchar(5) ); ");
        result.append("\n\n");
        result.append("select * from student where sno not in (select sno                   from take                   where cno = 'CS112'); ");
        result.append("\n\n");
        genericSQLCount = 6;
        return result.toString();
    }

    public static void checkQueryTokenizer(IQueryTokenizer qt, int stmtCount) {
        int count = 0;
        while (qt.hasQuery()) {
            ++count;
            String query = qt.nextQuery();
            Assert.assertNotNull((Object)query);
        }
        junit.framework.Assert.assertEquals((int)stmtCount, (int)count);
    }

    public static void setGenericSQLCount(int genericSQLCount) {
        SQLUtil.genericSQLCount = genericSQLCount;
    }

    public static int getGenericSQLCount() {
        return genericSQLCount;
    }

    public static String createSQLFile(List<String> sqls, boolean deleteOnExit) throws IOException {
        File f = File.createTempFile("test", ".sql");
        if (deleteOnExit) {
            f.deleteOnExit();
        }
        PrintWriter out = new PrintWriter(new FileWriter(f));
        for (String sql : sqls) {
            out.println(sql);
            out.println();
        }
        out.close();
        String tmpFilename = f.getAbsolutePath();
        System.out.println("tmpFilename=" + tmpFilename);
        return tmpFilename;
    }
}

