/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.BaseSQuirreLJUnit4TestCase;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.ProgressCallBack;
import net.sourceforge.squirrel_sql.fw.sql.ProgressCallBackAdaptor;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SQLUtilitiesTest
extends BaseSQuirreLJUnit4TestCase {
    private ITableInfo mockTable1;
    private ITableInfo mockTable2;
    private ITableInfo mockTable3;
    private SQLDatabaseMetaData mockSQLDatabaseMetaData;

    public SQLUtilitiesTest() {
        this.mockTable1 = this.mockHelper.createMock("mockTable1", ITableInfo.class);
        this.mockTable2 = this.mockHelper.createMock("mockTable2", ITableInfo.class);
        this.mockTable3 = this.mockHelper.createMock("mockTable3", ITableInfo.class);
        this.mockSQLDatabaseMetaData = this.mockHelper.createMock("mockSQLDatabaseMetaData", SQLDatabaseMetaData.class);
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetInsertionOrder() throws SQLException {
        ArrayList<ITableInfo> tables = new ArrayList<ITableInfo>();
        EasyMock.expect((Object)this.mockTable1.getSimpleName()).andStubReturn((Object)"mockTable1");
        EasyMock.expect((Object)this.mockTable1.getImportedKeys()).andStubReturn(null);
        EasyMock.expect((Object)this.mockTable1.getExportedKeys()).andStubReturn(null);
        EasyMock.expect((Object)this.mockTable2.getSimpleName()).andStubReturn((Object)"mockTable2");
        EasyMock.expect((Object)this.mockTable2.getImportedKeys()).andStubReturn(null);
        EasyMock.expect((Object)this.mockTable2.getExportedKeys()).andStubReturn(null);
        EasyMock.expect((Object)this.mockTable3.getSimpleName()).andStubReturn((Object)"mockTable3");
        EasyMock.expect((Object)this.mockTable3.getImportedKeys()).andStubReturn(null);
        EasyMock.expect((Object)this.mockTable3.getExportedKeys()).andStubReturn(null);
        tables.add(this.mockTable1);
        tables.add(this.mockTable2);
        tables.add(this.mockTable3);
        ForeignKeyInfo[] noFkArray = new ForeignKeyInfo[]{};
        EasyMock.expect((Object)this.mockSQLDatabaseMetaData.getImportedKeysInfo(this.mockTable1)).andStubReturn((Object)noFkArray);
        this.mockTable1.setImportedKeys(noFkArray);
        EasyMock.expect((Object)this.mockSQLDatabaseMetaData.getExportedKeysInfo(this.mockTable1)).andStubReturn((Object)noFkArray);
        this.mockTable1.setExportedKeys(noFkArray);
        EasyMock.expect((Object)this.mockSQLDatabaseMetaData.getImportedKeysInfo(this.mockTable2)).andStubReturn((Object)noFkArray);
        this.mockTable2.setImportedKeys(noFkArray);
        EasyMock.expect((Object)this.mockSQLDatabaseMetaData.getExportedKeysInfo(this.mockTable2)).andStubReturn((Object)noFkArray);
        this.mockTable2.setExportedKeys(noFkArray);
        EasyMock.expect((Object)this.mockSQLDatabaseMetaData.getImportedKeysInfo(this.mockTable3)).andStubReturn((Object)noFkArray);
        this.mockTable3.setImportedKeys(noFkArray);
        EasyMock.expect((Object)this.mockSQLDatabaseMetaData.getExportedKeysInfo(this.mockTable3)).andStubReturn((Object)noFkArray);
        this.mockTable3.setExportedKeys(noFkArray);
        this.mockHelper.replayAll();
        try {
            List result = SQLUtilities.getInsertionOrder(tables, (SQLDatabaseMetaData)this.mockSQLDatabaseMetaData, (ProgressCallBack)new ProgressCallBackAdaptor());
            Assert.assertEquals((long)tables.size(), (long)result.size());
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
        this.mockHelper.verifyAll();
    }

    @Test
    public void testNullQuoteIdentifier() {
        Assert.assertNull((Object)SQLUtilities.quoteIdentifier(null));
    }

    @Test
    public void testQuoteIdentifierWithEmbeddedQuotes() {
        String tableNameWithAnEmbeddedQuote = "foo\"bar";
        String newTableName = SQLUtilities.quoteIdentifier((String)tableNameWithAnEmbeddedQuote);
        Assert.assertEquals((Object)"foo\"\"bar", (Object)newTableName);
        tableNameWithAnEmbeddedQuote = "\"foo\"bar\"";
        newTableName = SQLUtilities.quoteIdentifier((String)tableNameWithAnEmbeddedQuote);
        Assert.assertEquals((Object)"\"foo\"\"bar\"", (Object)newTableName);
        String tableName = "MyTable";
        String quotedTableName = SQLUtilities.quoteIdentifier((String)tableName);
        Assert.assertEquals((Object)tableName, (Object)quotedTableName);
    }
}

