/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import com.gargoylesoftware.base.testing.EqualsTester;
import net.sourceforge.squirrel_sql.BaseSQuirreLJUnit4TestCase;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.UDTInfo;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import utils.EasyMockHelper;

public class UDTInfoTest
extends BaseSQuirreLJUnit4TestCase {
    private static final String TEST_SCHEMA = "aSchema";
    private static final String TEST_CATALOG = "aCatalog";
    EasyMockHelper mockHelper = new EasyMockHelper();
    SQLDatabaseMetaData mockMetaData = this.mockHelper.createMock(SQLDatabaseMetaData.class);

    @Before
    public void setUp() throws Exception {
        EasyMock.expect((Object)this.mockMetaData.supportsSchemasInDataManipulation()).andStubReturn((Object)true);
        EasyMock.expect((Object)this.mockMetaData.getDatabaseProductName()).andStubReturn((Object)"oracle");
        EasyMock.expect((Object)this.mockMetaData.getDatabaseProductVersion()).andStubReturn((Object)"10g");
        EasyMock.expect((Object)this.mockMetaData.supportsCatalogsInDataManipulation()).andStubReturn((Object)true);
        EasyMock.expect((Object)this.mockMetaData.supportsSchemasInTableDefinitions()).andStubReturn((Object)true);
        EasyMock.expect((Object)this.mockMetaData.getCatalogSeparator()).andStubReturn((Object)".");
        EasyMock.expect((Object)this.mockMetaData.getIdentifierQuoteString()).andStubReturn((Object)"'");
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testEqualsAndHashcode() {
        this.mockHelper.replayAll();
        UDTInfo a = new UDTInfo(TEST_CATALOG, TEST_SCHEMA, "userDefinedType", "java.lang.String", "12", "UDT-A", this.mockMetaData);
        UDTInfo a2 = new UDTInfo(TEST_CATALOG, TEST_SCHEMA, "userDefinedType", "java.lang.String", "12", "UDT-A", this.mockMetaData);
        UDTInfo c = new UDTInfo(TEST_CATALOG, TEST_SCHEMA, "userDefinedType2", "java.lang.Object", "-3", "UDT-C", this.mockMetaData);
        UDTInfo d = new UDTInfo(TEST_CATALOG, TEST_SCHEMA, "userDefinedType2", "java.lang.Object", "-3", "UDT-C", this.mockMetaData){
            private static final long serialVersionUID = 1L;
        };
        new EqualsTester((Object)a, (Object)a2, (Object)c, (Object)d);
        UDTInfo a3 = new UDTInfo(TEST_CATALOG, TEST_SCHEMA, "userDefinedType", null, "12", "UDT-A", this.mockMetaData);
        new EqualsTester((Object)a, (Object)a2, (Object)a3, (Object)d);
        UDTInfo a4 = new UDTInfo(TEST_CATALOG, TEST_SCHEMA, "userDefinedType", "java.lang.String", null, "UDT-A", this.mockMetaData);
        new EqualsTester((Object)a, (Object)a2, (Object)a4, (Object)d);
        UDTInfo a5 = new UDTInfo(TEST_CATALOG, TEST_SCHEMA, "userDefinedType", "java.lang.String", "12", "No Remarks", this.mockMetaData);
        new EqualsTester((Object)a, (Object)a2, (Object)a5, (Object)d);
        this.mockHelper.verifyAll();
    }
}

