/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sourceforge.squirrel_sql.BaseSQuirreLJUnit4TestCase;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractResourcesTest
extends BaseSQuirreLJUnit4TestCase {
    protected Resources classUnderTest = null;
    protected String getIconArgument = null;

    @After
    public void tearDown() throws Exception {
        this.classUnderTest = null;
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testGetKeyStroke_nullAction() {
        this.mockHelper.replayAll();
        this.classUnderTest.getKeyStroke(null);
        this.mockHelper.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testAddToPopupMenu_nullAction() {
        JPopupMenu mockPopupMenu = this.mockHelper.createMock(JPopupMenu.class);
        this.mockHelper.replayAll();
        this.classUnderTest.addToPopupMenu(null, mockPopupMenu);
        this.mockHelper.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testAddToPopupMenu_nullMenu() {
        Action mockAction = this.mockHelper.createMock(Action.class);
        this.mockHelper.replayAll();
        this.classUnderTest.addToPopupMenu(mockAction, null);
        this.mockHelper.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testAddToMenuAsCheckBoxMenuItemActionJMenu_nullAction() {
        JMenu mockMenu = this.mockHelper.createMock(JMenu.class);
        this.mockHelper.replayAll();
        this.classUnderTest.addToMenuAsCheckBoxMenuItem(null, mockMenu);
        this.mockHelper.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testAddToMenuAsCheckBoxMenuItemActionJMenu_nullMenu() {
        JMenu nullMenu = null;
        Action mockAction = this.mockHelper.createMock(Action.class);
        this.mockHelper.replayAll();
        this.classUnderTest.addToMenuAsCheckBoxMenuItem(mockAction, nullMenu);
        this.mockHelper.verifyAll();
    }

    @Test
    public void testGetIcon() {
        if (this.getIconArgument != null) {
            Assert.assertNotNull((Object)this.classUnderTest.getIcon(this.getIconArgument));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testGetIconString_nullArg() {
        String nullStr = null;
        this.mockHelper.replayAll();
        this.classUnderTest.getIcon(nullStr);
        this.mockHelper.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testGetIconStringString_nullKeyName() {
        String nullKey = null;
        this.mockHelper.replayAll();
        this.classUnderTest.getIcon(nullKey, "testPropName");
        this.mockHelper.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testGetIconStringString_nullPropName() {
        String nullPropName = null;
        this.mockHelper.replayAll();
        this.classUnderTest.getIcon("testKeyName", nullPropName);
        this.mockHelper.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testGetString_nullArg() {
        this.mockHelper.replayAll();
        Assert.assertNotNull((Object)this.classUnderTest.getString(null));
        this.mockHelper.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigureMenuItem_nullAction() {
        Action mockAction = this.mockHelper.createMock(Action.class);
        JMenuItem nullMenuItem = null;
        this.mockHelper.replayAll();
        this.classUnderTest.configureMenuItem(mockAction, nullMenuItem);
        this.mockHelper.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigureMenuItem_nullMenuItem() {
        Action nullAction = null;
        JMenuItem mockMenuItem = this.mockHelper.createMock(JMenuItem.class);
        this.mockHelper.replayAll();
        this.classUnderTest.configureMenuItem(nullAction, mockMenuItem);
        this.mockHelper.verifyAll();
    }

    @Test
    public final void testGetBundle() {
        this.mockHelper.replayAll();
        Assert.assertNotNull((Object)this.classUnderTest.getBundle());
        this.mockHelper.verifyAll();
    }
}

