/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sourceforge.squirrel_sql.BaseSQuirreLTestCase;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperImpl;
import net.sourceforge.squirrel_sql.fw.util.Support_PlatformFile;

public class FileTest
extends BaseSQuirreLTestCase {
    private FileWrapper tempDirectory;
    private FileWrapper tempFile;
    private String slash = File.separator;
    public String fileString = "Test_All_Tests\nTest_java_io_BufferedInputStream\nTest_java_io_BufferedOutputStream\nTest_java_io_ByteArrayInputStream\nTest_java_io_ByteArrayOutputStream\nTest_java_io_DataInputStream\nTest_File\nTest_FileDescriptor\nTest_FileInputStream\nTest_FileNotFoundException\nTest_FileOutputStream\nTest_java_io_FilterInputStream\nTest_java_io_FilterOutputStream\nTest_java_io_InputStream\nTest_java_io_IOException\nTest_java_io_OutputStream\nTest_java_io_PrintStream\nTest_java_io_RandomAccessFile\nTest_java_io_SyncFailedException\nTest_java_lang_AbstractMethodError\nTest_java_lang_ArithmeticException\nTest_java_lang_ArrayIndexOutOfBoundsException\nTest_java_lang_ArrayStoreException\nTest_java_lang_Boolean\nTest_java_lang_Byte\nTest_java_lang_Character\nTest_java_lang_Class\nTest_java_lang_ClassCastException\nTest_java_lang_ClassCircularityError\nTest_java_lang_ClassFormatError\nTest_java_lang_ClassLoader\nTest_java_lang_ClassNotFoundException\nTest_java_lang_CloneNotSupportedException\nTest_java_lang_Double\nTest_java_lang_Error\nTest_java_lang_Exception\nTest_java_lang_ExceptionInInitializerError\nTest_java_lang_Float\nTest_java_lang_IllegalAccessError\nTest_java_lang_IllegalAccessException\nTest_java_lang_IllegalArgumentException\nTest_java_lang_IllegalMonitorStateException\nTest_java_lang_IllegalThreadStateException\nTest_java_lang_IncompatibleClassChangeError\nTest_java_lang_IndexOutOfBoundsException\nTest_java_lang_InstantiationError\nTest_java_lang_InstantiationException\nTest_java_lang_Integer\nTest_java_lang_InternalError\nTest_java_lang_InterruptedException\nTest_java_lang_LinkageError\nTest_java_lang_Long\nTest_java_lang_Math\nTest_java_lang_NegativeArraySizeException\nTest_java_lang_NoClassDefFoundError\nTest_java_lang_NoSuchFieldError\nTest_java_lang_NoSuchMethodError\nTest_java_lang_NullPointerException\nTest_java_lang_Number\nTest_java_lang_NumberFormatException\nTest_java_lang_Object\nTest_java_lang_OutOfMemoryError\nTest_java_lang_RuntimeException\nTest_java_lang_SecurityManager\nTest_java_lang_Short\nTest_java_lang_StackOverflowError\nTest_java_lang_String\nTest_java_lang_StringBuffer\nTest_java_lang_StringIndexOutOfBoundsException\nTest_java_lang_System\nTest_java_lang_Thread\nTest_java_lang_ThreadDeath\nTest_java_lang_ThreadGroup\nTest_java_lang_Throwable\nTest_java_lang_UnknownError\nTest_java_lang_UnsatisfiedLinkError\nTest_java_lang_VerifyError\nTest_java_lang_VirtualMachineError\nTest_java_lang_vm_Image\nTest_java_lang_vm_MemorySegment\nTest_java_lang_vm_ROMStoreException\nTest_java_lang_vm_VM\nTest_java_lang_Void\nTest_java_net_BindException\nTest_java_net_ConnectException\nTest_java_net_DatagramPacket\nTest_java_net_DatagramSocket\nTest_java_net_DatagramSocketImpl\nTest_java_net_InetAddress\nTest_java_net_NoRouteToHostException\nTest_java_net_PlainDatagramSocketImpl\nTest_java_net_PlainSocketImpl\nTest_java_net_Socket\nTest_java_net_SocketException\nTest_java_net_SocketImpl\nTest_java_net_SocketInputStream\nTest_java_net_SocketOutputStream\nTest_java_net_UnknownHostException\nTest_java_util_ArrayEnumerator\nTest_java_util_Date\nTest_java_util_EventObject\nTest_java_util_HashEnumerator\nTest_java_util_Hashtable\nTest_java_util_Properties\nTest_java_util_ResourceBundle\nTest_java_util_tm\nTest_java_util_Vector\n";
    private static String platformId = "JDK" + System.getProperty("java.vm.version").replace('.', '-');

    public FileTest() {
        FileWrapperImpl tempDir = new FileWrapperImpl(System.getProperty("java.io.tmpdir"));
        String[] files = tempDir.list();
        for (int i = 0; i < files.length; ++i) {
            FileWrapperImpl f = new FileWrapperImpl((FileWrapper)tempDir, files[i]);
            if (f.isDirectory() && files[i].startsWith("hyts_resources")) {
                this.deleteTempFolder((FileWrapper)f);
            }
            if (!files[i].startsWith("hyts_") && !files[i].startsWith("hyjar_")) continue;
            new FileWrapperImpl((FileWrapper)tempDir, files[i]).delete();
        }
    }

    private void deleteTempFolder(FileWrapper dir) {
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            FileWrapperImpl f = new FileWrapperImpl(dir, files[i]);
            if (f.isDirectory()) {
                this.deleteTempFolder((FileWrapper)f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    public void test_ConstructorLjava_io_FileLjava_lang_String() {
        String dirName = System.getProperty("user.dir");
        FileWrapperImpl d = new FileWrapperImpl(dirName);
        FileWrapperImpl f = new FileWrapperImpl((FileWrapper)d, "input.tst");
        if (!dirName.regionMatches(dirName.length() - 1, this.slash, 0, 1)) {
            dirName = dirName + this.slash;
        }
        dirName = dirName + "input.tst";
        FileTest.assertEquals((String)"Test 1: Created Incorrect File ", (String)dirName, (String)f.getPath());
        String fileName = null;
        try {
            f = new FileWrapperImpl((FileWrapper)d, fileName);
            FileTest.fail((String)"NullPointerException Not Thrown.");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        d = null;
        f = new FileWrapperImpl((FileWrapper)d, "input.tst");
        FileTest.assertEquals((String)"Test 2: Created Incorrect File", (String)dirName, (String)f.getAbsolutePath());
        FileWrapper s = null;
        f = new FileWrapperImpl("/abc");
        d = new FileWrapperImpl(s, "/abc");
        FileTest.assertEquals((String)"Test3: Created Incorrect File", (String)d.getAbsolutePath(), (String)f.getAbsolutePath());
        FileWrapperImpl path = new FileWrapperImpl("/dir/file");
        FileWrapperImpl root = new FileWrapperImpl("/");
        FileWrapperImpl file = new FileWrapperImpl((FileWrapper)root, "/dir/file");
        FileTest.assertEquals((String)"Assert 1: wrong path result ", (String)path.getPath(), (String)file.getPath());
        if (File.separatorChar == '\\') {
            FileTest.assertTrue((String)"Assert 1.1: path not absolute ", (boolean)new FileWrapperImpl("\\\\\\a\b").isAbsolute());
        } else {
            FileTest.assertFalse((String)"Assert 1.1: path absolute ", (boolean)new FileWrapperImpl("\\\\\\a\b").isAbsolute());
        }
        dirName = System.getProperty("user.dir");
        fileName = "input.tst";
        d = new FileWrapperImpl(dirName);
        f = new FileWrapperImpl((FileWrapper)d, fileName);
        if (!dirName.regionMatches(dirName.length() - 1, File.separator, 0, 1)) {
            dirName = dirName + File.separator;
        }
        dirName = dirName + fileName;
        FileTest.assertEquals((String)"Assert 2: Created incorrect file ", (String)dirName, (String)f.getPath());
        try {
            f = new FileWrapperImpl((FileWrapper)d, null);
            FileTest.fail((String)"Assert 3: NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        f = new FileWrapperImpl((FileWrapper)null, fileName);
        FileTest.assertTrue((String)("Assert 4: Created incorrect file " + f.getPath()), (boolean)f.getAbsolutePath().equals(dirName));
        FileWrapperImpl f1 = new FileWrapperImpl("a");
        FileWrapperImpl f2 = new FileWrapperImpl("a/");
        FileTest.assertEquals((String)"Assert 5: Trailing slash file name is incorrect", (Object)f1, (Object)f2);
    }

    public void test_ConstructorLjava_lang_String() {
        String fileName = null;
        try {
            new FileWrapperImpl(fileName);
            FileTest.fail((String)"NullPointerException Not Thrown.");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        fileName = System.getProperty("user.dir");
        if (!fileName.regionMatches(fileName.length() - 1, this.slash, 0, 1)) {
            fileName = fileName + this.slash;
        }
        fileName = fileName + "input.tst";
        FileWrapperImpl f = new FileWrapperImpl(fileName);
        FileTest.assertEquals((String)"Created incorrect File", (String)fileName, (String)f.getPath());
    }

    public void test_ConstructorLjava_lang_StringLjava_lang_String() {
        String dirName = null;
        String fileName = "input.tst";
        FileWrapperImpl f = new FileWrapperImpl(dirName, fileName);
        String userDir = System.getProperty("user.dir");
        if (!userDir.regionMatches(userDir.length() - 1, this.slash, 0, 1)) {
            userDir = userDir + this.slash;
        }
        userDir = userDir + "input.tst";
        FileTest.assertEquals((String)"Test 1: Created Incorrect File.", (String)userDir, (String)f.getAbsolutePath());
        dirName = System.getProperty("user.dir");
        fileName = null;
        try {
            f = new FileWrapperImpl(dirName, fileName);
            FileTest.fail((String)"NullPointerException Not Thrown.");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        fileName = "input.tst";
        f = new FileWrapperImpl(dirName, fileName);
        FileTest.assertEquals((String)"Test 2: Created Incorrect File", (String)userDir, (String)f.getPath());
        String s = null;
        f = new FileWrapperImpl("/abc");
        FileWrapperImpl d = new FileWrapperImpl(s, "/abc");
        FileTest.assertEquals((String)"Test3: Created Incorrect File", (String)d.getAbsolutePath(), (String)f.getAbsolutePath());
    }

    public void test_Constructor_String_String_112270() {
        FileWrapperImpl ref1 = new FileWrapperImpl("/dir1/file1");
        FileWrapperImpl file1 = new FileWrapperImpl("/", "/dir1/file1");
        FileTest.assertEquals((String)"wrong result 1", (String)ref1.getPath(), (String)file1.getPath());
        FileWrapperImpl file2 = new FileWrapperImpl("/", "//dir1/file1");
        FileTest.assertEquals((String)"wrong result 2", (String)ref1.getPath(), (String)file2.getPath());
        if (File.separatorChar == '\\') {
            FileWrapperImpl file3 = new FileWrapperImpl("\\", "\\dir1\\file1");
            FileTest.assertEquals((String)"wrong result 3", (String)ref1.getPath(), (String)file3.getPath());
            FileWrapperImpl file4 = new FileWrapperImpl("\\", "\\\\dir1\\file1");
            FileTest.assertEquals((String)"wrong result 4", (String)ref1.getPath(), (String)file4.getPath());
        }
        FileWrapperImpl ref2 = new FileWrapperImpl("/lib/content-types.properties");
        FileWrapperImpl file5 = new FileWrapperImpl("/", "lib/content-types.properties");
        FileTest.assertEquals((String)"wrong result 5", (String)ref2.getPath(), (String)file5.getPath());
    }

    public void test_Constructor_File_String_112270() {
        FileWrapperImpl ref1 = new FileWrapperImpl("/dir1/file1");
        FileWrapperImpl root = new FileWrapperImpl("/");
        FileWrapperImpl file1 = new FileWrapperImpl((FileWrapper)root, "/dir1/file1");
        FileTest.assertEquals((String)"wrong result 1", (String)ref1.getPath(), (String)file1.getPath());
        FileWrapperImpl file2 = new FileWrapperImpl((FileWrapper)root, "//dir1/file1");
        FileTest.assertEquals((String)"wrong result 2", (String)ref1.getPath(), (String)file2.getPath());
        if (File.separatorChar == '\\') {
            FileWrapperImpl file3 = new FileWrapperImpl((FileWrapper)root, "\\dir1\\file1");
            FileTest.assertEquals((String)"wrong result 3", (String)ref1.getPath(), (String)file3.getPath());
            FileWrapperImpl file4 = new FileWrapperImpl((FileWrapper)root, "\\\\dir1\\file1");
            FileTest.assertEquals((String)"wrong result 4", (String)ref1.getPath(), (String)file4.getPath());
        }
        FileWrapperImpl ref2 = new FileWrapperImpl("/lib/content-types.properties");
        FileWrapperImpl file5 = new FileWrapperImpl((FileWrapper)root, "lib/content-types.properties");
        FileTest.assertEquals((String)"wrong result 5", (String)ref2.getPath(), (String)file5.getPath());
    }

    public void test_ConstructorLjava_net_URI() throws URISyntaxException {
        URI uri = null;
        try {
            new FileWrapperImpl(uri);
            FileTest.fail((String)"NullPointerException Not Thrown.");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        String[] uris = new String[]{"mailto:user@domain.com", "ftp:///path", "//host/path/", "file://host/path", "file:///path?query", "file:///path#fragment", "file:///path?", "file:///path#"};
        for (int i = 0; i < uris.length; ++i) {
            uri = new URI(uris[i]);
            try {
                new FileWrapperImpl(uri);
                FileTest.fail((String)("Expected IllegalArgumentException for new FileWrapperImpl(" + uri + ")"));
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        FileWrapperImpl f = new FileWrapperImpl(new URI("file:///pa%20th/another\u20ac/pa%25th"));
        FileTest.assertTrue((String)("Created incorrect File " + f.getPath()), (boolean)f.getPath().equals(this.slash + "pa th" + this.slash + "another\u20ac" + this.slash + "pa%th"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_canRead() throws IOException {
        FileWrapperImpl f = new FileWrapperImpl(System.getProperty("java.io.tmpdir"), platformId + "canRead.tst");
        try {
            FileOutputStream fos = new FileOutputStream(f.getAbsolutePath());
            fos.close();
            FileTest.assertTrue((String)"canRead returned false", (boolean)f.canRead());
            f.delete();
        }
        finally {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_canWrite() throws IOException {
        FileWrapperImpl f = new FileWrapperImpl(System.getProperty("java.io.tmpdir"), platformId + "canWrite.tst");
        try {
            FileOutputStream fos = new FileOutputStream(f.getAbsolutePath());
            fos.close();
            FileTest.assertTrue((String)"canWrite returned false", (boolean)f.canWrite());
        }
        finally {
            f.delete();
        }
    }

    public void test_compareToLjava_io_File() {
        FileWrapperImpl f1 = new FileWrapperImpl("thisFile.file");
        FileWrapperImpl f2 = new FileWrapperImpl("thisFile.file");
        FileWrapperImpl f3 = new FileWrapperImpl("thatFile.file");
        FileTest.assertEquals((String)"Equal files did not answer zero for compareTo", (int)0, (int)f1.compareTo(f2));
        FileTest.assertTrue((String)"f3.compareTo(f1) did not result in value < 0", (f3.compareTo(f1) < 0 ? 1 : 0) != 0);
        FileTest.assertTrue((String)"f1.compareTo(f3) did not result in value > 0", (f1.compareTo(f3) > 0 ? 1 : 0) != 0);
    }

    public void test_createNewFile_EmptyString() {
        FileWrapperImpl f = new FileWrapperImpl("");
        try {
            f.createNewFile();
            FileTest.fail((String)"should throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void test_createNewFile() throws IOException {
        FileWrapperImpl f1;
        String base = System.getProperty("java.io.tmpdir");
        boolean dirExists = true;
        int numDir = 1;
        FileWrapperImpl dir = new FileWrapperImpl(base, String.valueOf(numDir));
        while (dirExists) {
            if (dir.exists()) {
                dir = new FileWrapperImpl(base, String.valueOf(++numDir));
                continue;
            }
            dirExists = false;
        }
        try {
            f1 = new FileWrapperImpl((FileWrapper)dir, "tempfile.tst");
            f1.createNewFile();
            FileTest.fail((String)"IOException not thrown");
        }
        catch (IOException e) {
            // empty catch block
        }
        dir.mkdir();
        f1 = new FileWrapperImpl((FileWrapper)dir, "tempfile.tst");
        FileWrapperImpl f2 = new FileWrapperImpl((FileWrapper)dir, "tempfile.tst");
        f1.deleteOnExit();
        f2.deleteOnExit();
        dir.deleteOnExit();
        FileTest.assertFalse((String)"File Should Not Exist", (boolean)f1.isFile());
        f1.createNewFile();
        FileTest.assertTrue((String)"File Should Exist.", (boolean)f1.isFile());
        FileTest.assertTrue((String)"File Should Exist.", (boolean)f2.isFile());
        String dirName = f1.getParent();
        if (!dirName.endsWith(this.slash)) {
            dirName = dirName + this.slash;
        }
        FileTest.assertEquals((String)"File Saved To Wrong Directory.", (String)(dir.getPath() + this.slash), (String)dirName);
        FileTest.assertEquals((String)"File Saved With Incorrect Name.", (String)"tempfile.tst", (String)f1.getName());
        FileTest.assertFalse((String)"File Already Exists, createNewFile Should Return False.", (boolean)f2.createNewFile());
        String sep = File.separator;
        f1 = new FileWrapperImpl(sep + "..");
        try {
            f1.createNewFile();
            FileTest.fail((String)"should throw IOE");
        }
        catch (IOException e) {
            // empty catch block
        }
        f1 = new FileWrapperImpl(sep + "a" + sep + ".." + sep + ".." + sep);
        try {
            f1.createNewFile();
            FileTest.fail((String)"should throw IOE");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_createTempFileLjava_lang_StringLjava_lang_String() throws IOException {
        FileWrapperImpl f1 = null;
        FileWrapperImpl f2 = null;
        try {
            FileWrapperImpl f3;
            String fileName;
            String tempDir;
            f1 = new FileWrapperImpl(File.createTempFile("hyts_abc", ".tmp"));
            f2 = new FileWrapperImpl(File.createTempFile("hyts_tf", null));
            String fileLocation = f1.getParent();
            if (!fileLocation.endsWith(this.slash)) {
                fileLocation = fileLocation + this.slash;
            }
            if (!(tempDir = System.getProperty("java.io.tmpdir")).endsWith(this.slash)) {
                tempDir = tempDir + this.slash;
            }
            FileTest.assertEquals((String)"File did not save to the default temporary-file location.", (String)tempDir, (String)fileLocation);
            for (int i = 0; i < 2; ++i) {
                FileWrapperImpl currentFile = i == 0 ? f1 : f2;
                fileName = currentFile.getPath();
                FileTest.assertTrue((String)"File Created With Incorrect Suffix.", (boolean)fileName.endsWith(".tmp"));
            }
            fileName = f1.getName();
            FileTest.assertTrue((String)"Test 1: File Created With Incorrect Prefix.", (boolean)fileName.startsWith("hyts_abc"));
            fileName = f2.getName();
            FileTest.assertTrue((String)"Test 2: File Created With Incorrect Prefix.", (boolean)fileName.startsWith("hyts_tf"));
            try {
                f3 = new FileWrapperImpl(File.createTempFile("ab", ".tst"));
                f3.delete();
                FileTest.fail((String)"IllegalArgumentException Not Thrown.");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                f3 = new FileWrapperImpl(File.createTempFile("a", ".tst"));
                f3.delete();
                FileTest.fail((String)"IllegalArgumentException Not Thrown.");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                f3 = new FileWrapperImpl(File.createTempFile("", ".tst"));
                f3.delete();
                FileTest.fail((String)"IllegalArgumentException Not Thrown.");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        finally {
            if (f1 != null) {
                f1.delete();
            }
            if (f2 != null) {
                f2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_createTempFileLjava_lang_StringLjava_lang_StringLjava_io_File() throws IOException {
        FileWrapperImpl f1 = null;
        FileWrapperImpl f2 = null;
        String base = System.getProperty("java.io.tmpdir");
        try {
            FileWrapperImpl f4;
            f1 = new FileWrapperImpl(File.createTempFile("hyts_tf", null, null));
            FileWrapperImpl dir = new FileWrapperImpl(base);
            f2 = FileWrapperImpl.createTempFile((String)"hyts_tf", (String)".tmp", (FileWrapperImpl)dir);
            for (int i = 0; i < 2; ++i) {
                FileWrapperImpl currentFile = i == 0 ? f1 : f2;
                String fileLocation = currentFile.getParent();
                if (!fileLocation.endsWith(this.slash)) {
                    fileLocation = fileLocation + this.slash;
                }
                if (!base.endsWith(this.slash)) {
                    base = base + this.slash;
                }
                FileTest.assertEquals((String)"File not created in the default temporary-file location.", (String)base, (String)fileLocation);
                String fileName = currentFile.getName();
                FileTest.assertTrue((String)"File created with incorrect suffix.", (boolean)fileName.endsWith(".tmp"));
                FileTest.assertTrue((String)"File created with incorrect prefix.", (boolean)fileName.startsWith("hyts_tf"));
                currentFile.delete();
            }
            int dirNumber = 1;
            boolean dirExists = true;
            dir = new FileWrapperImpl(base, String.valueOf(dirNumber));
            while (dirExists) {
                if (dir.exists()) {
                    dir = new FileWrapperImpl(base, String.valueOf(++dirNumber));
                    continue;
                }
                dirExists = false;
            }
            try {
                FileWrapperImpl f3 = FileWrapperImpl.createTempFile((String)"hyts_tf", null, (FileWrapperImpl)dir);
                f3.delete();
                FileTest.fail((String)"IOException not thrown");
            }
            catch (IOException e) {
                // empty catch block
            }
            dir.delete();
            try {
                f4 = new FileWrapperImpl(File.createTempFile("ab", null, null));
                f4.delete();
                FileTest.fail((String)"IllegalArgumentException not thrown.");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                f4 = FileWrapperImpl.createTempFile((String)"a", null, null);
                f4.delete();
                FileTest.fail((String)"IllegalArgumentException not thrown.");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                f4 = FileWrapperImpl.createTempFile((String)"", null, null);
                f4.delete();
                FileTest.fail((String)"IllegalArgumentException not thrown.");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        finally {
            if (f1 != null) {
                f1.delete();
            }
            if (f2 != null) {
                f1.delete();
            }
        }
    }

    public void test_delete() throws IOException {
        FileWrapperImpl dir = new FileWrapperImpl(System.getProperty("user.dir"), platformId + "filechk");
        dir.mkdir();
        FileTest.assertTrue((String)"Directory does not exist", (boolean)dir.exists());
        FileTest.assertTrue((String)"Directory is not directory", (boolean)dir.isDirectory());
        FileWrapperImpl f = new FileWrapperImpl((FileWrapper)dir, "filechk.tst");
        FileOutputStream fos = new FileOutputStream(f.getAbsolutePath());
        fos.close();
        FileTest.assertTrue((String)"Error Creating File For Delete Test", (boolean)f.exists());
        dir.delete();
        FileTest.assertTrue((String)"Directory Should Not Have Been Deleted.", (boolean)dir.exists());
        f.delete();
        FileTest.assertTrue((String)"File Was Not Deleted", (!f.exists() ? 1 : 0) != 0);
        dir.delete();
        FileTest.assertTrue((String)"Directory Was Not Deleted", (!dir.exists() ? 1 : 0) != 0);
    }

    public void test_equalsLjava_lang_Object() throws IOException {
        boolean onUnix;
        FileWrapperImpl f1 = new FileWrapperImpl("filechk.tst");
        FileWrapperImpl f2 = new FileWrapperImpl("filechk.tst");
        FileWrapperImpl f3 = new FileWrapperImpl("xxxx");
        FileTest.assertTrue((String)"Equality test failed", (boolean)f1.equals(f2));
        FileTest.assertTrue((String)"Files Should Not Return Equal.", (!f1.equals(f3) ? 1 : 0) != 0);
        f3 = new FileWrapperImpl("FiLeChK.tst");
        boolean onWindows = File.separatorChar == '\\';
        boolean bl = onUnix = File.separatorChar == '/';
        if (onWindows) {
            FileTest.assertTrue((String)"Files Should Return Equal.", (boolean)f1.equals(f3));
        } else if (onUnix) {
            FileTest.assertTrue((String)"Files Should NOT Return Equal.", (!f1.equals(f3) ? 1 : 0) != 0);
        }
        f1 = new FileWrapperImpl(System.getProperty("java.io.tmpdir"), "casetest.tmp");
        f2 = new FileWrapperImpl(System.getProperty("java.io.tmpdir"), "CaseTest.tmp");
        new FileOutputStream(f1.getAbsolutePath()).close();
        if (f1.equals(f2)) {
            try {
                FileInputStream fis = new FileInputStream(f2.getAbsolutePath());
                fis.close();
            }
            catch (IOException e) {
                FileTest.fail((String)"File system is case sensitive");
            }
        } else {
            boolean exception = false;
            try {
                FileInputStream fis = new FileInputStream(f2.getAbsolutePath());
                fis.close();
            }
            catch (IOException e) {
                exception = true;
            }
            FileTest.assertTrue((String)"File system is case insensitive", (boolean)exception);
        }
        f1.delete();
    }

    public void test_exists() throws IOException {
        FileWrapperImpl f = new FileWrapperImpl(System.getProperty("user.dir"), platformId + "exists.tst");
        FileTest.assertTrue((String)"Exists returned true for non-existent file", (!f.exists() ? 1 : 0) != 0);
        FileOutputStream fos = new FileOutputStream(f.getAbsolutePath());
        fos.close();
        FileTest.assertTrue((String)"Exists returned false file", (boolean)f.exists());
        f.delete();
    }

    public void test_getAbsoluteFile() {
        String base = System.getProperty("user.dir");
        if (!base.endsWith(this.slash)) {
            base = base + this.slash;
        }
        FileWrapperImpl f = new FileWrapperImpl(base, "temp.tst");
        FileWrapperImpl f2 = (FileWrapperImpl)f.getAbsoluteFile();
        FileTest.assertEquals((String)"Test 1: Incorrect File Returned.", (int)0, (int)f2.compareTo((FileWrapperImpl)f.getAbsoluteFile()));
        f = new FileWrapperImpl(base + "Temp" + this.slash + this.slash + "temp.tst");
        f2 = (FileWrapperImpl)f.getAbsoluteFile();
        FileTest.assertEquals((String)"Test 2: Incorrect File Returned.", (int)0, (int)f2.compareTo((FileWrapperImpl)f.getAbsoluteFile()));
        f = new FileWrapperImpl(base + this.slash + ".." + this.slash + "temp.tst");
        f2 = (FileWrapperImpl)f.getAbsoluteFile();
        FileTest.assertEquals((String)"Test 3: Incorrect File Returned.", (int)0, (int)f2.compareTo((FileWrapperImpl)f.getAbsoluteFile()));
        f.delete();
        f2.delete();
    }

    public void test_getAbsolutePath() {
        String base = System.getProperty("user.dir");
        if (!base.regionMatches(base.length() - 1, this.slash, 0, 1)) {
            base = base + this.slash;
        }
        FileWrapperImpl f = new FileWrapperImpl(base, "temp.tst");
        FileTest.assertEquals((String)"Test 1: Incorrect Path Returned.", (String)(base + "temp.tst"), (String)f.getAbsolutePath());
        f = new FileWrapperImpl(base + "Temp" + this.slash + this.slash + this.slash + "Testing" + this.slash + "temp.tst");
        FileTest.assertEquals((String)"Test 2: Incorrect Path Returned.", (String)(base + "Temp" + this.slash + "Testing" + this.slash + "temp.tst"), (String)f.getAbsolutePath());
        f = new FileWrapperImpl(base + "a" + this.slash + this.slash + ".." + this.slash + "temp.tst");
        FileTest.assertEquals((String)"Test 3: Incorrect Path Returned.", (String)(base + "a" + this.slash + ".." + this.slash + "temp.tst"), (String)f.getAbsolutePath());
        f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_getCanonicalFile() throws IOException {
        boolean onWindows;
        String base = System.getProperty("user.dir");
        if (!base.endsWith(this.slash)) {
            base = base + this.slash;
        }
        FileWrapperImpl f = new FileWrapperImpl(base, "temp.tst");
        FileWrapperImpl f2 = (FileWrapperImpl)f.getCanonicalFile();
        FileTest.assertEquals((String)"Test 1: Incorrect File Returned.", (int)0, (int)((FileWrapperImpl)f2.getCanonicalFile()).compareTo((FileWrapperImpl)f.getCanonicalFile()));
        f = new FileWrapperImpl(base + "Temp" + this.slash + this.slash + "temp.tst");
        f2 = (FileWrapperImpl)f.getCanonicalFile();
        FileTest.assertEquals((String)"Test 2: Incorrect File Returned.", (int)0, (int)((FileWrapperImpl)f2.getCanonicalFile()).compareTo((FileWrapperImpl)f.getCanonicalFile()));
        f = new FileWrapperImpl(base + "Temp" + this.slash + this.slash + ".." + this.slash + "temp.tst");
        f2 = (FileWrapperImpl)f.getCanonicalFile();
        FileTest.assertEquals((String)"Test 3: Incorrect File Returned.", (int)0, (int)((FileWrapperImpl)f2.getCanonicalFile()).compareTo((FileWrapperImpl)f.getCanonicalFile()));
        boolean bl = onWindows = File.separatorChar == '\\';
        if (onWindows) {
            FileWrapperImpl testdir = new FileWrapperImpl(base, "long-" + platformId);
            testdir.mkdir();
            FileWrapperImpl dir = new FileWrapperImpl((FileWrapper)testdir, "longdirectory" + platformId);
            try {
                dir.mkdir();
                f = new FileWrapperImpl((FileWrapper)dir, "longfilename.tst");
                f2 = (FileWrapperImpl)f.getCanonicalFile();
                FileTest.assertEquals((String)"Test 4: Incorrect File Returned.", (int)0, (int)((FileWrapperImpl)f2.getCanonicalFile()).compareTo((FileWrapperImpl)f.getCanonicalFile()));
                FileOutputStream fos = new FileOutputStream(f.getAbsolutePath());
                fos.close();
                f2 = new FileWrapperImpl(testdir + this.slash + "longdi~1" + this.slash + "longfi~1.tst");
                FileWrapperImpl canonicalf2 = (FileWrapperImpl)f2.getCanonicalFile();
                if (canonicalf2.exists()) {
                    FileTest.assertTrue((String)("Test 5: Incorrect File Returned: " + canonicalf2), (canonicalf2.compareTo((FileWrapperImpl)f.getCanonicalFile()) == 0 ? 1 : 0) != 0);
                }
            }
            finally {
                f.delete();
                f2.delete();
                dir.delete();
                testdir.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_getCanonicalPath() throws IOException {
        boolean onWindows;
        String dots = "..";
        String base = new FileWrapperImpl(System.getProperty("user.dir")).getCanonicalPath();
        if (!base.regionMatches(base.length() - 1, this.slash, 0, 1)) {
            base = base + this.slash;
        }
        FileWrapperImpl f = new FileWrapperImpl(base, "temp.tst");
        FileTest.assertEquals((String)"Test 1: Incorrect Path Returned.", (String)(base + "temp.tst"), (String)f.getCanonicalPath());
        f = new FileWrapperImpl(base + "Temp" + this.slash + dots + this.slash + "temp.tst");
        FileTest.assertEquals((String)"Test 2: Incorrect Path Returned.", (String)(base + "temp.tst"), (String)f.getCanonicalPath());
        int dirNumber = 1;
        boolean dirExists = true;
        FileWrapperImpl dir1 = new FileWrapperImpl(base, String.valueOf(dirNumber));
        while (dirExists) {
            if (dir1.exists()) {
                dir1 = new FileWrapperImpl(base, String.valueOf(++dirNumber));
                continue;
            }
            dirExists = false;
        }
        f = new FileWrapperImpl(base + dirNumber + this.slash + dots + this.slash + dirNumber + this.slash + "temp.tst");
        FileTest.assertEquals((String)"Test 3: Incorrect Path Returned.", (String)(base + dirNumber + this.slash + "temp.tst"), (String)f.getCanonicalPath());
        f = new FileWrapperImpl(base + dirNumber + this.slash + "Temp" + this.slash + dots + this.slash + "Test" + this.slash + "temp.tst");
        FileTest.assertEquals((String)"Test 4: Incorrect Path Returned.", (String)(base + dirNumber + this.slash + "Test" + this.slash + "temp.tst"), (String)f.getCanonicalPath());
        f = new FileWrapperImpl("1234.567");
        FileTest.assertEquals((String)"Test 5: Incorrect Path Returned.", (String)(base + "1234.567"), (String)f.getCanonicalPath());
        boolean bl = onWindows = File.separatorChar == '\\';
        if (onWindows) {
            FileWrapperImpl testdir = new FileWrapperImpl(base, "long-" + platformId);
            testdir.mkdir();
            FileWrapperImpl f1 = new FileWrapperImpl((FileWrapper)testdir, "longfilename" + platformId + ".tst");
            FileOutputStream fos = new FileOutputStream(f1.getAbsolutePath());
            FileWrapperImpl f2 = null;
            FileWrapperImpl f3 = null;
            FileWrapperImpl dir2 = null;
            try {
                fos.close();
                String dirName1 = f1.getCanonicalPath();
                FileWrapperImpl f4 = new FileWrapperImpl((FileWrapper)testdir, "longfi~1.tst");
                if (f4.exists()) {
                    String dirName2 = f4.getCanonicalPath();
                    FileTest.assertEquals((String)"Test 6: Incorrect Path Returned.", (String)dirName1, (String)dirName2);
                    dir2 = new FileWrapperImpl((FileWrapper)testdir, "longdirectory" + platformId);
                    if (!dir2.exists()) {
                        FileTest.assertTrue((String)("Could not create dir: " + dir2), (boolean)dir2.mkdir());
                    }
                    f2 = new FileWrapperImpl(testdir.getPath() + this.slash + "longdirectory" + platformId + this.slash + "Test" + this.slash + dots + this.slash + "longfilename.tst");
                    FileOutputStream fos2 = new FileOutputStream(f2.getAbsolutePath());
                    fos2.close();
                    dirName1 = f2.getCanonicalPath();
                    f3 = new FileWrapperImpl(testdir.getPath() + this.slash + "longdi~1" + this.slash + "Test" + this.slash + dots + this.slash + "longfi~1.tst");
                    dirName2 = f3.getCanonicalPath();
                    FileTest.assertEquals((String)"Test 7: Incorrect Path Returned.", (String)dirName1, (String)dirName2);
                }
            }
            finally {
                f1.delete();
                if (f2 != null) {
                    f2.delete();
                }
                if (dir2 != null) {
                    dir2.delete();
                }
                testdir.delete();
            }
        }
    }

    public void test_getName() {
        FileWrapperImpl f = new FileWrapperImpl("name.tst");
        FileTest.assertEquals((String)"Test 1: Returned incorrect name", (String)"name.tst", (String)f.getName());
        f = new FileWrapperImpl("");
        FileTest.assertEquals((String)"Test 2: Returned incorrect name", (String)"", (String)f.getName());
        f.delete();
    }

    public void test_getParent() {
        FileWrapperImpl f = new FileWrapperImpl("p.tst");
        FileTest.assertNull((String)"Incorrect path returned", (Object)f.getParent());
        f = new FileWrapperImpl(System.getProperty("user.home"), "p.tst");
        FileTest.assertEquals((String)"Incorrect path returned", (String)System.getProperty("user.home"), (String)f.getParent());
        f.delete();
        FileWrapperImpl f1 = new FileWrapperImpl("/directory");
        FileTest.assertEquals((String)"Wrong parent test 1", (String)this.slash, (String)f1.getParent());
        f1 = new FileWrapperImpl("/directory/file");
        FileTest.assertEquals((String)"Wrong parent test 2", (String)(this.slash + "directory"), (String)f1.getParent());
        f1 = new FileWrapperImpl("directory/file");
        FileTest.assertEquals((String)"Wrong parent test 3", (String)"directory", (String)f1.getParent());
        f1 = new FileWrapperImpl("/");
        FileTest.assertNull((String)"Wrong parent test 4", (Object)f1.getParent());
        f1 = new FileWrapperImpl("directory");
        FileTest.assertNull((String)"Wrong parent test 5", (Object)f1.getParent());
        if (File.separatorChar == '\\' && new FileWrapperImpl("d:/").isAbsolute()) {
            f1 = new FileWrapperImpl("d:/directory");
            FileTest.assertEquals((String)"Wrong parent test 1a", (String)("d:" + this.slash), (String)f1.getParent());
            f1 = new FileWrapperImpl("d:/directory/file");
            FileTest.assertEquals((String)"Wrong parent test 2a", (String)("d:" + this.slash + "directory"), (String)f1.getParent());
            f1 = new FileWrapperImpl("d:directory/file");
            FileTest.assertEquals((String)"Wrong parent test 3a", (String)"d:directory", (String)f1.getParent());
            f1 = new FileWrapperImpl("d:/");
            FileTest.assertNull((String)"Wrong parent test 4a", (Object)f1.getParent());
            f1 = new FileWrapperImpl("d:directory");
            FileTest.assertEquals((String)"Wrong parent test 5a", (String)"d:", (String)f1.getParent());
        }
    }

    public void test_getParentFile() {
        FileWrapperImpl f = new FileWrapperImpl("tempfile.tst");
        FileTest.assertNull((String)"Incorrect path returned", (Object)f.getParentFile());
        f = new FileWrapperImpl(System.getProperty("user.dir"), "tempfile1.tmp");
        FileWrapperImpl f2 = new FileWrapperImpl(System.getProperty("user.dir"), "tempfile2.tmp");
        FileWrapperImpl f3 = new FileWrapperImpl(System.getProperty("user.dir"), "/a/tempfile.tmp");
        FileTest.assertEquals((String)"Incorrect File Returned", (int)0, (int)((FileWrapperImpl)f.getParentFile()).compareTo((FileWrapperImpl)f2.getParentFile()));
        FileTest.assertTrue((String)"Incorrect File Returned", (((FileWrapperImpl)f.getParentFile()).compareTo((FileWrapperImpl)f3.getParentFile()) != 0 ? 1 : 0) != 0);
        f.delete();
        f2.delete();
        f3.delete();
    }

    public void test_getPath() {
        String base = System.getProperty("user.home");
        if (!base.regionMatches(base.length() - 1, this.slash, 0, 1)) {
            base = base + this.slash;
        }
        String fname = base + "filechk.tst";
        FileWrapperImpl f1 = new FileWrapperImpl(base, "filechk.tst");
        FileWrapperImpl f2 = new FileWrapperImpl("filechk.tst");
        FileWrapperImpl f3 = new FileWrapperImpl("c:");
        FileWrapperImpl f4 = new FileWrapperImpl(base + "a" + this.slash + this.slash + ".." + this.slash + "filechk.tst");
        FileTest.assertEquals((String)"getPath returned incorrect path(f1)", (String)fname, (String)f1.getPath());
        FileTest.assertEquals((String)"getPath returned incorrect path(f2)", (String)"filechk.tst", (String)f2.getPath());
        FileTest.assertEquals((String)"getPath returned incorrect path(f3)", (String)"c:", (String)f3.getPath());
        FileTest.assertEquals((String)"getPath returned incorrect path(f4)", (String)(base + "a" + this.slash + ".." + this.slash + "filechk.tst"), (String)f4.getPath());
        f1.delete();
        f2.delete();
        f3.delete();
        f4.delete();
        String separator = File.separator;
        FileWrapperImpl file = new FileWrapperImpl((FileWrapper)null, "x/y/z");
        FileTest.assertEquals((String)("x" + separator + "y" + separator + "z"), (String)file.getPath());
        file = new FileWrapperImpl((String)null, "x/y/z");
        FileTest.assertEquals((String)("x" + separator + "y" + separator + "z"), (String)file.getPath());
        String f1ParentName = "01";
        f1 = new FileWrapperImpl(f1ParentName, "");
        FileTest.assertEquals((String)f1ParentName, (String)f1.getPath());
        String f2ParentName = "0";
        f2 = new FileWrapperImpl(f2ParentName, "");
        FileTest.assertEquals((int)-1, (int)f2.compareTo(f1));
        FileTest.assertEquals((int)1, (int)f1.compareTo(f2));
        FileWrapperImpl parent = new FileWrapperImpl(System.getProperty("user.dir"));
        f3 = new FileWrapperImpl((FileWrapper)parent, "");
        FileTest.assertEquals((String)parent.getPath(), (String)f3.getPath());
        FileWrapperImpl file1 = new FileWrapperImpl("", "");
        FileTest.assertEquals((String)File.separator, (String)file1.getPath());
        FileWrapperImpl file2 = new FileWrapperImpl((FileWrapper)new FileWrapperImpl(""), "");
        FileTest.assertEquals((String)File.separator, (String)file2.getPath());
    }

    public void test_hashCode() {
        String mixedFname = "SoMe FiLeNaMe";
        FileWrapperImpl mfile = new FileWrapperImpl(mixedFname);
        FileWrapperImpl lfile = new FileWrapperImpl(mixedFname.toLowerCase());
        if (mfile.equals(lfile)) {
            FileTest.assertTrue((String)"Assert 0: wrong hashcode", (mfile.hashCode() == lfile.hashCode() ? 1 : 0) != 0);
        } else {
            FileTest.assertFalse((String)"Assert 1: wrong hashcode", (mfile.hashCode() == lfile.hashCode() ? 1 : 0) != 0);
        }
    }

    public void test_isAbsolute() {
        if (File.separatorChar == '\\') {
            FileWrapperImpl f = new FileWrapperImpl("c:\\test");
            FileWrapperImpl f1 = new FileWrapperImpl("\\test");
            FileTest.assertTrue((String)"Absolute returned false", (f.isAbsolute() && !f1.isAbsolute() || !f.isAbsolute() && f1.isAbsolute() ? 1 : 0) != 0);
        } else {
            FileWrapperImpl f = new FileWrapperImpl("/test");
            FileWrapperImpl f1 = new FileWrapperImpl("\\test");
            FileTest.assertTrue((String)"Absolute returned false", (boolean)f.isAbsolute());
            FileTest.assertFalse((String)"Absolute returned true", (boolean)f1.isAbsolute());
        }
        FileTest.assertTrue((String)"Non-Absolute returned true", (!new FileWrapperImpl("../test").isAbsolute() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_isDirectory() {
        String base = System.getProperty("user.dir");
        if (!base.regionMatches(base.length() - 1, this.slash, 0, 1)) {
            base = base + this.slash;
        }
        FileWrapperImpl f = new FileWrapperImpl(base);
        FileTest.assertTrue((String)"Test 1: Directory Returned False", (boolean)f.isDirectory());
        f = new FileWrapperImpl(base + "zxzxzxz" + platformId);
        FileTest.assertTrue((String)"Test 2: (Not Created) Directory Returned True.", (!f.isDirectory() ? 1 : 0) != 0);
        f.mkdir();
        try {
            FileTest.assertTrue((String)"Test 3: Directory Returned False.", (boolean)f.isDirectory());
        }
        finally {
            f.delete();
        }
    }

    public void test_isFile() throws IOException {
        String base = System.getProperty("user.dir");
        FileWrapperImpl f = new FileWrapperImpl(base);
        FileTest.assertTrue((String)"Directory Returned True As Being A File.", (!f.isFile() ? 1 : 0) != 0);
        if (!base.regionMatches(base.length() - 1, this.slash, 0, 1)) {
            base = base + this.slash;
        }
        FileTest.assertTrue((String)"Non-existent File Returned True", (!(f = new FileWrapperImpl(base, platformId + "amiafile")).isFile() ? 1 : 0) != 0);
        FileOutputStream fos = new FileOutputStream(f.getAbsolutePath());
        fos.close();
        FileTest.assertTrue((String)"File returned false", (boolean)f.isFile());
        f.delete();
    }

    public void test_isHidden() throws IOException, InterruptedException {
        boolean onUnix = File.separatorChar == '/';
        FileWrapper f = FileWrapperImpl.createTempFile((String)"hyts_", (String)".tmp");
        if (onUnix) {
            FileWrapperImpl f2 = new FileWrapperImpl(".test.tst" + platformId);
            FileOutputStream fos2 = new FileOutputStream(f2.getAbsolutePath());
            fos2.close();
            FileTest.assertTrue((String)"File returned hidden on Unix", (!f.isHidden() ? 1 : 0) != 0);
            FileTest.assertTrue((String)"File returned visible on Unix", (boolean)f2.isHidden());
            FileTest.assertTrue((String)"File did not delete.", (boolean)f2.delete());
        } else {
            Runtime r = Runtime.getRuntime();
            FileTest.assertTrue((String)"File returned hidden", (!f.isHidden() ? 1 : 0) != 0);
            Process p = r.exec("attrib +h \"" + f.getAbsolutePath() + "\"");
            p.waitFor();
            FileTest.assertTrue((String)"File returned visible", (boolean)f.isHidden());
            p = r.exec("attrib -h \"" + f.getAbsolutePath() + "\"");
            p.waitFor();
            FileTest.assertTrue((String)"File returned hidden", (!f.isHidden() ? 1 : 0) != 0);
        }
        f.delete();
    }

    public void test_lastModified() throws IOException {
        FileWrapperImpl f = new FileWrapperImpl(System.getProperty("java.io.tmpdir"), platformId + "lModTest.tst");
        f.delete();
        long lastModifiedTime = f.lastModified();
        FileTest.assertEquals((String)"LastModified Time Should Have Returned 0.", (long)0L, (long)lastModifiedTime);
        FileOutputStream fos = new FileOutputStream(f.getAbsolutePath());
        fos.close();
        f.setLastModified(315550800000L);
        lastModifiedTime = f.lastModified();
        FileTest.assertEquals((String)"LastModified Time Incorrect", (long)315550800000L, (long)lastModifiedTime);
        f.delete();
        f = new FileWrapperImpl("/../");
        FileTest.assertTrue((f.lastModified() > 0L ? 1 : 0) != 0);
    }

    public void test_length() throws IOException {
        FileWrapperImpl f = new FileWrapperImpl(System.getProperty("user.dir"), platformId + "input.tst");
        FileTest.assertEquals((String)"File Length Should Have Returned 0.", (long)0L, (long)f.length());
        FileOutputStream fos = new FileOutputStream(f.getAbsolutePath());
        fos.write(this.fileString.getBytes());
        fos.close();
        FileTest.assertEquals((String)"Incorrect file length returned", (long)this.fileString.length(), (long)f.length());
        f.delete();
        f = FileWrapperImpl.createTempFile((String)"test", (String)"tmp");
        f.deleteOnExit();
        RandomAccessFile raf = new RandomAccessFile(new File(f.getAbsolutePath()), "rwd");
        raf.write(65);
        FileTest.assertEquals((long)1L, (long)f.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_list() throws IOException {
        String base = System.getProperty("user.dir");
        int dirNumber = 1;
        boolean dirExists = true;
        FileWrapperImpl dir = null;
        dir = new FileWrapperImpl(base, platformId + String.valueOf(dirNumber));
        while (dirExists) {
            if (dir.exists()) {
                dir = new FileWrapperImpl(base, String.valueOf(++dirNumber));
                continue;
            }
            dirExists = false;
        }
        String[] flist = dir.list();
        FileTest.assertNull((String)"Method list() Should Have Returned null.", (Object)flist);
        FileTest.assertTrue((String)"Could not create parent directory for list test", (boolean)dir.mkdir());
        String[] files = new String[]{"mtzz1.xx", "mtzz2.xx", "mtzz3.yy", "mtzz4.yy"};
        try {
            int i;
            int i2;
            FileTest.assertEquals((String)"Method list() Should Have Returned An Array Of Length 0.", (int)0, (int)dir.list().length);
            FileWrapperImpl file = new FileWrapperImpl((FileWrapper)dir, "notADir.tst");
            try {
                FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());
                fos.close();
                FileTest.assertNull((String)"listFiles Should Have Returned Null When Used On A File Instead Of A Directory.", (Object)file.list());
            }
            finally {
                file.delete();
            }
            for (int i3 = 0; i3 < files.length; ++i3) {
                FileWrapperImpl f = new FileWrapperImpl((FileWrapper)dir, files[i3]);
                FileOutputStream fos = new FileOutputStream(f.getAbsolutePath());
                fos.close();
            }
            flist = dir.list();
            if (flist.length != files.length) {
                FileTest.fail((String)"Incorrect list returned");
            }
            boolean[] check = new boolean[flist.length];
            for (i2 = 0; i2 < check.length; ++i2) {
                check[i2] = false;
            }
            block9: for (i2 = 0; i2 < files.length; ++i2) {
                for (int j = 0; j < flist.length; ++j) {
                    if (!flist[j].equals(files[i2])) continue;
                    check[i2] = true;
                    continue block9;
                }
            }
            int checkCount = 0;
            for (i = 0; i < check.length; ++i) {
                if (check[i]) continue;
                ++checkCount;
            }
            FileTest.assertEquals((String)"Invalid file returned in listing", (int)0, (int)checkCount);
            for (i = 0; i < files.length; ++i) {
                FileWrapperImpl f = new FileWrapperImpl((FileWrapper)dir, files[i]);
                f.delete();
            }
            FileTest.assertTrue((String)"Could not delete parent directory for list test.", (boolean)dir.delete());
        }
        finally {
            for (int i = 0; i < files.length; ++i) {
                FileWrapperImpl f = new FileWrapperImpl((FileWrapper)dir, files[i]);
                f.delete();
            }
            dir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_listFiles() throws IOException, InterruptedException {
        String base = System.getProperty("user.dir");
        int dirNumber = 1;
        boolean dirExists = true;
        FileWrapperImpl dir = new FileWrapperImpl(base, platformId + String.valueOf(dirNumber));
        while (dirExists) {
            if (dir.exists()) {
                dir = new FileWrapperImpl(base, String.valueOf(++dirNumber));
                continue;
            }
            dirExists = false;
        }
        FileTest.assertNull((String)"listFiles Should Return Null.", (Object)dir.listFiles());
        FileTest.assertTrue((String)"Failed To Create Parent Directory.", (boolean)dir.mkdir());
        String[] files = new String[]{"1.tst", "2.tst", "3.tst", ""};
        try {
            int i;
            Process p;
            FileOutputStream fos;
            FileWrapperImpl f;
            boolean onWindows;
            FileTest.assertEquals((String)"listFiles Should Return An Array Of Length 0.", (int)0, (int)dir.listFiles().length);
            FileWrapperImpl file = new FileWrapperImpl((FileWrapper)dir, "notADir.tst");
            try {
                FileOutputStream fos2 = new FileOutputStream(file.getAbsolutePath());
                fos2.close();
                FileTest.assertNull((String)"listFiles Should Have Returned Null When Used On A File Instead Of A Directory.", (Object)file.listFiles());
            }
            finally {
                file.delete();
            }
            for (int i2 = 0; i2 < files.length - 1; ++i2) {
                FileWrapperImpl f2 = new FileWrapperImpl((FileWrapper)dir, files[i2]);
                FileOutputStream fos3 = new FileOutputStream(f2.getAbsolutePath());
                fos3.close();
            }
            new FileWrapperImpl((FileWrapper)dir, "doesNotExist.tst");
            FileWrapper[] flist = dir.listFiles();
            FileTest.assertEquals((String)"Incorrect Number Of Files Returned.", (int)3, (int)flist.length);
            boolean onUnix = File.separatorChar == '/';
            boolean bl = onWindows = File.separatorChar == '\\';
            if (onWindows) {
                files[3] = "4.tst";
                f = new FileWrapperImpl((FileWrapper)dir, "4.tst");
                fos = new FileOutputStream(f.getAbsolutePath());
                fos.close();
                Runtime r = Runtime.getRuntime();
                p = r.exec("attrib +h \"" + f.getPath() + "\"");
                p.waitFor();
            }
            if (onUnix) {
                files[3] = ".4.tst";
                f = new FileWrapperImpl((FileWrapper)dir, ".4.tst");
                fos = new FileOutputStream(f.getAbsolutePath());
                fos.close();
            }
            flist = dir.listFiles();
            FileTest.assertEquals((String)"Incorrect Number Of Files Returned.", (int)4, (int)flist.length);
            boolean[] check = new boolean[flist.length];
            for (i = 0; i < check.length; ++i) {
                check[i] = false;
            }
            block9: for (i = 0; i < files.length; ++i) {
                for (int j = 0; j < flist.length; ++j) {
                    if (!flist[j].getName().equals(files[i])) continue;
                    check[i] = true;
                    continue block9;
                }
            }
            int checkCount = 0;
            for (int i3 = 0; i3 < check.length; ++i3) {
                if (check[i3]) continue;
                ++checkCount;
            }
            FileTest.assertEquals((String)"Invalid file returned in listing", (int)0, (int)checkCount);
            if (onWindows) {
                Runtime r = Runtime.getRuntime();
                p = r.exec("attrib -h \"" + new FileWrapperImpl((FileWrapper)dir, files[3]).getPath() + "\"");
                p.waitFor();
            }
            for (int i4 = 0; i4 < files.length; ++i4) {
                FileWrapperImpl f3 = new FileWrapperImpl((FileWrapper)dir, files[i4]);
                f3.delete();
            }
            FileTest.assertTrue((String)"Parent Directory Not Deleted.", (boolean)dir.delete());
        }
        finally {
            for (int i = 0; i < files.length; ++i) {
                FileWrapperImpl f = new FileWrapperImpl((FileWrapper)dir, files[i]);
                f.delete();
            }
            dir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_listFilesLjava_io_FileFilter() throws IOException {
        String base = System.getProperty("java.io.tmpdir");
        int dirNumber = 1;
        boolean dirExists = true;
        FileWrapperImpl baseDir = new FileWrapperImpl(base, platformId + String.valueOf(dirNumber));
        while (dirExists) {
            if (baseDir.exists()) {
                baseDir = new FileWrapperImpl(base, String.valueOf(++dirNumber));
                continue;
            }
            dirExists = false;
        }
        FileFilter dirFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        };
        FileTest.assertNull((String)"listFiles Should Return Null.", (Object)baseDir.listFiles(dirFilter));
        FileTest.assertTrue((String)"Failed To Create Parent Directory.", (boolean)baseDir.mkdir());
        FileWrapperImpl dir1 = null;
        String[] files = new String[]{"1.tst", "2.tst", "3.tst"};
        try {
            int i;
            int i2;
            FileTest.assertEquals((String)"listFiles Should Return An Array Of Length 0.", (int)0, (int)baseDir.listFiles(dirFilter).length);
            FileWrapperImpl file = new FileWrapperImpl((FileWrapper)baseDir, "notADir.tst");
            try {
                FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());
                fos.close();
                FileTest.assertNull((String)"listFiles Should Have Returned Null When Used On A File Instead Of A Directory.", (Object)file.listFiles(dirFilter));
            }
            finally {
                file.delete();
            }
            for (int i3 = 0; i3 < files.length; ++i3) {
                FileWrapperImpl f = new FileWrapperImpl((FileWrapper)baseDir, files[i3]);
                FileOutputStream fos = new FileOutputStream(f.getAbsolutePath());
                fos.close();
            }
            dir1 = new FileWrapperImpl((FileWrapper)baseDir, "Temp1");
            dir1.mkdir();
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isFile();
                }
            };
            FileWrapper[] directories = baseDir.listFiles(dirFilter);
            FileTest.assertEquals((String)"Incorrect Number Of Directories Returned.", (int)1, (int)directories.length);
            FileTest.assertEquals((String)"Incorrect Directory Returned.", (int)0, (int)((FileWrapperImpl)directories[0]).compareTo(dir1));
            FileWrapper[] flist = baseDir.listFiles(fileFilter);
            FileTest.assertEquals((String)"Incorrect Number Of Files Returned.", (int)files.length, (int)flist.length);
            boolean[] check = new boolean[flist.length];
            for (i2 = 0; i2 < check.length; ++i2) {
                check[i2] = false;
            }
            block9: for (i2 = 0; i2 < files.length; ++i2) {
                for (int j = 0; j < flist.length; ++j) {
                    if (!flist[j].getName().equals(files[i2])) continue;
                    check[i2] = true;
                    continue block9;
                }
            }
            int checkCount = 0;
            for (i = 0; i < check.length; ++i) {
                if (check[i]) continue;
                ++checkCount;
            }
            FileTest.assertEquals((String)"Invalid file returned in listing", (int)0, (int)checkCount);
            for (i = 0; i < files.length; ++i) {
                FileWrapperImpl f = new FileWrapperImpl((FileWrapper)baseDir, files[i]);
                f.delete();
            }
            dir1.delete();
            FileTest.assertTrue((String)"Parent Directory Not Deleted.", (boolean)baseDir.delete());
        }
        finally {
            for (int i = 0; i < files.length; ++i) {
                FileWrapperImpl f = new FileWrapperImpl((FileWrapper)baseDir, files[i]);
                f.delete();
            }
            if (dir1 != null) {
                dir1.delete();
            }
            baseDir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_listFilesLjava_io_FilenameFilter() throws IOException {
        String base = System.getProperty("java.io.tmpdir");
        int dirNumber = 1;
        boolean dirExists = true;
        FileWrapperImpl dir = new FileWrapperImpl(base, platformId + String.valueOf(dirNumber));
        while (dirExists) {
            if (dir.exists()) {
                dir = new FileWrapperImpl(base, platformId + String.valueOf(++dirNumber));
                continue;
            }
            dirExists = false;
        }
        FilenameFilter tstFilter = new FilenameFilter(){

            @Override
            public boolean accept(File f, String fileName) {
                return fileName.endsWith(".tst");
            }
        };
        FileTest.assertNull((String)"listFiles Should Return Null.", (Object)dir.listFiles(tstFilter));
        FileTest.assertTrue((String)"Failed To Create Parent Directory.", (boolean)dir.mkdir());
        String[] files = new String[]{"1.tst", "2.tst", "3.tmp"};
        try {
            int i;
            FileTest.assertEquals((String)"listFiles Should Return An Array Of Length 0.", (int)0, (int)dir.listFiles(tstFilter).length);
            FileWrapperImpl file = new FileWrapperImpl((FileWrapper)dir, "notADir.tst");
            try {
                FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());
                fos.close();
                FileTest.assertNull((String)"listFiles Should Have Returned Null When Used On A File Instead Of A Directory.", (Object)file.listFiles(tstFilter));
            }
            finally {
                file.delete();
            }
            for (int i2 = 0; i2 < files.length; ++i2) {
                FileWrapperImpl f = new FileWrapperImpl((FileWrapper)dir, files[i2]);
                FileOutputStream fos = new FileOutputStream(f.getAbsolutePath());
                fos.close();
            }
            FilenameFilter tmpFilter = new FilenameFilter(){

                @Override
                public boolean accept(File f, String fileName) {
                    return fileName.endsWith(".tmp");
                }
            };
            FileWrapper[] flist = dir.listFiles(tstFilter);
            FileTest.assertEquals((String)"Incorrect Number Of Files Passed Through tstFilter.", (int)2, (int)flist.length);
            for (i = 0; i < flist.length; ++i) {
                FileTest.assertTrue((String)"File Should Not Have Passed The tstFilter.", (boolean)flist[i].getPath().endsWith(".tst"));
            }
            flist = dir.listFiles(tmpFilter);
            FileTest.assertEquals((String)"Incorrect Number Of Files Passed Through tmpFilter.", (int)1, (int)flist.length);
            FileTest.assertTrue((String)"FileWrapper Should Not Have Passed The tmpFilter.", (boolean)flist[0].getPath().endsWith(".tmp"));
            for (i = 0; i < files.length; ++i) {
                FileWrapperImpl f = new FileWrapperImpl((FileWrapper)dir, files[i]);
                f.delete();
            }
            FileTest.assertTrue((String)"Parent Directory Not Deleted.", (boolean)dir.delete());
        }
        finally {
            for (int i = 0; i < files.length; ++i) {
                FileWrapperImpl f = new FileWrapperImpl((FileWrapper)dir, files[i]);
                f.delete();
            }
            dir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_listLjava_io_FilenameFilter() throws IOException {
        String base = System.getProperty("user.dir");
        int dirNumber = 1;
        boolean dirExists = true;
        FileWrapperImpl dir = new FileWrapperImpl(base, platformId + String.valueOf(dirNumber));
        while (dirExists) {
            if (dir.exists()) {
                dir = new FileWrapperImpl(base, String.valueOf(++dirNumber));
                continue;
            }
            dirExists = false;
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.equals("mtzz1.xx");
            }
        };
        String[] flist = dir.list(filter);
        FileTest.assertNull((String)"Method list(FilenameFilter) Should Have Returned Null.", (Object)flist);
        FileTest.assertTrue((String)"Could not create parent directory for test", (boolean)dir.mkdir());
        String[] files = new String[]{"mtzz1.xx", "mtzz2.xx", "mtzz3.yy", "mtzz4.yy"};
        try {
            int i;
            flist = dir.list(filter);
            FileTest.assertEquals((String)"Array Of Length 0 Should Have Returned.", (int)0, (int)flist.length);
            for (int i2 = 0; i2 < files.length; ++i2) {
                FileWrapperImpl f = new FileWrapperImpl((FileWrapper)dir, files[i2]);
                FileOutputStream fos = new FileOutputStream(f.getAbsolutePath());
                fos.close();
            }
            flist = dir.list(filter);
            FileTest.assertEquals((String)"Incorrect list returned", (int)flist.length, (int)(files.length - 1));
            boolean[] check = new boolean[flist.length];
            for (int i3 = 0; i3 < check.length; ++i3) {
                check[i3] = false;
            }
            String[] wantedFiles = new String[]{"mtzz2.xx", "mtzz3.yy", "mtzz4.yy"};
            block6: for (int i4 = 0; i4 < wantedFiles.length; ++i4) {
                for (int j = 0; j < flist.length; ++j) {
                    if (!flist[j].equals(wantedFiles[i4])) continue;
                    check[i4] = true;
                    continue block6;
                }
            }
            int checkCount = 0;
            for (i = 0; i < check.length; ++i) {
                if (check[i]) continue;
                ++checkCount;
            }
            FileTest.assertEquals((String)"Invalid file returned in listing", (int)0, (int)checkCount);
            for (i = 0; i < files.length; ++i) {
                FileWrapperImpl f = new FileWrapperImpl((FileWrapper)dir, files[i]);
                f.delete();
            }
            FileTest.assertTrue((String)"Could not delete parent directory for test.", (boolean)dir.delete());
        }
        finally {
            for (int i = 0; i < files.length; ++i) {
                FileWrapperImpl f = new FileWrapperImpl((FileWrapper)dir, files[i]);
                f.delete();
            }
            dir.delete();
        }
    }

    public void test_listRoots() {
        boolean onWindows;
        File[] roots = File.listRoots();
        boolean onUnix = File.separatorChar == '/';
        boolean bl = onWindows = File.separatorChar == '\\';
        if (onUnix) {
            FileTest.assertEquals((String)"Incorrect Number Of Root Directories.", (int)1, (int)roots.length);
            String fileLoc = roots[0].getPath();
            FileTest.assertTrue((String)"Incorrect Root Directory Returned.", (boolean)fileLoc.startsWith(this.slash));
        } else if (onWindows) {
            FileTest.assertTrue((String)"Incorrect Number Of Root Directories.", (roots.length > 0 ? 1 : 0) != 0);
        }
    }

    public void test_mkdir() throws IOException {
        String base = System.getProperty("user.dir");
        int dirNumber = 1;
        boolean dirExists = true;
        FileWrapperImpl dir = new FileWrapperImpl(base, String.valueOf(dirNumber));
        while (dirExists) {
            if (dir.exists()) {
                dir = new FileWrapperImpl(base, String.valueOf(++dirNumber));
                continue;
            }
            dirExists = false;
        }
        FileTest.assertTrue((String)"mkdir failed", (boolean)dir.mkdir());
        FileTest.assertTrue((String)"mkdir worked but exists check failed", (boolean)dir.exists());
        dir.deleteOnExit();
        String longDirName = "abcdefghijklmnopqrstuvwx";
        String newbase = new String(dir + File.separator);
        StringBuilder sb = new StringBuilder(dir + File.separator);
        StringBuilder sb2 = new StringBuilder(dir + File.separator);
        while (dir.getCanonicalPath().length() < 256 - longDirName.length()) {
            sb.append(longDirName + File.separator);
            dir = new FileWrapperImpl(sb.toString());
            FileTest.assertTrue((String)"mkdir failed", (boolean)dir.mkdir());
            FileTest.assertTrue((String)"mkdir worked but exists check failed", (boolean)dir.exists());
            dir.deleteOnExit();
        }
        while (dir.getCanonicalPath().length() < 256) {
            sb.append(0);
            dir = new FileWrapperImpl(sb.toString());
            FileTest.assertTrue((String)("mkdir " + dir.getCanonicalPath().length() + " failed"), (boolean)dir.mkdir());
            FileTest.assertTrue((String)("mkdir " + dir.getCanonicalPath().length() + " worked but exists check failed"), (boolean)dir.exists());
            dir.deleteOnExit();
        }
        dir = new FileWrapperImpl(sb2.toString());
        while (dir.getCanonicalPath().length() < 256) {
            sb2.append(0);
            dir = new FileWrapperImpl(sb2.toString());
            FileTest.assertTrue((String)("mkdir " + dir.getCanonicalPath().length() + " failed"), (boolean)dir.mkdir());
            FileTest.assertTrue((String)("mkdir " + dir.getCanonicalPath().length() + " worked but exists check failed"), (boolean)dir.exists());
            dir.deleteOnExit();
        }
        String[] ss = new String[]{"dir\u3400", "abc", "abc@123", "!@#$%^&", "~\u4e00!\u4e8c@\u4e09$", "\u56db\u4e94\u516d", "\u4e03\u516b\u4e5d"};
        for (int i = 0; i < ss.length; ++i) {
            dir = new FileWrapperImpl(newbase, ss[i]);
            FileTest.assertTrue((String)("mkdir " + dir.getCanonicalPath() + " failed"), (boolean)dir.mkdir());
            FileTest.assertTrue((String)("mkdir " + dir.getCanonicalPath() + " worked but exists check failed"), (boolean)dir.exists());
            dir.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_mkdirs() {
        String userHome = System.getProperty("user.dir");
        if (!userHome.endsWith(this.slash)) {
            userHome = userHome + this.slash;
        }
        FileWrapperImpl f = new FileWrapperImpl(userHome + "mdtest" + platformId + this.slash + "mdtest2", "p.tst");
        FileWrapperImpl g = new FileWrapperImpl(userHome + "mdtest" + platformId + this.slash + "mdtest2");
        FileWrapperImpl h = new FileWrapperImpl(userHome + "mdtest" + platformId);
        f.mkdirs();
        try {
            FileTest.assertTrue((String)"Base Directory not created", (boolean)h.exists());
            FileTest.assertTrue((String)"Directories not created", (boolean)g.exists());
            FileTest.assertTrue((String)"File not created", (boolean)f.exists());
        }
        finally {
            f.delete();
            g.delete();
            h.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_renameToLjava_io_File() throws IOException {
        String base = System.getProperty("user.dir");
        FileWrapperImpl dir = new FileWrapperImpl(base, platformId);
        dir.mkdir();
        FileWrapperImpl f = new FileWrapperImpl((FileWrapper)dir, "xxx.xxx");
        FileWrapperImpl rfile = new FileWrapperImpl((FileWrapper)dir, "yyy.yyy");
        FileWrapperImpl f2 = new FileWrapperImpl((FileWrapper)dir, "zzz.zzz");
        try {
            FileOutputStream fos = new FileOutputStream(f.getAbsolutePath());
            fos.write(this.fileString.getBytes());
            fos.close();
            long lengthOfFile = f.length();
            rfile.delete();
            FileTest.assertTrue((String)"Test 1: File Rename Failed", (boolean)f.renameTo((FileWrapper)rfile));
            FileTest.assertTrue((String)"Test 2: File Rename Failed.", (boolean)rfile.exists());
            FileTest.assertEquals((String)"Test 3: Size Of File Changed.", (long)lengthOfFile, (long)rfile.length());
            fos = new FileOutputStream(rfile.getAbsolutePath());
            fos.close();
            f2.delete();
            FileTest.assertTrue((String)"Test 4: File Rename Failed", (boolean)rfile.renameTo((FileWrapper)f2));
            FileTest.assertTrue((String)"Test 5: File Rename Failed.", (boolean)f2.exists());
        }
        finally {
            f.delete();
            rfile.delete();
            f2.delete();
            dir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_setLastModifiedJ() throws IOException {
        FileWrapperImpl f1 = null;
        try {
            f1 = new FileWrapperImpl(Support_PlatformFile.getNewPlatformFile("hyts_tf_slm", ".tmp"));
            f1.createNewFile();
            long orgTime = f1.lastModified();
            f1.setLastModified(orgTime - 100000L);
            long lastModified = f1.lastModified();
            FileTest.assertEquals((String)"Test 1: LastModifed time incorrect", (long)(orgTime - 100000L), (long)lastModified);
            f1.setLastModified(orgTime - 10000000L);
            lastModified = f1.lastModified();
            FileTest.assertEquals((String)"Test 2: LastModifed time incorrect", (long)(orgTime - 10000000L), (long)lastModified);
            f1.setLastModified(orgTime + 100000L);
            lastModified = f1.lastModified();
            FileTest.assertEquals((String)"Test 3: LastModifed time incorrect", (long)(orgTime + 100000L), (long)lastModified);
            f1.setLastModified(orgTime + 10000000L);
            lastModified = f1.lastModified();
            FileTest.assertEquals((String)"Test 4: LastModifed time incorrect", (long)(orgTime + 10000000L), (long)lastModified);
            f1.setLastModified(315550800000L);
            lastModified = f1.lastModified();
            FileTest.assertEquals((String)"Test 5: LastModified time incorrect", (long)315550800000L, (long)lastModified);
            String osName = System.getProperty("os.name", "unknown");
            if (osName.equals("Windows 2000") || osName.equals("Windows NT")) {
                boolean result = f1.setLastModified(4354837199000L);
                long next = f1.lastModified();
                if (result) {
                    FileTest.assertEquals((String)"Test 6: LastModified time incorrect", (long)4354837199000L, (long)next);
                }
            }
            try {
                f1.setLastModified(-25L);
                FileTest.fail((String)"IllegalArgumentException Not Thrown.");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        finally {
            if (f1 != null) {
                f1.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_setReadOnly() throws IOException, InterruptedException {
        FileWrapper f1 = null;
        FileWrapper f2 = null;
        try {
            f1 = FileWrapperImpl.createTempFile((String)"hyts_tf", (String)".tmp");
            f2 = FileWrapperImpl.createTempFile((String)"hyts_tf", (String)".tmp");
            f1.setReadOnly();
            try {
                new FileOutputStream(f1.getAbsolutePath());
                FileTest.fail((String)"IOException not thrown.");
            }
            catch (IOException e) {
                // empty catch block
            }
            Runtime r = Runtime.getRuntime();
            boolean onUnix = File.separatorChar == '/';
            Process p = onUnix ? r.exec("chmod +w " + f1.getAbsolutePath()) : r.exec("attrib -r \"" + f1.getAbsolutePath() + "\"");
            p.waitFor();
            FileOutputStream fos = new FileOutputStream(f1.getAbsolutePath());
            fos.write(this.fileString.getBytes());
            fos.close();
            FileTest.assertTrue((String)"File Was Not Able To Be Written To.", (f1.length() == (long)this.fileString.length() ? 1 : 0) != 0);
            FileTest.assertTrue((String)"File f1 Did Not Delete", (boolean)f1.delete());
            fos = new FileOutputStream(f2.getAbsolutePath());
            fos.write(this.fileString.getBytes());
            fos.close();
            f2.setReadOnly();
            try {
                fos = new FileOutputStream(f2.getAbsolutePath());
                FileTest.fail((String)"IOException not thrown.");
            }
            catch (IOException e) {
                // empty catch block
            }
            r = Runtime.getRuntime();
            p = onUnix ? r.exec("chmod +w " + f2.getAbsolutePath()) : r.exec("attrib -r \"" + f2.getAbsolutePath() + "\"");
            p.waitFor();
            FileTest.assertTrue((String)"File f2 Is Set To ReadOnly.", (boolean)f2.canWrite());
            fos = new FileOutputStream(f2.getAbsolutePath());
            fos.write(this.fileString.getBytes());
            fos.close();
            f2.setReadOnly();
            FileTest.assertTrue((String)"FileWrapper f2 Did Not Delete", (boolean)f2.delete());
            f2 = new FileWrapperImpl(System.getProperty("user.dir"), "deltestdir");
            f2.mkdir();
            f2.setReadOnly();
            FileTest.assertTrue((String)"Directory f2 Did Not Delete", (boolean)f2.delete());
            FileTest.assertTrue((String)"Directory f2 Did Not Delete", (!f2.exists() ? 1 : 0) != 0);
        }
        finally {
            if (f1 != null) {
                f1.delete();
            }
            if (f2 != null) {
                f2.delete();
            }
        }
    }

    public void test_toString() {
        String fileName = System.getProperty("user.home") + this.slash + "input.tst";
        FileWrapperImpl f = new FileWrapperImpl(fileName);
        FileTest.assertEquals((String)"Incorrect string returned", (String)fileName, (String)f.toString());
        if (File.separatorChar == '\\') {
            String result = new FileWrapperImpl("c:\\").toString();
            FileTest.assertEquals((String)"Removed backslash", (String)"c:\\", (String)result);
        }
    }

    public void test_toURI() throws URISyntaxException {
        FileWrapperImpl dir = new FileWrapperImpl(System.getProperty("user.dir"));
        String newURIPath = dir.getAbsolutePath();
        if (!(newURIPath = newURIPath.replace(File.separatorChar, '/')).startsWith("/")) {
            newURIPath = "/" + newURIPath;
        }
        if (!newURIPath.endsWith("/")) {
            newURIPath = newURIPath + '/';
        }
        URI uri = dir.toURI();
        FileTest.assertEquals((String)"Test 1A: Incorrect URI Returned.", (Object)dir.getAbsoluteFile(), (Object)new FileWrapperImpl(uri));
        FileTest.assertEquals((String)"Test 1B: Incorrect URI Returned.", (Object)new URI("file", null, newURIPath, null, null), (Object)uri);
        FileWrapperImpl f = new FileWrapperImpl((FileWrapper)dir, "te% \u20ac st.tst");
        newURIPath = f.getAbsolutePath();
        newURIPath = newURIPath.replace(File.separatorChar, '/');
        if (!newURIPath.startsWith("/")) {
            newURIPath = "/" + newURIPath;
        }
        uri = f.toURI();
        FileTest.assertEquals((String)"Test 2A: Incorrect URI Returned.", (Object)f.getAbsoluteFile(), (Object)new FileWrapperImpl(uri));
        FileTest.assertEquals((String)"Test 2B: Incorrect URI Returned.", (Object)new URI("file", null, newURIPath, null, null), (Object)uri);
        dir = new FileWrapperImpl("");
        uri = dir.toURI();
        FileTest.assertTrue((String)"Test current dir: URI does not end with slash.", (boolean)uri.toString().endsWith("/"));
    }

    public void test_toURL() throws MalformedURLException {
        FileWrapperImpl dir = new FileWrapperImpl(System.getProperty("user.dir"));
        String newDirURL = dir.getAbsolutePath();
        if (!(newDirURL = (newDirURL = newDirURL.replace(File.separatorChar, '/')).startsWith("/") ? "file:" + newDirURL : "file:/" + newDirURL).endsWith("/")) {
            newDirURL = newDirURL + '/';
        }
        FileTest.assertEquals((String)"Test 1: Incorrect URL Returned.", (String)dir.toURL().toString(), (String)newDirURL);
        FileWrapperImpl f = new FileWrapperImpl((FileWrapper)dir, "test.tst");
        String newURL = f.getAbsolutePath();
        newURL = newURL.replace(File.separatorChar, '/');
        newURL = newURL.startsWith("/") ? "file:" + newURL : "file:/" + newURL;
        FileTest.assertEquals((String)"Test 2: Incorrect URL Returned.", (String)f.toURL().toString(), (String)newURL);
        dir = new FileWrapperImpl("");
        newDirURL = dir.toURL().toString();
        FileTest.assertTrue((String)"Test current dir: URL does not end with slash.", (boolean)newDirURL.endsWith("/"));
    }

    public void test_toURI2() throws URISyntaxException {
        FileWrapperImpl f = new FileWrapperImpl(System.getProperty("user.dir"), "a/b/c/../d/e/./f");
        String path = f.getAbsolutePath();
        if (!(path = path.replace(File.separatorChar, '/')).startsWith("/")) {
            path = "/" + path;
        }
        URI uri1 = new URI("file", null, path, null);
        URI uri2 = f.toURI();
        FileTest.assertEquals((String)"uris not equal", (Object)uri1, (Object)uri2);
    }

    public void test_toURL2() throws MalformedURLException {
        FileWrapperImpl f = new FileWrapperImpl(System.getProperty("user.dir"), "a/b/c/../d/e/./f");
        String path = f.getAbsolutePath();
        if (!(path = path.replace(File.separatorChar, '/')).startsWith("/")) {
            path = "/" + path;
        }
        URL url1 = new URL("file", "", path);
        URL url2 = f.toURL();
        FileTest.assertEquals((String)"urls not equal", (Object)url1, (Object)url2);
    }

    public void test_objectStreamClass_getFields() throws Exception {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(File.class);
        ObjectStreamField[] objectStreamFields = objectStreamClass.getFields();
        FileTest.assertEquals((int)1, (int)objectStreamFields.length);
        ObjectStreamField objectStreamField = objectStreamFields[0];
        FileTest.assertEquals((String)"path", (String)objectStreamField.getName());
        FileTest.assertEquals(String.class, objectStreamField.getType());
    }

    public void test_list_withUnicodeFileName() throws Exception {
        String[] fileNames;
        String dirName;
        FileWrapperImpl dir;
        FileWrapperImpl rootDir = new FileWrapperImpl("P");
        if (!rootDir.exists()) {
            rootDir.mkdir();
            rootDir.deleteOnExit();
        }
        if (!(dir = new FileWrapperImpl((FileWrapper)rootDir, dirName = new String("src\u3400"))).exists()) {
            dir.mkdir();
            dir.deleteOnExit();
        }
        boolean exist = false;
        for (String fileName : fileNames = rootDir.list()) {
            if (!dirName.equals(fileName)) continue;
            exist = true;
            break;
        }
        FileTest.assertTrue((boolean)exist);
    }

    @Override
    protected void setUp() throws IOException {
        String userDir = System.getProperty("user.dir");
        if (userDir == null) {
            userDir = "j:\\jcl-builddir\\temp\\source";
        }
        if (!userDir.regionMatches(userDir.length() - 1, this.slash, 0, 1)) {
            userDir = userDir + this.slash;
        }
        this.tempDirectory = new FileWrapperImpl(userDir + "tempDir" + String.valueOf(System.currentTimeMillis()));
        if (!this.tempDirectory.mkdir()) {
            System.out.println("Setup for FileTest failed.");
        }
        this.tempFile = new FileWrapperImpl(this.tempDirectory, "tempfile");
        FileOutputStream tempStream = new FileOutputStream(this.tempFile.getPath(), false);
        tempStream.close();
    }

    @Override
    protected void tearDown() {
        this.tempFile.delete();
        this.tempDirectory.delete();
    }
}

