/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import net.sourceforge.squirrel_sql.BaseSQuirreLTestCase;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class StringUtilitiesTest
extends BaseSQuirreLTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testJoin() {
        String[] parts = new String[]{"foo", "bar", "baz"};
        String joinedParts = StringUtilities.join((String[])parts, null);
        StringUtilitiesTest.assertEquals((String)"foobarbaz", (String)joinedParts);
        joinedParts = StringUtilities.join((String[])parts, (String)"|");
        StringUtilitiesTest.assertEquals((String)"foo|bar|baz", (String)joinedParts);
        joinedParts = StringUtilities.join((String[])parts, (String)"");
        StringUtilitiesTest.assertEquals((String)"foobarbaz", (String)joinedParts);
    }

    public void testSegment() {
        String[] segments = null;
        String longString = "part1part2part3part4";
        segments = StringUtilities.segment((String)longString, (int)1);
        StringUtilitiesTest.assertEquals((int)segments.length, (int)20);
        segments = StringUtilities.segment((String)longString, (int)5);
        StringUtilitiesTest.assertEquals((int)segments.length, (int)4);
        segments = StringUtilities.segment((String)longString, (int)9);
        StringUtilitiesTest.assertEquals((int)segments.length, (int)3);
        segments = StringUtilities.segment((String)longString, (int)11);
        StringUtilitiesTest.assertEquals((int)segments.length, (int)2);
        segments = StringUtilities.segment((String)longString, (int)20);
        StringUtilitiesTest.assertEquals((int)segments.length, (int)1);
    }

    public void testGetTokenBeginIndex() {
        String sql = "select valid_from from dealer";
        int idx = StringUtilities.getTokenBeginIndex((String)sql, (String)"from");
        StringUtilitiesTest.assertEquals((int)18, (int)idx);
        sql = "select from_date from dealer";
        idx = StringUtilities.getTokenBeginIndex((String)sql, (String)"from");
        StringUtilitiesTest.assertEquals((int)17, (int)idx);
    }

    public void testChop() {
        String toChop = "(1,2,3)";
        String expAfterChop = "(1,2,3";
        String afterChop = StringUtilities.chop((String)toChop);
        StringUtilitiesTest.assertEquals((String)expAfterChop, (String)afterChop);
    }
}

