/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;

public class AvoidReassigningParametersRule
extends AbstractJavaRulechainRule {
    public AvoidReassigningParametersRule() {
        super(ASTMethodDeclaration.class, ASTConstructorDeclaration.class);
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        this.lookForViolations(node, data);
        return data;
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.lookForViolations(node, data);
        return data;
    }

    private void lookForViolations(ASTExecutableDeclaration node, Object data) {
        block0: for (ASTFormalParameter formal : node.getFormalParameters()) {
            ASTVariableId varId = formal.getVarId();
            for (ASTAssignableExpr.ASTNamedReferenceExpr usage : varId.getLocalUsages()) {
                if (usage.getAccessType() != ASTAssignableExpr.AccessType.WRITE) continue;
                this.asCtx(data).addViolation((Node)usage, new Object[]{varId.getName()});
                continue block0;
            }
        }
    }
}

