/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.metrics.MetricsUtil;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class CyclomaticComplexityRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Integer> CLASS_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"classReportLevel").desc("Total class complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)80)).build();
    private static final PropertyDescriptor<Integer> METHOD_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"methodReportLevel").desc("Cyclomatic complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)10)).build();
    private static final Map<String, JavaMetrics.CycloOption> OPTION_MAP = new HashMap<String, JavaMetrics.CycloOption>();
    private static final PropertyDescriptor<List<JavaMetrics.CycloOption>> CYCLO_OPTIONS_DESCRIPTOR;

    public CyclomaticComplexityRule() {
        super(ASTExecutableDeclaration.class, ASTTypeDeclaration.class);
        this.definePropertyDescriptor(CLASS_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor(METHOD_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor(CYCLO_OPTIONS_DESCRIPTOR);
    }

    @Override
    public Object visitJavaNode(JavaNode node, Object param) {
        if (node instanceof ASTTypeDeclaration) {
            this.visitTypeDecl((ASTTypeDeclaration)node, param);
        }
        return null;
    }

    public Object visitTypeDecl(ASTTypeDeclaration node, Object data) {
        int classWmc;
        MetricOptions cycloOptions = MetricOptions.ofOptions((Collection)((Collection)this.getProperty(CYCLO_OPTIONS_DESCRIPTOR)));
        if (JavaMetrics.WEIGHED_METHOD_COUNT.supports((Node)node) && (classWmc = ((Integer)MetricsUtil.computeMetric(JavaMetrics.WEIGHED_METHOD_COUNT, (Node)node, (MetricOptions)cycloOptions)).intValue()) >= (Integer)this.getProperty(CLASS_LEVEL_DESCRIPTOR)) {
            int classHighest = (int)MetricsUtil.computeStatistics(JavaMetrics.CYCLO, node.getOperations(), (MetricOptions)cycloOptions).getMax();
            String[] messageParams = new String[]{PrettyPrintingUtil.getPrintableNodeKind(node), node.getSimpleName(), " total", classWmc + " (highest " + classHighest + ")"};
            this.asCtx(data).addViolation((Node)node, (Object[])messageParams);
        }
        return data;
    }

    public final Object visit(ASTMethodDeclaration node, Object data) {
        this.visitMethodLike(node, data);
        return data;
    }

    public final Object visit(ASTConstructorDeclaration node, Object data) {
        this.visitMethodLike(node, data);
        return data;
    }

    private void visitMethodLike(ASTExecutableDeclaration node, Object data) {
        int cyclo;
        MetricOptions cycloOptions = MetricOptions.ofOptions((Collection)((Collection)this.getProperty(CYCLO_OPTIONS_DESCRIPTOR)));
        if (JavaMetrics.CYCLO.supports((Node)node) && (cyclo = ((Integer)MetricsUtil.computeMetric(JavaMetrics.CYCLO, (Node)node, (MetricOptions)cycloOptions)).intValue()) >= (Integer)this.getProperty(METHOD_LEVEL_DESCRIPTOR)) {
            String opname = PrettyPrintingUtil.displaySignature(node);
            String kindname = node instanceof ASTConstructorDeclaration ? "constructor" : "method";
            this.asCtx(data).addViolation((Node)node, new Object[]{kindname, opname, "", "" + cyclo});
        }
    }

    static {
        OPTION_MAP.put(JavaMetrics.CycloOption.IGNORE_BOOLEAN_PATHS.valueName(), JavaMetrics.CycloOption.IGNORE_BOOLEAN_PATHS);
        OPTION_MAP.put(JavaMetrics.CycloOption.CONSIDER_ASSERT.valueName(), JavaMetrics.CycloOption.CONSIDER_ASSERT);
        CYCLO_OPTIONS_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.enumListProperty((String)"cycloOptions", OPTION_MAP).desc("Choose options for the computation of Cyclo")).emptyDefaultValue().build();
    }
}

