/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.FlexibleUnresolvedClassImpl;
import net.sourceforge.pmd.lang.java.symbols.internal.UnresolvedClassImpl;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class UnresolvedClassStore {
    private final Map<String, UnresolvedClassImpl> unresolved = new HashMap<String, UnresolvedClassImpl>();
    private final TypeSystem ts;

    public UnresolvedClassStore(TypeSystem ts) {
        this.ts = ts;
    }

    public @NonNull JClassSymbol makeUnresolvedReference(@Nullable String canonicalName, int typeArity) {
        UnresolvedClassImpl unresolved = this.unresolved.computeIfAbsent(canonicalName, n -> new FlexibleUnresolvedClassImpl(this.ts, null, (String)n));
        unresolved.setTypeParameterCount(typeArity);
        return unresolved;
    }

    public @NonNull JClassSymbol makeUnresolvedReference(JClassSymbol qualifier, String simpleName, int typeArity) {
        if (qualifier instanceof UnresolvedClassImpl) {
            UnresolvedClassImpl child = ((UnresolvedClassImpl)qualifier).getOrCreateUnresolvedChildClass(simpleName);
            child.setTypeParameterCount(typeArity);
            this.unresolved.putIfAbsent(child.getCanonicalName(), child);
            return child;
        }
        return this.makeUnresolvedReference(qualifier.getCanonicalName() + '.' + simpleName, typeArity);
    }
}

