/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.idm;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.activiti.app.service.api.UserCache;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class UserCacheImpl
implements UserCache {
    private final Logger logger = LoggerFactory.getLogger(UserCacheImpl.class);
    @Autowired
    protected Environment environment;
    @Autowired
    protected IdentityService identityService;
    protected LoadingCache<String, UserCache.CachedUser> userCache;

    @PostConstruct
    protected void initCache() {
        Long userCacheMaxSize = (Long)this.environment.getProperty("cache.users.max.size", Long.class);
        Long userCacheMaxAge = (Long)this.environment.getProperty("cache.users.max.age", Long.class);
        this.userCache = CacheBuilder.newBuilder().maximumSize(userCacheMaxSize != null ? userCacheMaxSize : 2048L).expireAfterAccess(userCacheMaxAge != null ? userCacheMaxAge : 86400L, TimeUnit.SECONDS).recordStats().build((CacheLoader)new CacheLoader<String, UserCache.CachedUser>(){

            public UserCache.CachedUser load(String userId) throws Exception {
                User userFromDatabase = (User)UserCacheImpl.this.identityService.createUserQuery().userId(userId).singleResult();
                if (userFromDatabase == null) {
                    throw new UsernameNotFoundException("User " + userId + " was not found in the database");
                }
                ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
                return new UserCache.CachedUser(userFromDatabase, grantedAuthorities);
            }
        });
    }

    @Override
    public void putUser(String userId, UserCache.CachedUser cachedUser) {
        this.userCache.put((Object)userId, (Object)cachedUser);
    }

    @Override
    public UserCache.CachedUser getUser(String userId) {
        return this.getUser(userId, false, false, true);
    }

    @Override
    public UserCache.CachedUser getUser(String userId, boolean throwExceptionOnNotFound, boolean throwExceptionOnInactive, boolean checkValidity) {
        try {
            UserCache.CachedUser cachedUser = (UserCache.CachedUser)this.userCache.get((Object)userId);
            return cachedUser;
        }
        catch (ExecutionException e) {
            return null;
        }
        catch (UncheckedExecutionException uee) {
            if (uee.getCause() instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)uee.getCause();
                if (runtimeException instanceof UsernameNotFoundException) {
                    if (throwExceptionOnNotFound) {
                        throw runtimeException;
                    }
                    return null;
                }
                if (runtimeException instanceof LockedException) {
                    if (throwExceptionOnNotFound) {
                        throw runtimeException;
                    }
                    return null;
                }
            }
            throw uee;
        }
    }

    @Override
    public void invalidate(String userId) {
        this.userCache.invalidate((Object)userId);
    }
}

