/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.runtime;

import java.util.Date;
import org.activiti.app.repository.idm.PersistentTokenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PersistentTokenCleanupService {
    private static final Logger logger = LoggerFactory.getLogger(PersistentTokenCleanupService.class);
    @Autowired
    protected Environment environment;
    @Autowired
    private PersistentTokenRepository persistentTokenRepository;

    @Transactional
    @Scheduled(cron="${security.cookie.database-removal.cronExpression:0 0 1 * * ?}")
    public void deleteObsoletePersistentTokens() {
        long maxAge = this.getTokenMaxAge();
        long now = new Date().getTime();
        Date maxDate = new Date(now - maxAge);
        Long deletedTokens = this.persistentTokenRepository.deleteByTokenDateBefore(maxDate);
        if (deletedTokens != null) {
            logger.info("Removed " + deletedTokens + " obsolete persisted tokens");
        }
    }

    protected long getTokenMaxAge() {
        Integer tokenMaxAgeSeconds = (Integer)this.environment.getProperty("security.cookie.database-removal.max-age", Integer.class);
        if (tokenMaxAgeSeconds == null) {
            tokenMaxAgeSeconds = (Integer)this.environment.getProperty("security.cookie.max-age", Integer.class, (Object)2678400);
        }
        return tokenMaxAgeSeconds.longValue() * 1000L + 1L;
    }
}

