/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.deployer;

import java.util.Map;
import org.activiti.dmn.api.DmnDeploymentBuilder;
import org.activiti.dmn.api.DmnRepositoryService;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.deploy.Deployer;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnDeployer
implements Deployer {
    private static final Logger log = LoggerFactory.getLogger(DmnDeployer.class);

    public void deploy(DeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        if (!deployment.isNew()) {
            return;
        }
        log.debug("DmnDeployer: processing deployment {}", (Object)deployment.getName());
        DmnDeploymentBuilder dmnDeploymentBuilder = null;
        Map resources = deployment.getResources();
        for (String resourceName : resources.keySet()) {
            if (!resourceName.endsWith(".dmn")) continue;
            log.info("DmnDeployer: processing resource {}", (Object)resourceName);
            if (dmnDeploymentBuilder == null) {
                DmnRepositoryService dmnRepositoryService = Context.getProcessEngineConfiguration().getDmnEngineRepositoryService();
                dmnDeploymentBuilder = dmnRepositoryService.createDeployment();
            }
            dmnDeploymentBuilder.addDmnBytes(resourceName, ((ResourceEntity)resources.get(resourceName)).getBytes());
        }
        if (dmnDeploymentBuilder != null) {
            dmnDeploymentBuilder.parentDeploymentId(deployment.getId());
            if (deployment.getTenantId() != null && deployment.getTenantId().length() > 0) {
                dmnDeploymentBuilder.tenantId(deployment.getTenantId());
            }
            dmnDeploymentBuilder.deploy();
        }
    }
}

