/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.activiti.dmn.api.DmnDecisionTable;
import org.activiti.dmn.engine.ActivitiDmnIllegalArgumentException;
import org.activiti.dmn.engine.ActivitiDmnObjectNotFoundException;
import org.activiti.dmn.engine.impl.DecisionTableQueryImpl;
import org.activiti.dmn.engine.impl.interceptor.Command;
import org.activiti.dmn.engine.impl.interceptor.CommandContext;
import org.activiti.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;

public class SetDeploymentTenantIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String newTenantId;

    public SetDeploymentTenantIdCmd(String deploymentId, String newTenantId) {
        this.deploymentId = deploymentId;
        this.newTenantId = newTenantId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new ActivitiDmnIllegalArgumentException("deploymentId is null");
        }
        DmnDeploymentEntity deployment = (DmnDeploymentEntity)commandContext.getDeploymentEntityManager().findById(this.deploymentId);
        if (deployment == null) {
            throw new ActivitiDmnObjectNotFoundException("Could not find deployment with id " + this.deploymentId);
        }
        deployment.setTenantId(this.newTenantId);
        commandContext.getDecisionTableEntityManager().updateDecisionTableTenantIdForDeployment(this.deploymentId, this.newTenantId);
        List decisionTables = new DecisionTableQueryImpl().deploymentId(this.deploymentId).list();
        for (DmnDecisionTable decisionTable : decisionTables) {
            commandContext.getDmnEngineConfiguration().getDecisionCache().remove(decisionTable.getId());
        }
        commandContext.getDeploymentEntityManager().update(deployment);
        return null;
    }
}

