/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.deployer;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.activiti.dmn.engine.ActivitiDmnException;
import org.activiti.dmn.engine.ActivitiDmnIllegalArgumentException;
import org.activiti.dmn.engine.impl.context.Context;
import org.activiti.dmn.engine.impl.deployer.ParsedDeployment;
import org.activiti.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.activiti.dmn.engine.impl.persistence.entity.DecisionTableEntityManager;
import org.activiti.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.apache.commons.lang3.StringUtils;

public class DmnDeploymentHelper {
    public void verifyDecisionTablesDoNotShareKeys(Collection<DecisionTableEntity> decisionTables) {
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        for (DecisionTableEntity decisionTable : decisionTables) {
            if (keySet.contains(decisionTable.getKey())) {
                throw new ActivitiDmnException("The deployment contains decision tables with the same key (decision id attribute), this is not allowed");
            }
            keySet.add(decisionTable.getKey());
        }
    }

    public void copyDeploymentValuesToDecisionTables(DmnDeploymentEntity deployment, List<DecisionTableEntity> decisionTables) {
        String tenantId = deployment.getTenantId();
        String deploymentId = deployment.getId();
        for (DecisionTableEntity decisionTable : decisionTables) {
            if (tenantId != null) {
                decisionTable.setTenantId(tenantId);
            }
            decisionTable.setDeploymentId(deploymentId);
        }
    }

    public void setResourceNamesOnDecisionTables(ParsedDeployment parsedDeployment) {
        for (DecisionTableEntity decisionTable : parsedDeployment.getAllDecisionTables()) {
            String resourceName = parsedDeployment.getResourceForDecisionTable(decisionTable).getName();
            decisionTable.setResourceName(resourceName);
        }
    }

    public DecisionTableEntity getMostRecentVersionOfDecisionTable(DecisionTableEntity decisionTable) {
        String key = decisionTable.getKey();
        String tenantId = decisionTable.getTenantId();
        DecisionTableEntityManager decisionTableEntityManager = Context.getCommandContext().getDmnEngineConfiguration().getDecisionTableEntityManager();
        DecisionTableEntity existingDefinition = null;
        existingDefinition = tenantId != null && !tenantId.equals("") ? decisionTableEntityManager.findLatestDecisionTableByKeyAndTenantId(key, tenantId) : decisionTableEntityManager.findLatestDecisionTableByKey(key);
        return existingDefinition;
    }

    public DecisionTableEntity getPersistedInstanceOfDecisionTable(DecisionTableEntity decisionTable) {
        String deploymentId = decisionTable.getDeploymentId();
        if (StringUtils.isEmpty((CharSequence)decisionTable.getDeploymentId())) {
            throw new ActivitiDmnIllegalArgumentException("Provided process definition must have a deployment id.");
        }
        DecisionTableEntityManager decisionTableEntityManager = Context.getCommandContext().getDmnEngineConfiguration().getDecisionTableEntityManager();
        DecisionTableEntity persistedDecisionTable = null;
        persistedDecisionTable = decisionTable.getTenantId() == null || "".equals(decisionTable.getTenantId()) ? decisionTableEntityManager.findDecisionTableByDeploymentAndKey(deploymentId, decisionTable.getKey()) : decisionTableEntityManager.findDecisionTableByDeploymentAndKeyAndTenantId(deploymentId, decisionTable.getKey(), decisionTable.getTenantId());
        return persistedDecisionTable;
    }
}

