/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.persistence.entity.data.impl;

import java.util.List;
import java.util.Map;
import org.activiti.dmn.api.DmnDeployment;
import org.activiti.dmn.engine.DmnEngineConfiguration;
import org.activiti.dmn.engine.impl.DmnDeploymentQueryImpl;
import org.activiti.dmn.engine.impl.Page;
import org.activiti.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.activiti.dmn.engine.impl.persistence.entity.DmnDeploymentEntityImpl;
import org.activiti.dmn.engine.impl.persistence.entity.data.AbstractDataManager;
import org.activiti.dmn.engine.impl.persistence.entity.data.DmnDeploymentDataManager;

public class MybatisDmnDeploymentDataManager
extends AbstractDataManager<DmnDeploymentEntity>
implements DmnDeploymentDataManager {
    public MybatisDmnDeploymentDataManager(DmnEngineConfiguration dmnEngineConfiguration) {
        super(dmnEngineConfiguration);
    }

    @Override
    public Class<? extends DmnDeploymentEntity> getManagedEntityClass() {
        return DmnDeploymentEntityImpl.class;
    }

    @Override
    public DmnDeploymentEntity create() {
        return new DmnDeploymentEntityImpl();
    }

    @Override
    public DmnDeploymentEntity findLatestDeploymentByName(String deploymentName) {
        List list = this.getDbSqlSession().selectList("selectDeploymentsByName", deploymentName, 0, 1);
        if (list != null && !list.isEmpty()) {
            return (DmnDeploymentEntity)list.get(0);
        }
        return null;
    }

    @Override
    public long findDeploymentCountByQueryCriteria(DmnDeploymentQueryImpl deploymentQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectDeploymentCountByQueryCriteria", deploymentQuery);
    }

    @Override
    public List<DmnDeployment> findDeploymentsByQueryCriteria(DmnDeploymentQueryImpl deploymentQuery, Page page) {
        String query = "selectDeploymentsByQueryCriteria";
        return this.getDbSqlSession().selectList("selectDeploymentsByQueryCriteria", deploymentQuery, page);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.getDbSqlSession().getSqlSession().selectList("selectResourceNamesByDeploymentId", (Object)deploymentId);
    }

    @Override
    public List<DmnDeployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectDeploymentByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectDeploymentCountByNativeQuery", parameterMap);
    }
}

