/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.test;

import java.util.ArrayList;
import java.util.List;
import org.activiti.dmn.api.DmnRepositoryService;
import org.activiti.dmn.engine.ActivitiDmnException;
import org.activiti.dmn.engine.DmnEngine;
import org.activiti.dmn.engine.DmnEngineConfiguration;
import org.activiti.dmn.engine.test.DmnTestHelper;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class ActivitiDmnRule
implements TestRule {
    protected String configurationResource = "activiti.dmn.cfg.xml";
    protected String deploymentId;
    protected DmnEngineConfiguration dmnEngineConfiguration;
    protected DmnEngine dmnEngine;
    protected DmnRepositoryService repositoryService;

    public ActivitiDmnRule() {
    }

    public ActivitiDmnRule(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public ActivitiDmnRule(DmnEngine dmnEngine) {
        this.setDmnEngine(dmnEngine);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                ActivitiDmnRule.this.startingQuietly(description, errors);
                try {
                    base.evaluate();
                    ActivitiDmnRule.this.succeededQuietly(description, errors);
                }
                catch (AssumptionViolatedException e) {
                    errors.add(e);
                    ActivitiDmnRule.this.skippedQuietly(e, description, errors);
                }
                catch (Throwable t) {
                    errors.add(t);
                    ActivitiDmnRule.this.failedQuietly(t, description, errors);
                }
                finally {
                    ActivitiDmnRule.this.finishedQuietly(description, errors);
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    private void succeededQuietly(Description description, List<Throwable> errors) {
        try {
            this.succeeded(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void failedQuietly(Throwable t, Description description, List<Throwable> errors) {
        try {
            this.failed(t, description);
        }
        catch (Throwable t1) {
            errors.add(t1);
        }
    }

    private void skippedQuietly(AssumptionViolatedException e, Description description, List<Throwable> errors) {
        try {
            this.skipped(e, description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void startingQuietly(Description description, List<Throwable> errors) {
        try {
            this.starting(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void finishedQuietly(Description description, List<Throwable> errors) {
        try {
            this.finished(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable e, Description description) {
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
    }

    protected void starting(Description description) {
        if (this.dmnEngine == null) {
            this.initializeDmnEngine();
        }
        if (this.dmnEngineConfiguration == null) {
            this.initializeServices();
        }
        this.configureDmnEngine();
        try {
            this.deploymentId = DmnTestHelper.annotationDeploymentSetUp(this.dmnEngine, Class.forName(description.getClassName()), description.getMethodName());
        }
        catch (ClassNotFoundException e) {
            throw new ActivitiDmnException("Programmatic error: could not instantiate " + description.getClassName(), e);
        }
    }

    protected void initializeDmnEngine() {
        this.dmnEngine = DmnTestHelper.getDmnEngine(this.configurationResource);
    }

    protected void initializeServices() {
        this.dmnEngineConfiguration = this.dmnEngine.getDmnEngineConfiguration();
        this.repositoryService = this.dmnEngine.getDmnRepositoryService();
    }

    protected void configureDmnEngine() {
    }

    protected void finished(Description description) {
        try {
            DmnTestHelper.annotationDeploymentTearDown(this.dmnEngine, this.deploymentId, Class.forName(description.getClassName()), description.getMethodName());
        }
        catch (ClassNotFoundException e) {
            throw new ActivitiDmnException("Programmatic error: could not instantiate " + description.getClassName(), e);
        }
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public DmnEngine getDmnEngine() {
        return this.dmnEngine;
    }

    public void setDmnEngine(DmnEngine dmnEngine) {
        this.dmnEngine = dmnEngine;
        this.initializeServices();
    }

    public DmnRepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(DmnRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setDmnEngineConfiguration(DmnEngineConfiguration dmnEngineConfiguration) {
        this.dmnEngineConfiguration = dmnEngineConfiguration;
    }
}

