/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.identity.Group;
import org.activiti.engine.impl.AbstractVariableQueryImpl;
import org.activiti.engine.impl.HistoricTaskInstanceQueryProperty;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.QueryVariableValue;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.variable.VariableTypes;

public class HistoricTaskInstanceQueryImpl
extends AbstractVariableQueryImpl<HistoricTaskInstanceQuery, HistoricTaskInstance>
implements HistoricTaskInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionKeyLike;
    protected String processDefinitionName;
    protected String processDefinitionNameLike;
    protected String processInstanceId;
    protected String processInstanceBusinessKey;
    protected String processInstanceBusinessKeyLike;
    protected String executionId;
    protected String taskId;
    protected String taskName;
    protected String taskNameLike;
    protected String taskParentTaskId;
    protected String taskDescription;
    protected String taskDescriptionLike;
    protected String taskDeleteReason;
    protected String taskDeleteReasonLike;
    protected String taskOwner;
    protected String taskOwnerLike;
    protected String taskAssignee;
    protected String taskAssigneeLike;
    protected String taskDefinitionKey;
    protected String taskDefinitionKeyLike;
    protected String candidateUser;
    protected String candidateGroup;
    private List<String> candidateGroups;
    protected String involvedUser;
    protected Integer taskPriority;
    protected Integer taskMinPriority;
    protected Integer taskMaxPriority;
    protected boolean finished;
    protected boolean unfinished;
    protected boolean processFinished;
    protected boolean processUnfinished;
    protected Date dueDate;
    protected Date dueAfter;
    protected Date dueBefore;
    protected boolean withoutDueDate = false;
    protected Date creationDate;
    protected Date creationAfterDate;
    protected Date creationBeforeDate;
    protected Date completedDate;
    protected Date completedAfterDate;
    protected Date completedBeforeDate;
    protected String category;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected boolean includeTaskLocalVariables = false;
    protected boolean includeProcessVariables = false;

    public HistoricTaskInstanceQueryImpl() {
    }

    public HistoricTaskInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        return commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricTaskInstance> executeList(CommandContext commandContext, Page page) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        if (this.includeTaskLocalVariables || this.includeProcessVariables) {
            return commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstancesAndVariablesByQueryCriteria(this);
        }
        return commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstancesByQueryCriteria(this);
    }

    @Override
    public HistoricTaskInstanceQueryImpl processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl processInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processDefinitionKeyLike(String processDefinitionKeyLike) {
        this.processDefinitionKeyLike = processDefinitionKeyLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processDefinitionNameLike(String processDefinitionNameLike) {
        this.processDefinitionNameLike = processDefinitionNameLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskNameLike(String taskNameLike) {
        this.taskNameLike = taskNameLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskParentTaskId(String parentTaskId) {
        this.taskParentTaskId = parentTaskId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDescriptionLike(String taskDescriptionLike) {
        this.taskDescriptionLike = taskDescriptionLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDeleteReason(String taskDeleteReason) {
        this.taskDeleteReason = taskDeleteReason;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDeleteReasonLike(String taskDeleteReasonLike) {
        this.taskDeleteReasonLike = taskDeleteReasonLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskAssignee(String taskAssignee) {
        this.taskAssignee = taskAssignee;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskAssigneeLike(String taskAssigneeLike) {
        this.taskAssigneeLike = taskAssigneeLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskOwner(String taskOwner) {
        this.taskOwner = taskOwner;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskOwnerLike(String taskOwnerLike) {
        this.taskOwnerLike = taskOwnerLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery finished() {
        this.finished = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery unfinished() {
        this.unfinished = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueEquals(String variableName, Object variableValue) {
        return (HistoricTaskInstanceQuery)this.variableValueEquals(variableName, variableValue);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueEquals(Object variableValue) {
        return (HistoricTaskInstanceQuery)this.variableValueEquals(variableValue);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueEqualsIgnoreCase(String name, String value) {
        return (HistoricTaskInstanceQuery)this.variableValueEqualsIgnoreCase(name, value);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueNotEqualsIgnoreCase(String name, String value) {
        return (HistoricTaskInstanceQuery)this.variableValueNotEqualsIgnoreCase(name, value);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueNotEquals(String variableName, Object variableValue) {
        return (HistoricTaskInstanceQuery)this.variableValueNotEquals(variableName, variableValue);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueGreaterThan(String name, Object value) {
        return (HistoricTaskInstanceQuery)this.variableValueGreaterThan(name, value);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueGreaterThanOrEqual(String name, Object value) {
        return (HistoricTaskInstanceQuery)this.variableValueGreaterThanOrEqual(name, value);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueLessThan(String name, Object value) {
        return (HistoricTaskInstanceQuery)this.variableValueLessThan(name, value);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueLessThanOrEqual(String name, Object value) {
        return (HistoricTaskInstanceQuery)this.variableValueLessThanOrEqual(name, value);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueLike(String name, String value) {
        return (HistoricTaskInstanceQuery)this.variableValueLike(name, value);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueEquals(String variableName, Object variableValue) {
        return (HistoricTaskInstanceQuery)this.variableValueEquals(variableName, variableValue, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueNotEquals(String variableName, Object variableValue) {
        return (HistoricTaskInstanceQuery)this.variableValueNotEquals(variableName, variableValue, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueEquals(Object variableValue) {
        return (HistoricTaskInstanceQuery)this.variableValueEquals(variableValue, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueEqualsIgnoreCase(String name, String value) {
        return (HistoricTaskInstanceQuery)this.variableValueEqualsIgnoreCase(name, value, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueNotEqualsIgnoreCase(String name, String value) {
        return (HistoricTaskInstanceQuery)this.variableValueNotEqualsIgnoreCase(name, value, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueGreaterThan(String name, Object value) {
        return (HistoricTaskInstanceQuery)this.variableValueGreaterThan(name, value, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueGreaterThanOrEqual(String name, Object value) {
        return (HistoricTaskInstanceQuery)this.variableValueGreaterThanOrEqual(name, value, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueLessThan(String name, Object value) {
        return (HistoricTaskInstanceQuery)this.variableValueLessThan(name, value, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueLessThanOrEqual(String name, Object value) {
        return (HistoricTaskInstanceQuery)this.variableValueLessThanOrEqual(name, value, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueLike(String name, String value) {
        return (HistoricTaskInstanceQuery)this.variableValueLike(name, value, false);
    }

    @Override
    public HistoricTaskInstanceQuery taskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDefinitionKeyLike(String taskDefinitionKeyLike) {
        this.taskDefinitionKeyLike = taskDefinitionKeyLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskPriority(Integer taskPriority) {
        this.taskPriority = taskPriority;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskMinPriority(Integer taskMinPriority) {
        this.taskMinPriority = taskMinPriority;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskMaxPriority(Integer taskMaxPriority) {
        this.taskMaxPriority = taskMaxPriority;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processFinished() {
        this.processFinished = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processUnfinished() {
        this.processUnfinished = true;
        return this;
    }

    @Override
    protected void ensureVariablesInitialized() {
        VariableTypes types = Context.getProcessEngineConfiguration().getVariableTypes();
        for (QueryVariableValue var : this.queryVariableValues) {
            var.initialize(types);
        }
    }

    @Override
    public HistoricTaskInstanceQuery taskDueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDueAfter(Date dueAfter) {
        this.dueAfter = dueAfter;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDueBefore(Date dueBefore) {
        this.dueBefore = dueBefore;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCreatedOn(Date creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCreatedBefore(Date creationBeforeDate) {
        this.creationBeforeDate = creationBeforeDate;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCreatedAfter(Date creationAfterDate) {
        this.creationAfterDate = creationAfterDate;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCompletedOn(Date completedDate) {
        this.completedDate = completedDate;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCompletedBefore(Date completedBeforeDate) {
        this.completedBeforeDate = completedBeforeDate;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCompletedAfter(Date completedAfterDate) {
        this.completedAfterDate = completedAfterDate;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery withoutTaskDueDate() {
        this.withoutDueDate = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCategory(String category) {
        this.category = category;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCandidateUser(String candidateUser) {
        if (candidateUser == null) {
            throw new ActivitiIllegalArgumentException("Candidate user is null");
        }
        if (this.candidateGroup != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateUser and candidateGroup");
        }
        if (this.candidateGroups != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateUser and candidateGroupIn");
        }
        this.candidateUser = candidateUser;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCandidateGroup(String candidateGroup) {
        if (candidateGroup == null) {
            throw new ActivitiIllegalArgumentException("Candidate group is null");
        }
        if (this.candidateUser != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroup and candidateUser");
        }
        if (this.candidateGroups != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroup and candidateGroupIn");
        }
        this.candidateGroup = candidateGroup;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCandidateGroupIn(List<String> candidateGroups) {
        if (candidateGroups == null) {
            throw new ActivitiIllegalArgumentException("Candidate group list is null");
        }
        if (candidateGroups.size() == 0) {
            throw new ActivitiIllegalArgumentException("Candidate group list is empty");
        }
        if (this.candidateUser != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroupIn and candidateUser");
        }
        if (this.candidateGroup != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroupIn and candidateGroup");
        }
        this.candidateGroups = candidateGroups;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskInvolvedUser(String involvedUser) {
        this.involvedUser = involvedUser;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskTenantId(String tenantId) {
        if (tenantId == null) {
            throw new ActivitiIllegalArgumentException("task tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new ActivitiIllegalArgumentException("task tenant id is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery includeTaskLocalVariables() {
        this.includeTaskLocalVariables = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery includeProcessVariables() {
        this.includeProcessVariables = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByTaskId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.HISTORIC_TASK_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByHistoricActivityInstanceId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.PROCESS_DEFINITION_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByProcessDefinitionId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.PROCESS_DEFINITION_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByProcessInstanceId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByExecutionId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.EXECUTION_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByHistoricTaskInstanceDuration() {
        this.orderBy(HistoricTaskInstanceQueryProperty.DURATION);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByHistoricTaskInstanceEndTime() {
        this.orderBy(HistoricTaskInstanceQueryProperty.END);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByHistoricActivityInstanceStartTime() {
        this.orderBy(HistoricTaskInstanceQueryProperty.START);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByHistoricTaskInstanceStartTime() {
        this.orderBy(HistoricTaskInstanceQueryProperty.START);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByTaskName() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_NAME);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByTaskDescription() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DESCRIPTION);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskAssignee() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_ASSIGNEE);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskOwner() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_OWNER);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskDueDate() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DUE_DATE);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByDeleteReason() {
        this.orderBy(HistoricTaskInstanceQueryProperty.DELETE_REASON);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskDefinitionKey() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DEFINITION_KEY);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskPriority() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_PRIORITY);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTenantId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TENANT_ID_);
        return this;
    }

    @Override
    protected void checkQueryOk() {
        super.checkQueryOk();
        if (this.includeProcessVariables || this.includeTaskLocalVariables) {
            ((HistoricTaskInstanceQuery)this.orderBy(HistoricTaskInstanceQueryProperty.INCLUDED_VARIABLE_TIME)).asc();
        }
    }

    public String getMssqlOrDB2OrderBy() {
        String specialOrderBy = super.getOrderBy();
        if (specialOrderBy != null && specialOrderBy.length() > 0) {
            specialOrderBy = specialOrderBy.replace("RES.", "TEMPRES_");
            specialOrderBy = specialOrderBy.replace("VAR.", "TEMPVAR_");
        }
        return specialOrderBy;
    }

    public List<String> getCandidateGroups() {
        if (this.candidateGroup != null) {
            ArrayList<String> candidateGroupList = new ArrayList<String>(1);
            candidateGroupList.add(this.candidateGroup);
            return candidateGroupList;
        }
        if (this.candidateUser != null) {
            return this.getGroupsForCandidateUser(this.candidateUser);
        }
        if (this.candidateGroups != null) {
            return this.candidateGroups;
        }
        return null;
    }

    protected List<String> getGroupsForCandidateUser(String candidateUser) {
        List<Group> groups = Context.getCommandContext().getGroupIdentityManager().findGroupsByUser(candidateUser);
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessInstanceBusinessKey() {
        return this.processInstanceBusinessKey;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isUnfinished() {
        return this.unfinished;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskNameLike() {
        return this.taskNameLike;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public String getTaskDescriptionLike() {
        return this.taskDescriptionLike;
    }

    public String getTaskDeleteReason() {
        return this.taskDeleteReason;
    }

    public String getTaskDeleteReasonLike() {
        return this.taskDeleteReasonLike;
    }

    public String getTaskAssignee() {
        return this.taskAssignee;
    }

    public String getTaskAssigneeLike() {
        return this.taskAssigneeLike;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public String getTaskOwnerLike() {
        return this.taskOwnerLike;
    }

    public String getTaskOwner() {
        return this.taskOwner;
    }

    public String getTaskParentTaskId() {
        return this.taskParentTaskId;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }
}

