/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cmd.StartProcessInstanceCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerStartEventJobHandler
implements JobHandler {
    private static Logger log = LoggerFactory.getLogger(TimerStartEventJobHandler.class);
    public static final String TYPE = "timer-start-event";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        DeploymentManager deploymentCache = Context.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinitionEntity processDefinition = null;
        processDefinition = job.getTenantId() == null || "".equals(job.getTenantId()) ? deploymentCache.findDeployedLatestProcessDefinitionByKey(configuration) : deploymentCache.findDeployedLatestProcessDefinitionByKeyAndTenantId(configuration, job.getTenantId());
        if (processDefinition == null) {
            throw new ActivitiException("Could not find process definition needed for timer start event");
        }
        try {
            if (!processDefinition.isSuspended()) {
                if (commandContext.getEventDispatcher().isEnabled()) {
                    commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TIMER_FIRED, job));
                }
                new StartProcessInstanceCmd(configuration, null, null, null, job.getTenantId()).execute(commandContext);
            } else {
                log.debug("ignoring timer of suspended process definition {}", (Object)processDefinition.getName());
            }
        }
        catch (RuntimeException e) {
            log.error("exception during timer execution", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("exception during timer execution", (Throwable)e);
            throw new ActivitiException("exception during timer execution: " + e.getMessage(), e);
        }
    }
}

