/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.scripting;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.bpmn.data.ItemInstance;
import org.activiti.engine.impl.el.ExpressionFactoryResolver;
import org.activiti.engine.impl.javax.el.ArrayELResolver;
import org.activiti.engine.impl.javax.el.BeanELResolver;
import org.activiti.engine.impl.javax.el.CompositeELResolver;
import org.activiti.engine.impl.javax.el.DynamicBeanPropertyELResolver;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ELException;
import org.activiti.engine.impl.javax.el.ELResolver;
import org.activiti.engine.impl.javax.el.ExpressionFactory;
import org.activiti.engine.impl.javax.el.FunctionMapper;
import org.activiti.engine.impl.javax.el.ListELResolver;
import org.activiti.engine.impl.javax.el.MapELResolver;
import org.activiti.engine.impl.javax.el.ResourceBundleELResolver;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.javax.el.VariableMapper;
import org.activiti.engine.impl.juel.SimpleResolver;
import org.activiti.engine.impl.scripting.JuelScriptEngineFactory;
import org.activiti.engine.impl.util.ReflectUtil;

public class JuelScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private ScriptEngineFactory scriptEngineFactory;
    private ExpressionFactory expressionFactory;

    public JuelScriptEngine(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineFactory = scriptEngineFactory;
        this.expressionFactory = ExpressionFactoryResolver.resolveExpressionFactory();
    }

    public JuelScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        ValueExpression expr = this.parse(script, this.context);
        return new JuelCompiledScript(expr);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    @Override
    public Object eval(String script, ScriptContext scriptContext) throws ScriptException {
        ValueExpression expr = this.parse(script, scriptContext);
        return this.evaluateExpression(expr, scriptContext);
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return this.eval(this.readFully(reader), scriptContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        JuelScriptEngine juelScriptEngine = this;
        synchronized (juelScriptEngine) {
            if (this.scriptEngineFactory == null) {
                this.scriptEngineFactory = new JuelScriptEngineFactory();
            }
        }
        return this.scriptEngineFactory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    private Object evaluateExpression(ValueExpression expr, ScriptContext ctx) throws ScriptException {
        try {
            return expr.getValue(this.createElContext(ctx));
        }
        catch (ELException elexp) {
            throw new ScriptException(elexp);
        }
    }

    private ELResolver createElResolver() {
        CompositeELResolver compositeResolver = new CompositeELResolver();
        compositeResolver.add(new ArrayELResolver());
        compositeResolver.add(new ListELResolver());
        compositeResolver.add(new MapELResolver());
        compositeResolver.add(new ResourceBundleELResolver());
        compositeResolver.add(new DynamicBeanPropertyELResolver(ItemInstance.class, "getFieldValue", "setFieldValue"));
        compositeResolver.add(new BeanELResolver());
        return new SimpleResolver(compositeResolver);
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] array = new char[8192];
        StringBuilder strBuffer = new StringBuilder();
        try {
            int count;
            while ((count = reader.read(array, 0, array.length)) > 0) {
                strBuffer.append(array, 0, count);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return strBuffer.toString();
    }

    private ValueExpression parse(String script, ScriptContext scriptContext) throws ScriptException {
        try {
            return this.expressionFactory.createValueExpression(this.createElContext(scriptContext), script, Object.class);
        }
        catch (ELException ele) {
            throw new ScriptException(ele);
        }
    }

    private ELContext createElContext(final ScriptContext scriptCtx) {
        Object existingELCtx = scriptCtx.getAttribute("elcontext");
        if (existingELCtx instanceof ELContext) {
            return (ELContext)existingELCtx;
        }
        scriptCtx.setAttribute("context", scriptCtx, 100);
        scriptCtx.setAttribute("out:print", JuelScriptEngine.getPrintMethod(), 100);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            scriptCtx.setAttribute("lang:import", JuelScriptEngine.getImportMethod(), 100);
        }
        ELContext elContext = new ELContext(){
            ELResolver resolver;
            VariableMapper varMapper;
            FunctionMapper funcMapper;
            {
                this.resolver = JuelScriptEngine.this.createElResolver();
                this.varMapper = new ScriptContextVariableMapper(scriptCtx);
                this.funcMapper = new ScriptContextFunctionMapper(scriptCtx);
            }

            @Override
            public ELResolver getELResolver() {
                return this.resolver;
            }

            @Override
            public VariableMapper getVariableMapper() {
                return this.varMapper;
            }

            @Override
            public FunctionMapper getFunctionMapper() {
                return this.funcMapper;
            }
        };
        scriptCtx.setAttribute("elcontext", elContext, 100);
        return elContext;
    }

    private static Method getPrintMethod() {
        try {
            return JuelScriptEngine.class.getMethod("print", Object.class);
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static void print(Object object) {
        System.out.print(object);
    }

    private static Method getImportMethod() {
        try {
            return JuelScriptEngine.class.getMethod("importFunctions", ScriptContext.class, String.class, Object.class);
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static void importFunctions(ScriptContext ctx, String namespace, Object obj) {
        Method[] methods;
        Class<?> clazz = null;
        if (obj instanceof Class) {
            clazz = (Class<?>)obj;
        } else if (obj instanceof String) {
            try {
                clazz = ReflectUtil.loadClass((String)obj);
            }
            catch (ActivitiException ae) {
                throw new ELException(ae);
            }
        } else {
            throw new ELException("Class or class name is missing");
        }
        for (Method m : methods = clazz.getMethods()) {
            int mod = m.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            String name = namespace + ":" + m.getName();
            ctx.setAttribute(name, m, 100);
        }
    }

    private class ScriptContextFunctionMapper
    extends FunctionMapper {
        private ScriptContext scriptContext;

        ScriptContextFunctionMapper(ScriptContext ctx) {
            this.scriptContext = ctx;
        }

        private String getFullFunctionName(String prefix, String localName) {
            return prefix + ":" + localName;
        }

        @Override
        public Method resolveFunction(String prefix, String localName) {
            String functionName = this.getFullFunctionName(prefix, localName);
            int scope = this.scriptContext.getAttributesScope(functionName);
            if (scope != -1) {
                Object attributeValue = this.scriptContext.getAttribute(functionName);
                return attributeValue instanceof Method ? (Method)attributeValue : null;
            }
            return null;
        }
    }

    private class ScriptContextVariableMapper
    extends VariableMapper {
        private ScriptContext scriptContext;

        ScriptContextVariableMapper(ScriptContext scriptCtx) {
            this.scriptContext = scriptCtx;
        }

        @Override
        public ValueExpression resolveVariable(String variableName) {
            int scope = this.scriptContext.getAttributesScope(variableName);
            if (scope != -1) {
                Object value = this.scriptContext.getAttribute(variableName, scope);
                if (value instanceof ValueExpression) {
                    return (ValueExpression)value;
                }
                return JuelScriptEngine.this.expressionFactory.createValueExpression(value, Object.class);
            }
            return null;
        }

        @Override
        public ValueExpression setVariable(String name, ValueExpression value) {
            ValueExpression previousValue = this.resolveVariable(name);
            this.scriptContext.setAttribute(name, value, 100);
            return previousValue;
        }
    }

    private class JuelCompiledScript
    extends CompiledScript {
        private ValueExpression valueExpression;

        JuelCompiledScript(ValueExpression valueExpression) {
            this.valueExpression = valueExpression;
        }

        @Override
        public ScriptEngine getEngine() {
            return JuelScriptEngine.this;
        }

        @Override
        public Object eval(ScriptContext ctx) throws ScriptException {
            return JuelScriptEngine.this.evaluateExpression(this.valueExpression, ctx);
        }
    }
}

