/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.deployer;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.BpmnParser;
import org.activiti.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.cmd.CancelJobsCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti.engine.impl.persistence.deploy.Deployer;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnDeployer
implements Deployer {
    private static final Logger log = LoggerFactory.getLogger(BpmnDeployer.class);
    public static final String[] BPMN_RESOURCE_SUFFIXES = new String[]{"bpmn20.xml", "bpmn"};
    public static final String[] DIAGRAM_SUFFIXES = new String[]{"png", "jpg", "gif", "svg"};
    protected ExpressionManager expressionManager;
    protected BpmnParser bpmnParser;
    protected IdGenerator idGenerator;

    @Override
    public void deploy(DeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        log.debug("Processing deployment {}", (Object)deployment.getName());
        ArrayList<ProcessDefinitionEntity> processDefinitions = new ArrayList<ProcessDefinitionEntity>();
        Map<String, ResourceEntity> resources = deployment.getResources();
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        for (String resourceName : resources.keySet()) {
            log.info("Processing resource {}", (Object)resourceName);
            if (!this.isBpmnResource(resourceName)) continue;
            ResourceEntity resource = resources.get(resourceName);
            byte[] bytes = resource.getBytes();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            BpmnParse bpmnParse = this.bpmnParser.createParse().sourceInputStream(inputStream).deployment(deployment).name(resourceName);
            if (deploymentSettings != null) {
                if (deploymentSettings.containsKey("isBpmn20XsdValidationEnabled")) {
                    bpmnParse.setValidateSchema((Boolean)deploymentSettings.get("isBpmn20XsdValidationEnabled"));
                }
                if (deploymentSettings.containsKey("isProcessValidationEnabled")) {
                    bpmnParse.setValidateProcess((Boolean)deploymentSettings.get("isProcessValidationEnabled"));
                }
            } else {
                bpmnParse.setValidateSchema(false);
                bpmnParse.setValidateProcess(false);
            }
            bpmnParse.execute();
            for (ProcessDefinitionEntity processDefinition : bpmnParse.getProcessDefinitions()) {
                processDefinition.setResourceName(resourceName);
                if (deployment.getTenantId() != null) {
                    processDefinition.setTenantId(deployment.getTenantId());
                }
                String diagramResourceName = this.getDiagramResourceForProcess(resourceName, processDefinition.getKey(), resources);
                if (deployment.isNew() && processEngineConfiguration.isCreateDiagramOnDeploy() && diagramResourceName == null && processDefinition.isGraphicalNotationDefined()) {
                    try {
                        byte[] diagramBytes = IoUtil.readInputStream(processEngineConfiguration.getProcessDiagramGenerator().generateDiagram(bpmnParse.getBpmnModel(), "png", processEngineConfiguration.getActivityFontName(), processEngineConfiguration.getLabelFontName(), processEngineConfiguration.getClassLoader()), null);
                        diagramResourceName = this.getProcessImageResourceName(resourceName, processDefinition.getKey(), "png");
                        this.createResource(diagramResourceName, diagramBytes, deployment);
                    }
                    catch (Throwable t) {
                        log.warn("Error while generating process diagram, image will not be stored in repository", t);
                    }
                }
                processDefinition.setDiagramResourceName(diagramResourceName);
                processDefinitions.add(processDefinition);
            }
        }
        ArrayList<String> keyList = new ArrayList<String>();
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            if (keyList.contains(processDefinition.getKey())) {
                throw new ActivitiException("The deployment contains process definitions with the same key (process id atrribute), this is not allowed");
            }
            keyList.add(processDefinition.getKey());
        }
        CommandContext commandContext = Context.getCommandContext();
        ProcessDefinitionEntityManager processDefinitionManager = commandContext.getProcessDefinitionEntityManager();
        DbSqlSession dbSqlSession = commandContext.getSession(DbSqlSession.class);
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            ArrayList<TimerEntity> timers = new ArrayList<TimerEntity>();
            if (deployment.isNew()) {
                ProcessDefinitionEntity latestProcessDefinition = null;
                latestProcessDefinition = processDefinition.getTenantId() != null && !"".equals(processDefinition.getTenantId()) ? processDefinitionManager.findLatestProcessDefinitionByKeyAndTenantId(processDefinition.getKey(), processDefinition.getTenantId()) : processDefinitionManager.findLatestProcessDefinitionByKey(processDefinition.getKey());
                int processDefinitionVersion = latestProcessDefinition != null ? latestProcessDefinition.getVersion() + 1 : 1;
                processDefinition.setVersion(processDefinitionVersion);
                processDefinition.setDeploymentId(deployment.getId());
                String nextId = this.idGenerator.getNextId();
                String processDefinitionId = processDefinition.getKey() + ":" + processDefinition.getVersion() + ":" + nextId;
                if (processDefinitionId.length() > 64) {
                    processDefinitionId = nextId;
                }
                processDefinition.setId(processDefinitionId);
                if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                    commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, processDefinition));
                }
                this.removeObsoleteTimers(processDefinition);
                this.addTimerDeclarations(processDefinition, timers);
                this.removeObsoleteMessageEventSubscriptions(processDefinition, latestProcessDefinition);
                this.addMessageEventSubscriptions(processDefinition);
                this.removeObsoleteSignalEventSubScription(processDefinition, latestProcessDefinition);
                this.addSignalEventSubscriptions(processDefinition);
                dbSqlSession.insert(processDefinition);
                this.addAuthorizations(processDefinition);
                if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                    commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, processDefinition));
                }
                this.scheduleTimers(timers);
            } else {
                String deploymentId = deployment.getId();
                processDefinition.setDeploymentId(deploymentId);
                ProcessDefinitionEntity persistedProcessDefinition = null;
                persistedProcessDefinition = processDefinition.getTenantId() == null || "".equals(processDefinition.getTenantId()) ? processDefinitionManager.findProcessDefinitionByDeploymentAndKey(deploymentId, processDefinition.getKey()) : processDefinitionManager.findProcessDefinitionByDeploymentAndKeyAndTenantId(deploymentId, processDefinition.getKey(), processDefinition.getTenantId());
                if (persistedProcessDefinition != null) {
                    processDefinition.setId(persistedProcessDefinition.getId());
                    processDefinition.setVersion(persistedProcessDefinition.getVersion());
                    processDefinition.setSuspensionState(persistedProcessDefinition.getSuspensionState());
                }
            }
            processEngineConfiguration.getDeploymentManager().getProcessDefinitionCache().add(processDefinition.getId(), processDefinition);
            deployment.addDeployedArtifact(processDefinition);
        }
    }

    private void scheduleTimers(List<TimerEntity> timers) {
        for (TimerEntity timer : timers) {
            Context.getCommandContext().getJobEntityManager().schedule(timer);
        }
    }

    protected void addTimerDeclarations(ProcessDefinitionEntity processDefinition, List<TimerEntity> timers) {
        List timerDeclarations = (List)processDefinition.getProperty("timerStart");
        if (timerDeclarations != null) {
            for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                TimerEntity timer = timerDeclaration.prepareTimerEntity(null);
                timer.setProcessDefinitionId(processDefinition.getId());
                if (processDefinition.getTenantId() != null) {
                    timer.setTenantId(processDefinition.getTenantId());
                }
                timers.add(timer);
            }
        }
    }

    protected void removeObsoleteTimers(ProcessDefinitionEntity processDefinition) {
        List<Job> jobsToDelete = Context.getCommandContext().getJobEntityManager().findJobsByConfiguration("timer-start-event", processDefinition.getKey());
        for (Job job : jobsToDelete) {
            new CancelJobsCmd(job.getId()).execute(Context.getCommandContext());
        }
    }

    protected void removeObsoleteMessageEventSubscriptions(ProcessDefinitionEntity processDefinition, ProcessDefinitionEntity latestProcessDefinition) {
        if (latestProcessDefinition != null) {
            CommandContext commandContext = Context.getCommandContext();
            List<EventSubscriptionEntity> subscriptionsToDelete = commandContext.getEventSubscriptionEntityManager().findEventSubscriptionsByConfiguration("message", latestProcessDefinition.getId(), latestProcessDefinition.getTenantId());
            for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsToDelete) {
                eventSubscriptionEntity.delete();
            }
        }
    }

    protected void addMessageEventSubscriptions(ProcessDefinitionEntity processDefinition) {
        CommandContext commandContext = Context.getCommandContext();
        List eventDefinitions = (List)processDefinition.getProperty("eventDefinitions");
        if (eventDefinitions != null) {
            for (EventSubscriptionDeclaration eventDefinition : eventDefinitions) {
                if (!eventDefinition.getEventType().equals("message") || !eventDefinition.isStartEvent()) continue;
                List<EventSubscriptionEntity> subscriptionsForSameMessageName = commandContext.getEventSubscriptionEntityManager().findEventSubscriptionsByName("message", eventDefinition.getEventName(), processDefinition.getTenantId());
                List<MessageEventSubscriptionEntity> cachedSubscriptions = commandContext.getDbSqlSession().findInCache(MessageEventSubscriptionEntity.class);
                for (MessageEventSubscriptionEntity cachedSubscription : cachedSubscriptions) {
                    if (!eventDefinition.getEventName().equals(cachedSubscription.getEventName()) || subscriptionsForSameMessageName.contains(cachedSubscription)) continue;
                    subscriptionsForSameMessageName.add(cachedSubscription);
                }
                subscriptionsForSameMessageName = commandContext.getDbSqlSession().pruneDeletedEntities(subscriptionsForSameMessageName);
                for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsForSameMessageName) {
                    if (eventSubscriptionEntity.getProcessInstanceId() != null && !eventSubscriptionEntity.getProcessInstanceId().isEmpty()) continue;
                    throw new ActivitiException("Cannot deploy process definition '" + processDefinition.getResourceName() + "': there already is a message event subscription for the message with name '" + eventDefinition.getEventName() + "'.");
                }
                MessageEventSubscriptionEntity newSubscription = new MessageEventSubscriptionEntity();
                newSubscription.setEventName(eventDefinition.getEventName());
                newSubscription.setActivityId(eventDefinition.getActivityId());
                newSubscription.setConfiguration(processDefinition.getId());
                if (processDefinition.getTenantId() != null) {
                    newSubscription.setTenantId(processDefinition.getTenantId());
                }
                newSubscription.insert();
            }
        }
    }

    protected void removeObsoleteSignalEventSubScription(ProcessDefinitionEntity processDefinition, ProcessDefinitionEntity latestProcessDefinition) {
        if (latestProcessDefinition != null) {
            CommandContext commandContext = Context.getCommandContext();
            List<EventSubscriptionEntity> subscriptionsToDelete = commandContext.getEventSubscriptionEntityManager().findEventSubscriptionsByConfiguration("signal", latestProcessDefinition.getId(), latestProcessDefinition.getTenantId());
            for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsToDelete) {
                eventSubscriptionEntity.delete();
            }
        }
    }

    protected void addSignalEventSubscriptions(ProcessDefinitionEntity processDefinition) {
        List eventDefinitions = (List)processDefinition.getProperty("eventDefinitions");
        if (eventDefinitions != null) {
            for (EventSubscriptionDeclaration eventDefinition : eventDefinitions) {
                if (!eventDefinition.getEventType().equals("signal") || !eventDefinition.isStartEvent()) continue;
                SignalEventSubscriptionEntity subscriptionEntity = new SignalEventSubscriptionEntity();
                subscriptionEntity.setEventName(eventDefinition.getEventName());
                subscriptionEntity.setActivityId(eventDefinition.getActivityId());
                subscriptionEntity.setProcessDefinitionId(processDefinition.getId());
                if (processDefinition.getTenantId() != null) {
                    subscriptionEntity.setTenantId(processDefinition.getTenantId());
                }
                subscriptionEntity.insert();
            }
        }
    }

    private void addAuthorizationsFromIterator(Set<Expression> exprSet, ProcessDefinitionEntity processDefinition, ExprType exprType) {
        if (exprSet != null) {
            for (Expression expr : exprSet) {
                IdentityLinkEntity identityLink = new IdentityLinkEntity();
                identityLink.setProcessDef(processDefinition);
                if (exprType.equals((Object)ExprType.USER)) {
                    identityLink.setUserId(expr.toString());
                } else if (exprType.equals((Object)ExprType.GROUP)) {
                    identityLink.setGroupId(expr.toString());
                }
                identityLink.setType("candidate");
                identityLink.insert();
            }
        }
    }

    protected void addAuthorizations(ProcessDefinitionEntity processDefinition) {
        this.addAuthorizationsFromIterator(processDefinition.getCandidateStarterUserIdExpressions(), processDefinition, ExprType.USER);
        this.addAuthorizationsFromIterator(processDefinition.getCandidateStarterGroupIdExpressions(), processDefinition, ExprType.GROUP);
    }

    protected String getDiagramResourceForProcess(String bpmnFileResource, String processKey, Map<String, ResourceEntity> resources) {
        for (String diagramSuffix : DIAGRAM_SUFFIXES) {
            String diagramForBpmnFileResource = this.getBpmnFileImageResourceName(bpmnFileResource, diagramSuffix);
            String processDiagramResource = this.getProcessImageResourceName(bpmnFileResource, processKey, diagramSuffix);
            if (resources.containsKey(processDiagramResource)) {
                return processDiagramResource;
            }
            if (!resources.containsKey(diagramForBpmnFileResource)) continue;
            return diagramForBpmnFileResource;
        }
        return null;
    }

    protected String getBpmnFileImageResourceName(String bpmnFileResource, String diagramSuffix) {
        String bpmnFileResourceBase = this.stripBpmnFileSuffix(bpmnFileResource);
        return bpmnFileResourceBase + diagramSuffix;
    }

    protected String getProcessImageResourceName(String bpmnFileResource, String processKey, String diagramSuffix) {
        String bpmnFileResourceBase = this.stripBpmnFileSuffix(bpmnFileResource);
        return bpmnFileResourceBase + processKey + "." + diagramSuffix;
    }

    protected String stripBpmnFileSuffix(String bpmnFileResource) {
        for (String suffix : BPMN_RESOURCE_SUFFIXES) {
            if (!bpmnFileResource.endsWith(suffix)) continue;
            return bpmnFileResource.substring(0, bpmnFileResource.length() - suffix.length());
        }
        return bpmnFileResource;
    }

    protected void createResource(String name, byte[] bytes, DeploymentEntity deploymentEntity) {
        ResourceEntity resource = new ResourceEntity();
        resource.setName(name);
        resource.setBytes(bytes);
        resource.setDeploymentId(deploymentEntity.getId());
        resource.setGenerated(true);
        Context.getCommandContext().getDbSqlSession().insert(resource);
    }

    protected boolean isBpmnResource(String resourceName) {
        for (String suffix : BPMN_RESOURCE_SUFFIXES) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public BpmnParser getBpmnParser() {
        return this.bpmnParser;
    }

    public void setBpmnParser(BpmnParser bpmnParser) {
        this.bpmnParser = bpmnParser;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    static enum ExprType {
        USER,
        GROUP;

    }
}

