/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;

public class VariableInstanceEntityManager
extends AbstractManager {
    public List<VariableInstanceEntity> findVariableInstancesByTaskId(String taskId) {
        return this.getDbSqlSession().selectList("selectVariablesByTaskId", taskId);
    }

    public List<VariableInstanceEntity> findVariableInstancesByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectVariablesByExecutionId", executionId);
    }

    public VariableInstanceEntity findVariableInstanceByExecutionAndName(String executionId, String variableName) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("executionId", executionId);
        params.put("name", variableName);
        return (VariableInstanceEntity)this.getDbSqlSession().selectOne("selectVariableInstanceByExecutionAndName", params);
    }

    public List<VariableInstanceEntity> findVariableInstancesByExecutionAndNames(String executionId, Collection<String> names) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("executionId", executionId);
        params.put("names", names);
        return this.getDbSqlSession().selectList("selectVariableInstancesByExecutionAndNames", params);
    }

    public VariableInstanceEntity findVariableInstanceByTaskAndName(String taskId, String variableName) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("taskId", taskId);
        params.put("name", variableName);
        return (VariableInstanceEntity)this.getDbSqlSession().selectOne("selectVariableInstanceByTaskAndName", params);
    }

    public List<VariableInstanceEntity> findVariableInstancesByTaskAndNames(String taskId, Collection<String> names) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("taskId", taskId);
        params.put("names", names);
        return this.getDbSqlSession().selectList("selectVariableInstancesByTaskAndNames", params);
    }

    public void deleteVariableInstanceByTask(TaskEntity task) {
        Map<String, VariableInstanceEntity> variableInstances = task.getVariableInstances();
        if (variableInstances != null) {
            for (VariableInstanceEntity variableInstance : variableInstances.values()) {
                variableInstance.delete();
            }
        }
    }
}

